package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.BaseTreeUtil;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.entity.*;
import com.geoway.jckj.biz.exception.BizException;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.sys.*;
import com.geoway.jckj.biz.service.dev.base.IMenuUrlHandlerService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

/**
 * 导航信息
 *
 * @author: wujing
 * @Date: 2021/11/11
 */
@Service
public class SysMenuServiceImpl extends MPJBaseServiceImpl<SysMenuMapper, SysMenu>
        implements SysMenuService, ISaasEntityService<SysMenu> {


    final String rootPid = "0";
    private final TreeNodeConfig treeNodeConfig =
            new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");

    public final static int  m_relPath = 1; //相对路径
    public final static int  m_absPath = 2; //绝对路径


    @Autowired
    private IMenuUrlHandlerService urlDynamicParameterService;
    @Autowired
    private SysMenuPathService sysMenuPathService;
    @Autowired
    SysTenantMenuService sysTenantMenuService;

    @Autowired
    SysSystemMapper sysSystemMapper;

    @Autowired
    SysTenantService sysTenantService;
    @Autowired
    SysRoleService sysRoleService;
    @Override
    public void saveOrUp(SysMenu menu) throws Exception {
        // 挂接菜单检查
        if (menu.getMenuType() == 2) {
            if (StrUtil.isBlank(menu.getPathId())) {
                throw new BizException("挂接菜单路径Id不能为空！");
            }
            if (StrUtil.isBlank(menu.getRelMenuId())) {
                throw new BizException("挂接菜单关联菜单Id不能为空！");
            }
        }
        LambdaQueryWrapper<SysMenu> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysMenu::getSystemId, menu.getSystemId());
        if (StrUtil.isNotBlank(menu.getId())){
            wrapper.ne(SysMenu::getId, menu.getId());
        }
        // 检查名称是否重复
        LambdaQueryWrapper<SysMenu> nameWrapper=wrapper.clone().eq(SysMenu::getName, menu.getName());
        nameWrapper.eq(SysMenu::getPid,menu.getPid());
        nameWrapper.eq(SysMenu::getGroup,menu.getGroup());
        if (this.count(nameWrapper) > 0) {
            throw new ServiceException("菜单名称:" + menu.getName() + " 已存在！");
        }
        // 检查key是否重复
        LambdaQueryWrapper<SysMenu> keyWrapper= wrapper.clone().eq(SysMenu::getKey, menu.getKey());
        if (this.count(keyWrapper) > 0) {
            throw new ServiceException("菜单关键字:" + menu.getKey() + " 已存在！");
        }

        //新增
        if (StrUtil.isBlank(menu.getId())) {
            // 排序
            LambdaQueryWrapper<SysMenu> brotherWrapper = wrapper.clone().eq(SysMenu::getPid, menu.getPid());
            List<SysMenu> brotherMenus=this.list(brotherWrapper);
            Integer sort=1;
            if(brotherMenus.size()>0){
                sort=brotherMenus.stream().flatMapToInt(f-> IntStream.of(f.getSort())).max().orElse(1)+1;
            }
            menu.setSort(sort);
            wrapperEntity(menu);
        } else {
            if (menu.getSort() == null) {
                throw new ServiceException("排序值不能为空！");
            }
        }
        SysSystem sysSystem=sysSystemMapper.selectById(menu.getSystemId());

        // 如果不是挂接菜单，则保存菜单路径
        if(sysSystem!=null&&sysSystem.getType()==1){
            SysMenuPath sysMenuPath;
            if (StrUtil.isBlank(menu.getPathId())) {
                sysMenuPath = new SysMenuPath();
                sysMenuPath.setPid(menu.getSystemId());
            } else {
                sysMenuPath = sysMenuPathService.getById(menu.getPathId());
            }
            if (StrUtil.isNotBlank(menu.getPath())) {
                sysMenuPath.setPath(menu.getPath());
            }
            if (menu.getPathType() != null) {
                sysMenuPath.setPathType(menu.getPathType());
            }
            sysMenuPathService.saveOrUpdate(sysMenuPath);
            menu.setPathId(sysMenuPath.getId());
        }
        // 保存/更新
        this.saveOrUpdate(menu);

    }

    @Override
    public List<SysMenu> queryMenuTree(String systemId, Integer group) {
        List<SysMenu> menus=queryMenuList(systemId,  group);
        List<SysMenu> menuTrees = BaseTreeUtil.listToTree(menus, treeNodeConfig, rootPid);
        return menuTrees;
    }

    private MPJLambdaWrapper<SysMenu> buildMenuMPJLambdaWrapper(String systemId, Integer group)  {
        SysSystem sysSystem=sysSystemMapper.selectById(systemId);
        MPJLambdaWrapper<SysMenu> queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysMenu::getSystemId, systemId);
        queryWrapper.leftJoin(SysMenuPath.class, SysMenuPath::getId, SysMenu::getPathId);
        if (StringUtils.isNotEmpty(getTenantId())&&!sysSystem.getTenantid().equals(getTenantId())) {
            queryWrapper.leftJoin(SysTenantMenu.class, SysTenantMenu::getMenuid,SysMenu::getId);
            queryWrapper.eq(SysTenantMenu::getTenantid,getTenantId());
        }
        //若指定了菜单分组则只查询此组里中的菜单
        if (group != null) {
            queryWrapper.eq(SysMenu::getGroup, group);
        }
        queryWrapper.selectAssociation(SysMenuPath.class, SysMenu::getMenuPath);
        queryWrapper.orderByAsc(SysMenu::getSort);
        return queryWrapper;
    }

    private List<SysMenu> queryParentMenuList(List<SysMenu> menus){
        List<SysMenu> parentMenus=new ArrayList<>();
        List<String> allPids=new ArrayList<>();
        this.queryAllPidsNoContains(menus, allPids);
        List<String> allIds = menus.stream().map(menuItem -> menuItem.getId()).collect(Collectors.toList());
        List<String> filterPids = allPids.stream().filter(pid -> !allIds.contains(pid)).collect(Collectors.toList());
        if (filterPids.size() > 0) {
            MPJLambdaWrapper<SysMenu> queryWrapper = MPJWrappers.lambdaJoin();
            queryWrapper.in(SysMenu::getId,filterPids);
            queryWrapper.leftJoin(SysMenuPath.class, SysMenuPath::getId, SysMenu::getPathId);
            queryWrapper.selectAssociation(SysMenuPath.class, SysMenu::getMenuPath);
            queryWrapper.orderByAsc(SysMenu::getSort);
            List<SysMenu> pMenus = this.selectJoinList(SysMenu.class,queryWrapper);
            parentMenus.addAll(pMenus);
        }
        return parentMenus;
    }


    @Override
    public List<SysMenu> queryMenuList(String systemId,Integer group) {
        List<SysMenu> menus=this.list(buildMenuMPJLambdaWrapper(systemId,group));
        List<SysMenu> pmenus=queryParentMenuList(menus);
        menus.addAll(pmenus);
        wrapperMenus(menus);
        return menus;
    }


    public void wrapperMenus(List<SysMenu> menus){
        for (SysMenu menu : menus) {
            SysMenuPath sysMenuPath = menu.getMenuPath(); //sysMenuPathService.getById(menu.getPathId());
            if (sysMenuPath != null) {
                menu.setPath(sysMenuPath.getPath());
                menu.setPathType(sysMenuPath.getPathType());
            }
        }
        wrapperMenuIsolate(menus);
        wrapperMenuAbsPath(menus);
    }

    @Override
    public void deleteMenu(String id) throws Exception {

        //判断是否存在子节点
        SysMenu menu = this.getById(id);
        if(menu == null){
            return;
        }
        LambdaQueryWrapper<SysMenu> baseWrapper = Wrappers.lambdaQuery();

        int count = this.count(baseWrapper.clone().eq(SysMenu::getPid, id));
        if (count > 0) {
            throw new BizException("存在子菜单,无法删除！");
        }

        List<SysMenu> relMenus = this.list(baseWrapper.clone().eq(SysMenu::getRelMenuId, id));
        if (relMenus.size()>0) {



            throw new BizException("菜单已挂接功能,无法删除,请取消挂接功能重试！");
        }
        String pathId = menu.getPathId();
        this.removeById(id);

        //删除无引用的pathId
        int iPathCount = this.count(baseWrapper.clone().eq(SysMenu::getPathId, pathId));
        if(iPathCount == 0 && StrUtil.isNotBlank(pathId)){
            this.sysMenuPathService.removeById(pathId);
        }

        //修改上级菜单类型
//        if (!rootPid.equals(pid)) {
//            LambdaUpdateWrapper<SysMenu> update = Wrappers.lambdaUpdate();
//            update.eq(SysMenu::getId, pid)
//                    .set(SysMenu::getType, 0);
//            this.update(update);
//        }
    }

    @Override
    public void sortUp(Integer flag, String id, String pid, String systemId, Integer sort) throws Exception {
        SysMenu menu = this.getById(id);
        if (menu == null) {
            return;
        }
        sort = menu.getSort();
        int otherSort = sort;
        if (flag != null) {
            //查询最小的记录
            LambdaUpdateWrapper<SysMenu> queryWrapper = Wrappers.lambdaUpdate();
            switch (flag) {
                //置顶
                case 1:
                    queryWrapper.eq(SysMenu::getPid, pid).eq(SysMenu::getSystemId, systemId).orderByAsc(SysMenu::getSort)
                            .last("limit 1");
                    SysMenu minInfo = this.list(queryWrapper).stream().findFirst().orElse(null);
                    if (minInfo != null && !minInfo.getSort().equals(sort)) {
                        Integer min = minInfo.getSort();
                        --sort;
                        //排序+1
                        for (; sort >= min; sort--) {
                            updateSort(pid, systemId, sort, sort + 1);
                        }
                        //置换
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, id).set(SysMenu::getSort, min));
                    } else {
                        throw new Exception("该条记录已经置顶了！");
                    }
                    break;
                //上移
                case 2:
                    //查询排序小一位的记录
                    queryWrapper.eq(SysMenu::getPid, pid)
                            .eq(SysMenu::getSystemId, systemId)
                            .lt(SysMenu::getSort, sort)
                            .orderByDesc(SysMenu::getSort);
                    SysMenu info = this.list(queryWrapper).stream().findFirst().orElse(null);
                    if (info != null && !info.getSort().equals(sort)) {
                        //相互置换
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, id).set(SysMenu::getSort, info.getSort()));
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, info.getId()).set(SysMenu::getSort, sort));
                    } else {
                        throw new Exception("该条记录已经置顶了！");
                    }
                    break;
                //下移
                case 3:
                    //查询排序大一位的记录
                    queryWrapper.eq(SysMenu::getPid, pid)
                            .eq(SysMenu::getSystemId, systemId)
                            .gt(SysMenu::getSort, sort)
                            .orderByAsc(SysMenu::getSort);
                    SysMenu one = this.list(queryWrapper).stream().findFirst().orElse(null);
                    if (one != null && !one.getSort().equals(sort)) {
                        //相互置换
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, id).set(SysMenu::getSort, one.getSort()));
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, one.getId()).set(SysMenu::getSort, sort));
                    } else {
                        throw new Exception("该条记录已经置底了！");
                    }
                    break;
                //置底
                case 4:
                    //查询最大的记录
                    queryWrapper.eq(SysMenu::getPid, pid).eq(SysMenu::getSystemId, systemId).orderByDesc(SysMenu::getSort)
                            .last("limit 1");
                    SysMenu maxInfo = this.list(queryWrapper).stream().findFirst().orElse(null);
                    if (maxInfo != null && !maxInfo.getSort().equals(sort)) {
                        Integer max = maxInfo.getSort();
                        ++sort;
                        //排序-1
                        for (; sort <= max; sort++) {
                            updateSort(pid, systemId, sort, sort - 1);
                        }
                        //置换
                        this.update(Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, id).set(SysMenu::getSort, max));
                    } else {
                        throw new Exception("该条记录已经置底了！");
                    }
                    break;
                default:
                    break;
            }

        }
    }


    @Override
    public void setDefault(String id) {
        SysMenu menu = this.getById(id);
        if(menu != null && StrUtil.isNotBlank(menu.getSystemId())){
            ////取消原默认菜单
            LambdaUpdateWrapper<SysMenu> updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(SysMenu::getSystemId, menu.getSystemId());
            updateWrapper.set(SysMenu::getIsdefault, 0);

            this.update(updateWrapper);

            updateWrapper.clear();
            //设置默认
            updateWrapper.eq(SysMenu::getId, id);
            updateWrapper.set(SysMenu::getIsdefault, 1);
            this.update(updateWrapper);
        }
    }

    private List<SysMenu> queryNoLoginMenuList(String systemId,Integer group){
        MPJLambdaWrapper<SysMenu> baseQueryWrapper =buildMenuMPJLambdaWrapper(systemId,group);
        baseQueryWrapper.eq(SysMenu::getNologin,1);
        List<SysMenu> noLoginMenus = this.selectJoinList(SysMenu.class, baseQueryWrapper);
        return noLoginMenus;
    }
    private List<SysMenu> queryLoginMenuList(String systemId,Integer group){
        if (StrUtil.isBlank(getQueryUserId())){
            return new ArrayList<>();
        }
        List<SysRole> sysRoles= sysRoleService.queryUserRoles(getQueryUserId());
        if(sysRoles.size()==0){
            return new ArrayList<>();
        }
        //查找授权的登录菜单权限
        MPJLambdaWrapper<SysMenu> roleQueryWrapper =buildMenuMPJLambdaWrapper(systemId,group);
        roleQueryWrapper.eq(SysMenu::getNologin,0);
        roleQueryWrapper.leftJoin(SysMenuPath.class, SysMenuPath::getId, SysMenu::getPathId);
        roleQueryWrapper.leftJoin(SysRoleMenu.class, SysRoleMenu::getMenuid,SysMenu::getId);
        roleQueryWrapper.leftJoin(SysUserRole.class,SysUserRole::getRoleid,SysRoleMenu::getRoleid);
        roleQueryWrapper.leftJoin(SysRole.class, SysRole::getId,SysUserRole::getRoleid);
        roleQueryWrapper.eq(SysUserRole::getUserid,getQueryUserId());
        roleQueryWrapper.in(SysRole::getId,sysRoles.stream().map(g->g.getId()).collect(Collectors.toList()));
        roleQueryWrapper.distinct();
        roleQueryWrapper.selectAssociation(SysMenuPath.class, SysMenu::getMenuPath);
        roleQueryWrapper.orderByAsc(SysMenu::getSort);
        //1.查找用户-角色-菜单权限的菜单
        List<SysMenu> userMenus = this.selectJoinList(SysMenu.class, roleQueryWrapper);
        return userMenus;
    }
    @Override
    public List<SysMenu> queryUserMenusList(String systemId,Integer group) {
        List<SysMenu> menus=new ArrayList<>();
        //先查找免登录菜单
        List<SysMenu> noLoginMenus=queryNoLoginMenuList(systemId,group);
        //再查找免登录菜单
        List<SysMenu> loginMenus=queryLoginMenuList(systemId,group);
        loginMenus.removeIf(f->noLoginMenus.stream().anyMatch(g->g.getId().equals(f.getId())));
        menus.addAll(noLoginMenus);
        menus.addAll(loginMenus);
        wrapperMenus(menus);
        return menus;
    }
    @Override
    public List<SysMenu> queryUserMenuTree(String systemId,  Integer group) {
        List<SysMenu> menus = this.queryUserMenusList(systemId,group);
        menus.addAll(queryParentMenuList(menus));
        List<SysMenu> menuTrees = BaseTreeUtil.listToTree(menus, treeNodeConfig, rootPid);
        return menuTrees;
    }    /**
     * 包装菜单的绝对路径
     * @param menus
     */
    private void wrapperMenuAbsPath( List<SysMenu> menus){

        Map<String,String> mapSystemPath = new HashMap<>();
        String absPath = "";
        for(SysMenu menu: menus ){
            if(menu.getMenuPath() == null||StrUtil.isBlank(menu.getMenuPath().getPath())){
               continue;
            }
            String sysId = menu.getMenuPath().getPid();
            if(menu.getMenuPath().getPathType() == m_absPath){
                menu.setAbsPath(menu.getMenuPath().getPath());
                menu.setPath(menu.getMenuPath().getPath());
            }else {
                if(!mapSystemPath.containsKey(sysId)){
                    SysSystem sysSystem = sysSystemMapper.selectById(sysId);
                    if(sysSystem != null) {
                        String url = sysSystem.getUrl() == null ? "" : sysSystem.getUrl();
                        mapSystemPath.put(sysId,url);
                    }
                }
                if(mapSystemPath.containsKey(sysId)){
                    String url = mapSystemPath.get(sysId);
                    String joinTag = menu.getMenuPath().getPath().startsWith("/") || url.endsWith("/") ? "": "/";
                    absPath = url + joinTag + menu.getMenuPath().getPath();
                    menu.setAbsPath(absPath);
                    menu.setPath(menu.getMenuPath().getPath());
                }
            }
        }
    }

    private void wrapperMenuIsolate( List<SysMenu> menus){
        MPJLambdaWrapper<SysMenu> isolateJoinWrapper = MPJWrappers.lambdaJoin();
        isolateJoinWrapper.leftJoin(SysTenantMenu.class, SysTenantMenu::getMenuid,SysMenu::getId);
        isolateJoinWrapper.eq(SysTenantMenu::getTenantid,getTenantId());
        isolateJoinWrapper.eq(SysTenantMenu::getIsolate,1);
        List<SysMenu> isolateMenus =  this.selectJoinList(SysMenu.class,isolateJoinWrapper);
        List<String> menuIds = isolateMenus.stream().map(i -> i.getId()).collect(Collectors.toList());;
        this.wrapperMenuIsolate(menuIds,menus);
    }

    private void wrapperMenuIsolate( List<String> menuIds, List<SysMenu> menus){

        for(SysMenu menu: menus){
            if(menuIds.contains(menu.getId())||menuIds.contains(menu.getRelMenuId())){
                menu.setIsolate(1);
            }
            if(menu.getChildren() != null){
                this.wrapperMenuIsolate(menuIds,menu.getChildren());
            }
        }
    }

    private void queryAllPidsNoContains(List<SysMenu> menus, List<String> pids) {
        List newPids = new ArrayList();
        for (SysMenu menu : menus) {
            boolean exists = StrUtil.isNotBlank(menu.getPid()) && !menu.getPid().equals(rootPid);
            if (exists && !pids.contains(menu.getPid())) {
                newPids.add(menu.getPid());
            }
        }
        pids.addAll(newPids);
        if (newPids.size() > 0) {
            List<SysMenu> pMenus = this.listByIds(newPids);
            queryAllPidsNoContains(pMenus, pids);
        }
    }


    @Override
    public SysMenu queryMenuByKey(String menuKey, String systemId) {
        LambdaQueryWrapper<SysMenu> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysMenu::getSystemId, systemId);
        wrapper.eq(SysMenu::getKey, menuKey);
        wrapper.last("LIMIT 1");

        SysMenu menu = this.getOne(wrapper);
        SysMenuPath sysMenuPath = sysMenuPathService.getById(menu.getPathId());
        if (sysMenuPath != null) {
            menu.setPath(sysMenuPath.getPath());
            menu.setPathType(sysMenuPath.getPathType());
            menu.setMenuPath(sysMenuPath);
        }
//        if (menu != null) {
//            if (menu.getLevel() == 1) {
//                menu.setRootId(menu.getId());
//            } else if (menu.getLevel() == 2) {
//                menu.setRootId(menu.getPid());
//            } else if (menu.getLevel() == 3) {
//                SysMenu pMenu = this.getById(menu.getPid());
//                menu.setRootId(pMenu.getPid());
//            }
//        }
        return menu;
    }

    @Override
    public void setIsolate(String menuId, String tenantId, boolean isIsolate) {
        //SysMenu menu = this.getById(menuId);
        LambdaQueryWrapper<SysTenantMenu> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysTenantMenu::getMenuid,menuId);
        queryWrapper.eq(SysTenantMenu::getTenantid,tenantId);
        SysTenantMenu sysTenantMenu=sysTenantMenuService.getOne(queryWrapper);
        if(sysTenantMenu==null){
            return;
        }
        sysTenantMenu.setIsolate(isIsolate?1:0);
        sysTenantMenuService.saveOrUpdate(sysTenantMenu,queryWrapper);
    }

    @Override
    public  HashMap<String, Object> queryUserSystemMenus(String systemId) {
        HashMap<String, Object> map = new HashMap<>();
        if(StrUtil.isBlank(getQueryUserId()) || StrUtil.isBlank(systemId)){
            return map;
        }
        List<SysMenu> sysMenus = this.queryUserMenuTree(systemId,  0);
        List<SysMenu> uCenterMenu = this.queryUserMenuTree( systemId,  1);
        //
        map.put("menu", sysMenus);
        map.put("uCenterMenu", uCenterMenu);
        return map;
    }


    /**
     * 排序修改
     *
     * @param pid
     * @param systemId
     * @param sort
     * @param value
     */
    private void updateSort(String pid, String systemId, Integer sort, Integer value) {
        LambdaUpdateWrapper<SysMenu> update = Wrappers.lambdaUpdate();
        update.eq(SysMenu::getPid, pid)
                .eq(SysMenu::getSystemId, systemId)
                .eq(SysMenu::getSort, sort)
                .set(SysMenu::getSort, value);
        this.update(update);
    }

    /**
     * 递归查询树
     *
     * @param list
     * @return
     */
    private List<SysMenu> buildTree(List<SysMenu> list, Integer flag) {
        for (SysMenu menuSys : list) {
            SysMenuPath sysMenuPath = sysMenuPathService.getById(menuSys.getPathId());
            if (sysMenuPath != null) {
                menuSys.setPath(sysMenuPath.getPath());
                menuSys.setPathType(sysMenuPath.getPathType());
            }
            //查询是否有子菜单
            List<SysMenu> children = this.list(new QueryWrapper<SysMenu>().eq("f_pid", menuSys.getId()).orderByAsc("f_sort"));
            if (children.size() > 0) {
                //进行递归并赋值
                menuSys.setChildren(buildTree(children, flag));
            } else {
                menuSys.setChildren(new ArrayList<>());
            }
        }
        return list;
    }

    /**
     * 按level、sort字段排序菜单
     *
     * @param menuList
     * @return
     */
    private List<SysMenu> menuSort(List<SysMenu> menuList) {
        Collections.sort(menuList, new Comparator<SysMenu>() {
            @Override
            public int compare(SysMenu menu1, SysMenu menu2) {
                int flag;
                // 先按level降序排序
//                flag = menu1.getLevel() - menu2.getLevel();
//                if (flag == 0) {
                //再按sort降序排序
                flag = menu1.getSort() - menu2.getSort();
//                }
                return flag;
            }
        });
        return menuList;
    }
}
