/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.excel.ExcelReader;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MPJQueryMapperUtil;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.mapper.SysRegionMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class SysRegionServiceImpl
extends MPJBaseServiceImpl<SysRegionMapper, SysRegion>
implements SysRegionService,
ISaasEntityService<SysRegion> {
    private boolean exsits(SysRegion region) {
        LambdaQueryWrapper codeWrapper;
        int iCount;
        if (StrUtil.isBlank((CharSequence)region.getPid())) {
            region.setPid("-1");
            region.setPcode("-1");
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRegion::getPid, (Object)region.getPid());
        if (StrUtil.isNotBlank((CharSequence)region.getId())) {
            wrapper.ne(SysRegion::getId, (Object)region.getId());
        }
        if ((iCount = this.count((Wrapper)(codeWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.clone()).eq(SysRegion::getCode, (Object)region.getCode())))) > 0) {
            throw new ServiceException("\u8f96\u533a\u7f16\u7801\u5df2\u5b58\u5728\uff1a" + region.getCode());
        }
        LambdaQueryWrapper nameWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.clone()).eq(SysRegion::getName, (Object)region.getName());
        iCount = this.count((Wrapper)nameWrapper);
        if (iCount > 0) {
            throw new ServiceException("\u8f96\u533a\u540d\u79f0\u5df2\u5b58\u5728:" + region.getName());
        }
        return false;
    }

    @Override
    public void saveOrUp(SysRegion region) throws Exception {
        if (this.exsits(region)) {
            throw new ServiceException("\u8f96\u533a\u5df2\u5b58\u5728\uff1a" + region.getName());
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.clear();
        wrapper.eq(SysRegion::getId, (Object)region.getPid());
        wrapper.last(" limit 1 ");
        SysRegion pRegion = (SysRegion)this.getOne((Wrapper)wrapper);
        region.setLevel(pRegion == null ? 1 : pRegion.getLevel() + 1);
        region.setPcode(pRegion == null ? "-1" : pRegion.getCode());
        if (StrUtil.isNotBlank((CharSequence)region.getId())) {
            SysRegion old = (SysRegion)this.getById((Serializable)((Object)region.getId()));
            if (!region.getCode().equals(old.getCode())) {
                LambdaUpdateWrapper lambdaUpdateWrapper = new LambdaUpdateWrapper();
                ((LambdaUpdateWrapper)lambdaUpdateWrapper.eq(SysRegion::getPid, (Object)old.getId())).set(SysRegion::getPcode, (Object)region.getCode());
                this.update(null, (Wrapper)lambdaUpdateWrapper);
            }
        } else {
            region.setIdpath(pRegion == null ? pRegion.getId() : pRegion.getIdpath() + "->" + pRegion.getId());
            this.wrapperEntity(region);
        }
        this.saveOrUpdate(region);
    }

    @Override
    public List<SysRegion> queryTree(String filterParam, String sortParam) throws Exception {
        List<SysRegion> regions = this.queryList(filterParam, sortParam);
        return this.constructTree(regions);
    }

    @Override
    public List<SysRegion> queryList(String filterParam, String sortParam) throws Exception {
        MPJLambdaWrapper<SysRegion> queryWrapper = this.buildLambdaWrapper(filterParam, sortParam);
        List regions = this.list((Wrapper)queryWrapper);
        return regions;
    }

    @Override
    public List<SysRegion> queryRegionListById(String regionId) {
        List<SysRegion> children = ((SysRegionMapper)this.baseMapper).getRegionListById(regionId);
        Collections.reverse(children);
        return children;
    }

    @Override
    public List<SysRegion> queryAllParentRegionById(String regionCode) {
        List<SysRegion> result = ((SysRegionMapper)this.baseMapper).getAllParentRegionById(regionCode);
        Collections.reverse(result);
        return result;
    }

    @Override
    public IPage<SysRegion> queryPage(String filterParam, int page, int size) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysRegion.class);
        Page pages = new Page((long)page, (long)size);
        return this.page((IPage)pages, (Wrapper)queryWrapper);
    }

    @Override
    public void batchDelete(String ids) {
        if (StrUtil.isBlank((CharSequence)ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.deleteTree(id);
        }
    }

    @Override
    public SysRegion findOne(String id, String filterParam) throws Exception {
        SysRegion region = (SysRegion)this.getById((Serializable)((Object)id));
        if (filterParam == null) {
            filterParam = "";
        }
        filterParam = filterParam + ";pcode_EQ_" + region.getCode();
        List<SysRegion> childrens = this.queryList(filterParam, "SORT_code_ASC");
        region.setChildren(childrens);
        return region;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void excelOutput(OutputStream outputStream, String id) throws IOException {
        ExcelWriter excelWriter = null;
        try {
            List<SysRegion> list = ((SysRegionMapper)this.baseMapper).getRegionListById(id);
            list = list.stream().sorted(Comparator.comparing(f -> f.getCode())).collect(Collectors.toList());
            ArrayList excelObjects = new ArrayList();
            for (SysRegion sysXzqRegion : list) {
                LinkedHashMap<String, String> excelObject = new LinkedHashMap<String, String>();
                excelObject.put("\u884c\u653f\u533a\u540d\u79f0", sysXzqRegion.getName());
                excelObject.put("\u884c\u653f\u533a\u4ee3\u7801", sysXzqRegion.getCode());
                excelObject.put("\u7236\u7ea7\u884c\u653f\u533a\u4ee3\u7801", sysXzqRegion.getPcode());
                excelObjects.add(excelObject);
            }
            excelWriter = ExcelUtil.getWriter();
            excelWriter.write(excelObjects);
            excelWriter.flush(outputStream, true);
        }
        catch (Exception ex) {
            this.log.error(DateUtil.now() + " \u8f96\u533a\u5bfc\u51fa\uff0cExcel\u5f02\u5e38\uff1a" + ex.getMessage());
        }
        finally {
            if (excelWriter != null) {
                excelWriter.close();
            }
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }

    @Override
    public List<SysRegion> queryUserRegions(String userId) {
        List<SysRegion> regions = ((SysRegionMapper)this.baseMapper).queryUserRegions(userId);
        if (TenantUtil.isSuperTenant()) {
            return regions;
        }
        List<String> tenantRegions = TenantUtil.getTenantRegionIds();
        return regions.stream().filter(f -> tenantRegions.contains(f.getId())).collect(Collectors.toList());
    }

    @Override
    public void excelImport(InputStream stream) {
        try {
            ExcelReader excelReader = ExcelUtil.getReader((InputStream)stream, (int)0);
            List excelList = excelReader.read(1);
            ArrayList<SysRegion> sysRegionList = new ArrayList<SysRegion>();
            for (List excelObject : excelList) {
                SysRegion sysRegion = new SysRegion();
                String name = excelObject.get(0).toString();
                String code = excelObject.get(1).toString();
                String pCode = excelObject.get(2).toString();
                sysRegion.setName(name);
                sysRegion.setCode(code);
                sysRegion.setId(UUID.randomUUID().toString());
                sysRegion.setPcode(StrUtil.isBlank((CharSequence)pCode) ? "-1" : pCode);
                SysRegion parRegion = sysRegionList.stream().filter(f -> f.getCode().equals(pCode)).findAny().orElse(null);
                if (parRegion == null) {
                    sysRegion.setLevel(1);
                    sysRegion.setPid("-1");
                    sysRegion.setPcode("-1");
                    if (this.exsits(sysRegion)) {
                        throw new ServiceException("\u8f96\u533a\u5df2\u5b58\u5728\uff1a" + sysRegion.getName());
                    }
                } else {
                    sysRegion.setLevel(parRegion.getLevel() + 1);
                    sysRegion.setPid(parRegion.getId());
                    sysRegion.setPcode(parRegion.getPcode());
                }
                sysRegionList.add(sysRegion);
            }
            this.saveBatch(sysRegionList);
        }
        catch (Exception ex) {
            throw new ServiceException(ex.getMessage(), (Throwable)ex);
        }
    }

    private void deleteTree(String id) {
        List<SysRegion> children = ((SysRegionMapper)this.baseMapper).getRegionListById(id);
        this.removeByIds(children.stream().map(f -> f.getId()).collect(Collectors.toList()));
    }

    @Override
    public MPJLambdaWrapper<SysRegion> buildLambdaWrapper(String filterParam, String sortParam) {
        try {
            MPJQueryMapperUtil qmu = new MPJQueryMapperUtil();
            MPJLambdaWrapper queryWrapper = qmu.queryMapper(filterParam, sortParam, SysRegion.class);
            if (this.getTenantId().equals("0")) {
                return queryWrapper;
            }
            SysTenant sysTenant = this.getTenant();
            ArrayList<SysRegion> sysRegions = new ArrayList<SysRegion>();
            for (SysRegion region : sysTenant.getRegions()) {
                sysRegions.addAll(((SysRegionMapper)this.getBaseMapper()).getRegionListById(region.getId()));
            }
            if (sysRegions.size() > 0) {
                queryWrapper.in(SysRegion::getId, (Collection)sysRegions.stream().map(f -> f.getId()).collect(Collectors.toList()));
            } else {
                queryWrapper.eq(SysRegion::getLevel, (Object)-100);
            }
            return queryWrapper;
        }
        catch (Exception exception) {
            throw new ServiceException((Throwable)exception);
        }
    }

    private List<SysRegion> constructTree(List<SysRegion> list) {
        int minLevel = 9;
        HashMap mapParam = new HashMap();
        for (SysRegion region : list) {
            String key = region.getPid();
            if (!StringUtils.isEmpty((String)key) && !key.equals("-1")) {
                if (mapParam.containsKey(key)) {
                    ((List)mapParam.get(key)).add(region);
                } else {
                    ArrayList<SysRegion> childList = new ArrayList<SysRegion>();
                    childList.add(region);
                    mapParam.put(key, childList);
                }
            }
            if (region.getLevel() >= minLevel) continue;
            minLevel = region.getLevel();
        }
        ArrayList<SysRegion> results = new ArrayList<SysRegion>();
        for (SysRegion region : list) {
            String key = region.getId();
            if (StringUtils.isNotBlank((CharSequence)key) && mapParam.containsKey(key)) {
                region.setChildren((List)mapParam.get(key));
            }
            if (region.getLevel() != minLevel) continue;
            results.add(region);
        }
        return results;
    }
}

