/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysUserRegion;
import com.geoway.jckj.biz.mapper.SysUserRegionMapper;
import com.geoway.jckj.biz.service.sys.SysUserRegionService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.sso.client.enums.OpTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.springframework.stereotype.Service;

@Service
public class SysUserRegionServiceImpl
extends ServiceImpl<SysUserRegionMapper, SysUserRegion>
implements SysUserRegionService {
    @Override
    @OpLog(name="\u4fee\u6539\u7528\u6237\u6240\u5c5e\u8f96\u533a", opType=OpTypeEnum.update)
    public void updateUserRegions(String userId, List<String> regions) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRegion::getUserid, (Object)userId);
        if (!TenantUtil.isSuperTenant()) {
            if (TenantUtil.getTenantRegionIds().size() > 0) {
                wrapper.in(SysUserRegion::getRegionid, TenantUtil.getTenantRegionIds());
            } else {
                wrapper.eq(SysUserRegion::getRegionid, (Object)UUID.randomUUID().toString());
            }
        }
        this.remove((Wrapper)wrapper);
        if (regions == null) {
            return;
        }
        ArrayList<SysUserRegion> userRegions = new ArrayList<SysUserRegion>();
        for (String regionId : regions) {
            SysUserRegion userRegion = new SysUserRegion();
            userRegion.setUserid(userId);
            userRegion.setRegionid(regionId);
            userRegions.add(userRegion);
        }
        if (userRegions.size() > 0) {
            this.saveBatch(userRegions);
        }
    }
}

