package com.geoway.jckj.biz.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import java.io.Serializable;


/**
 * 注册用户信息实体
 */
@Data
@ApiModel(description = "用户注册信息")
public class UserRegistDTO implements Serializable {
    private static final long serialVersionUID = 1L;

    @NotBlank(message = "用户名不能为空")
    @ApiModelProperty(value = "用户中文名", required = true)
    private String aname;


    @ApiModelProperty(value = "用户身份证号")
    private String bh;

    @NotBlank(message = "登录账号不能为空")
    @ApiModelProperty(value = "登录账号(一般是拼音)")
    private String account;


    @Pattern(regexp = "^1(3|4|5|7|8)\\d{9}$",message = "用户手机号格式错误")
    @NotBlank(message = "用户手机号不能为空")
    @ApiModelProperty(value = "用户手机号", required = true)
    private String tel;

    @ApiModelProperty(value = "用户座机号")
    private String worktel;

    @ApiModelProperty(value = "电子邮箱地址")
    private String email;


    @ApiModelProperty(value = "性别(0:男， 1：女)",allowableValues="0,1")
    private Short sex;

    @ApiModelProperty(value = "用户住址")
    private String address;

    @ApiModelProperty(value = "是否要审核，0：需要审核,1：不需审核(默认若有机构信息需要审核，无机构信息不需审核状态)",allowableValues="0,1")
    private Short check;

    /**
     * 用户来源
     */
    @ApiModelProperty(value = "用户来源")
    private String source;

    @ApiModelProperty(value = "用户类型(0或null: 系统用户；1: 自然人；2：法人:99:其他)",allowableValues = "0,1,2,99")
    private Short type;

    @ApiModelProperty(value = "机构ID(多个英文逗号分开)")
    private String orgIds;

    @ApiModelProperty(value = "行政区编号(多个英文逗号分开)")
    private String regionCodes;

}