package com.geoway.jckj.biz.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import java.io.Serializable;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * 用户租户关联表
 * @TableName sys_user_tenant
 */
@Builder
@AllArgsConstructor
@NoArgsConstructor
@TableName(value ="sys_tenant_user")
@Data
public class SysUserTenant implements Serializable {
    /**
     * 
     */
    @TableId(value = "f_id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 用户id
     */
    @TableField(value = "f_userid")
    private String userid;

    /**
     * 租户id
     */
    @TableField(value = "f_tenantid")
    private String tenantid;

    /**
     * 是否租户管理员（0.否 1.是）
     */
    @TableField(value = "f_isadmin")
    private Integer isAdmin;

    @TableField(exist = false)
    private static final long serialVersionUID = 1L;
}