package com.geoway.jckj.biz.service.dev.base.impl;

import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.geoway.jckj.biz.constants.DynamicParameterConstants;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTheme;
import com.geoway.jckj.biz.service.dev.base.IMenuUrlHandlerService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.Map;

/**
 * @author 连世忠
 * @ClassName UrlDynamicParameterServiceImpl
 * @Description TODO
 * @date 2024/4/16 9:45
 * @Version 1.0
 */
@Service
public class MenuHandlerServiceImpl implements IMenuUrlHandlerService {
    @Override
    public SysMenu handler(SysSystem sysSystem, SysTheme sysTheme,SysMenu menu) {
        if(menu.getMenuPath()!=null&& StrUtil.isNotBlank(menu.getMenuPath().getPath())){
            menu.getMenuPath().setPath((replaceDynamicParam(sysSystem,sysTheme,menu,menu.getMenuPath().getPath())));
            menu.getMenuPath().setPath(appendSystemParam(sysSystem,sysTheme,menu,menu.getMenuPath().getPath()));
        }
        if(StrUtil.isNotBlank(menu.getPath())) {
            menu.setPath(replaceDynamicParam(sysSystem,sysTheme,menu,menu.getPath()));
        }
        if(StrUtil.isNotBlank(menu.getAbsPath())){
            menu.setAbsPath(replaceDynamicParam(sysSystem,sysTheme,menu,menu.getAbsPath()));
            menu.setAbsPath(appendSystemParam(sysSystem,sysTheme,menu,menu.getAbsPath()));
        }
        return menu;
    }

    private String replaceDynamicParam(SysSystem sysSystem, SysTheme sysTheme, SysMenu menu, String url){
        String xzqCodeParam="{{"+ DynamicParameterConstants.XZQCODE+"}}";
        String xzqNameParam="{{"+ DynamicParameterConstants.XZQNAME+"}}";
        //当前用户的角色id
        String roleIdParam="{{"+ DynamicParameterConstants.ROLEID+"}}";
        //皮肤样式
        String skinParam="{{"+ DynamicParameterConstants.SKIN+"}}";
        //菜单id
        String menuIdParam="{{"+ DynamicParameterConstants.MENUID+"}}";
        //
        String tenantParam="{{"+ DynamicParameterConstants.TENANTID+"}}";
        //皮肤样式
        String tenantIdParam="{{"+ DynamicParameterConstants.TENANTID+"}}";
        //菜单id
        String isolateParam="{{"+ DynamicParameterConstants.ISOLATE+"}}";
        //token
        String tokenParam="{{"+ DynamicParameterConstants.TOKEN+"}}";
        if(sysTheme!=null) {
            url = url.replace(skinParam, sysTheme.getName());
        }else{
            url = url.replace(skinParam, "");
        }
        url=  url.replace(menuIdParam, menu.getId());

        SsoUser  ssoUser= CommonLoginUserUtil.getUser();
        if(ssoUser == null) {
            return url;
        }
        if(ssoUser.getRegionCode()!=null) {
            url = url.replace(xzqCodeParam, ssoUser.getRegionCode());
        }else{
            url = url.replace(xzqCodeParam, "");
        }
        if(ssoUser.getRegionName()!=null) {
            url = url.replace(xzqNameParam, ssoUser.getRegionName());
        }else{
            url = url.replace(xzqNameParam, "");
        }
        if(ssoUser.getRoldIds()!=null) {
            url = url.replace(roleIdParam, ssoUser.getRoldIds());
        }else{
            url = url.replace(roleIdParam, "");
        }
        if(ssoUser.getToken()!=null) {
            url = url.replace(tokenParam, ssoUser.getToken());
        }else{
            url = url.replace(tokenParam, "");
        }
        url = url.replace(isolateParam, menu.getIsolate() == null ? "0" : menu.getIsolate().toString());
        SysTenant sysTenant=TenantUtil.getTenant();
        if(sysTenant==null){
            return url;
        }
        if(sysTenant.getKey()!=null) {
            url = url.replace(tenantParam, sysTenant.getKey());
        }else{
            url = url.replace(tenantParam, "");
        }
        if(sysTenant.getId()!=null){
            url = url.replace(tenantIdParam, sysTenant.getId());
        }else{
            url = url.replace(tenantIdParam, "");
        }

        return url;
    }

    /**
     * 添加系统参数
     * @param sysSystem
     * @param sysTheme
     * @param menu
     * @param url
     * @return
     */
    private String appendSystemParam(SysSystem sysSystem, SysTheme sysTheme, SysMenu menu, String url){
        if(!HttpUtil.isHttp(url)&&!HttpUtil.isHttps(url)){
            return url;
        }
        UrlQuery urlQuery=UrlQuery.of(url, CharsetUtil.CHARSET_UTF_8);
        Map<String,Object> sysParam=new HashMap<>();
        SsoUser  ssoUser= CommonLoginUserUtil.getUser();
        if(ssoUser == null) {
            return url;
        }
        if(StrUtil.isBlank(urlQuery.get(DynamicParameterConstants.TOKEN))) {
            sysParam.put(DynamicParameterConstants.TOKEN,ssoUser.getToken());
        }
        if(TenantUtil.isSuperTenant()){
            return HttpUtil.urlWithForm(url,sysParam,CharsetUtil.CHARSET_UTF_8,true);
        }
        SysTenant sysTenant=TenantUtil.getTenant();
        if(StrUtil.isBlank(urlQuery.get(DynamicParameterConstants.TENANTKEY))) {
            sysParam.put(DynamicParameterConstants.TENANTKEY,sysTenant.getKey());
        }
        if(StrUtil.isBlank(urlQuery.get(DynamicParameterConstants.TENANTID))) {
            sysParam.put(DynamicParameterConstants.TENANTID,sysTenant.getId());
        }
        if(StrUtil.isBlank(urlQuery.get(DynamicParameterConstants.ISOLATE))) {
            sysParam.put(DynamicParameterConstants.ISOLATE,menu.getIsolate());
        }
        return HttpUtil.urlWithForm(url,sysParam,CharsetUtil.CHARSET_UTF_8,true);
    }

}
