package com.geoway.jckj.biz.service.login.impl;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSONObject;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.EncodeUtil;
import com.geoway.jckj.biz.dto.AppOneLoginDTO;
import com.geoway.jckj.biz.dto.OneLoginRequestData;
import com.geoway.jckj.biz.dto.OneLoginResponseData;
import com.geoway.jckj.biz.service.login.IAppOneLoginService;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import java.nio.charset.StandardCharsets;

/**
 * @author 连世忠
 * @ClassName AppOneLoginServiceImpl
 * @Description TODO
 * @date 2025/6/11 11:34
 * @Version 1.0
 */
@Service
public class AppOneLoginServiceImpl implements IAppOneLoginService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    @Value("${oneLogin.appId: }")
    private String appId;

    @Value("${oneLogin.appKey: }")
    private String appKey;

    @Value("${oneLogin.verifyURL: }")
    private String verifyURL;

    @Override
    public AppOneLoginDTO validate(String processId, String token, String authCode) {
        Long currentTime = System.currentTimeMillis();
        String sign = createSign(currentTime);
        OneLoginRequestData oneLoginParam = new OneLoginRequestData();
        oneLoginParam.setProcess_id(processId);
        oneLoginParam.setSign(sign);
        oneLoginParam.setToken(token);
        oneLoginParam.setTimestamp(currentTime);
        if(StrUtil.isNotBlank(authCode)){
            oneLoginParam.setAuthCode(authCode);
        }
        OneLoginResponseData respData = vertifyAppOneLoginByHttpPost(oneLoginParam);
        AppOneLoginDTO appOneLoginDTO=new AppOneLoginDTO();
        if(respData.getStatus() == 200){
            appOneLoginDTO.setMessage("");
            appOneLoginDTO.setTel(respData.getResult());
            appOneLoginDTO.setSucceed(true);
            return  appOneLoginDTO;
        }else {
            throw new ServiceException("获取手机号码失败:" + respData.getStatus() + ":" +  respData.getError_msg());
        }

    }

    private OneLoginResponseData vertifyAppOneLoginByHttpPost(OneLoginRequestData oneLoginParam) throws RuntimeException {

        OneLoginResponseData respData = null;
        HttpClient httpclient = null;
        HttpPost httpPost = null;
        HttpEntity httpEntity = null;
        try{
            String body = JSONObject.toJSONString(oneLoginParam);
            httpclient = HttpClients.createDefault();
            httpPost = new HttpPost(verifyURL);
            httpPost.addHeader("Accept","*/*");
            httpPost.addHeader("content-Type","application/json;charset=utf8");

            httpPost.setEntity(new StringEntity(body, StandardCharsets.UTF_8));
            //发送请求
            HttpResponse response = httpclient.execute(httpPost);

            httpEntity = response.getEntity();
            String content = EntityUtils.toString(httpEntity,"UTF-8");
            respData = JSONObject.parseObject(content,OneLoginResponseData.class);

        }catch (Exception ex){
            logger.error("HTTP请求失败:" + ex.getMessage());
            throw new ServiceException("网络请求错误，获取手机号码失败");
        }
        finally {
            //释放资源
            try{
                if(httpEntity != null){
                    EntityUtils.consume(httpEntity);
                }
            }catch (Exception e){
                logger.error("HTTP请求释放资源异常:" + e.getMessage());
            }
        }

        return respData;
    }



    private String createSign(Long currentTime){

        String message = appId + "&&" + currentTime;
        return EncodeUtil.hmacSha256(message,appKey);
    }
}
