package com.geoway.jckj.biz.service.login.impl;

import com.geoway.jckj.base.base.dto.LoginResponse;
import com.geoway.jckj.base.base.dto.OnlineResponse;
import com.geoway.jckj.biz.config.SsoConfig;
import com.geoway.jckj.base.constants.CommonConstants;
import com.geoway.jckj.biz.service.login.ISysLoginService;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.jckj.biz.service.sys.SysUserOnlineService;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.provider.RpcClientInfoProvider;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.SessionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;

/**
 * @author AA
 */
@Service
@Transactional
public class SysLoginServiceImpl implements ISysLoginService {


    @Autowired
    private IOauth2Service ssoOauth2Service;
    @Autowired
    private SysUserOnlineService sysUserOnlineService;
    @Autowired
    private SsoConfig ssoConfig;
    @Autowired
    private RpcClientInfoProvider rpcClientInfoProvider;
    @Override
    public LoginResponse checkLogin(String username, String password, String uuid, String code, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken =ssoOauth2Service.getAccessToken(GrantTypeEnum.PASSWORD_CAPTCHA.getValue(),rpcClientInfoProvider.getRpcClientInfo().getAppId(),rpcClientInfoProvider.getRpcClientInfo().getAppSecret(),"",username,password,"",uuid,code);
        SessionUtils.setAccessToken(request, rpcAccessToken);
        return getLoginResponse(rpcAccessToken,"sso");
    }

    @Override
    public LoginResponse checkLogin(String username, String password, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken=ssoOauth2Service.getAccessToken(GrantTypeEnum.PASSWORD.getValue(),rpcClientInfoProvider.getRpcClientInfo().getAppId(),rpcClientInfoProvider.getRpcClientInfo().getAppSecret(),"",username,password,"","","");
        SessionUtils.setAccessToken(request, rpcAccessToken);
        return getLoginResponse(rpcAccessToken,"sso");
    }

    @Override
    public LoginResponse checkLoginBySms(String tel, String uuid, String code, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken=ssoOauth2Service.getAccessToken(GrantTypeEnum.TEL_CAPTCHA.getValue(),rpcClientInfoProvider.getRpcClientInfo().getAppId(),rpcClientInfoProvider.getRpcClientInfo().getAppSecret(),"","","",tel,uuid,code);
        SessionUtils.setAccessToken(request, rpcAccessToken);
        return getLoginResponse(rpcAccessToken,"sms");
    }

    @Override
    public LoginResponse checkLoginByCa(String caUserCert, String caOauthName, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken=ssoOauth2Service.getAccessToken(GrantTypeEnum.CA.getValue(),
                rpcClientInfoProvider.getRpcClientInfo().getAppId(),rpcClientInfoProvider.getRpcClientInfo().getAppSecret(),
                "","","","","","",
                caUserCert,caOauthName,"","","");
        SessionUtils.setAccessToken(request, rpcAccessToken);
        return getLoginResponse(rpcAccessToken,"ca");
    }

    @Override
    public LoginResponse checkLoginByOne(String oneProcessId, String oneToken, String oneAuthCode, HttpServletRequest request) {
        RpcAccessToken rpcAccessToken=ssoOauth2Service.getAccessToken(GrantTypeEnum.ONE.getValue(),
                rpcClientInfoProvider.getRpcClientInfo().getAppId(),rpcClientInfoProvider.getRpcClientInfo().getAppSecret(),
                "","","","","","",
                "","",oneProcessId,oneToken,oneAuthCode);
        SessionUtils.setAccessToken(request, rpcAccessToken);
        return getLoginResponse(rpcAccessToken,"ca");
    }


    @Override
    public OnlineResponse checkOnline(String username, String password) {
        OnlineResponse response = new OnlineResponse();
        boolean isLogin =  sysUserOnlineService.isOnline(username,password);
        response.setSingeUser(ssoConfig.getSingeUser());
        response.setLogin(isLogin);
        return response;
    }












    private LoginResponse getLoginResponse(RpcAccessToken rpcAccessToken,String validType){
        LoginResponse response = new LoginResponse();
        SsoUser user = rpcAccessToken.getUser();
        response.setAlisName(user.getUserName());
        response.setAliasName(user.getUserName());
        response.setToken(rpcAccessToken.getAccessToken());
        response.setUserId(user.getId());
        response.setUserName(user.getLoginName());
        response.setRefreshToken(rpcAccessToken.getRefreshToken());
        response.setStatus(CommonConstants.RESPONSE_STATUS_OK);
        response.setValidateType(validType);
        response.setPasswordPolicy(user.getPasswordPolicy());
        response.setUserCatalog(user.getUserCatalog());
        response.setRegionCode(user.getRegionCode());
        response.setRegionName( user.getRegionName());
        return response;
    }

}


