package com.geoway.jckj.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.jckj.biz.entity.SysFunction;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysRoleMenu;
import com.geoway.jckj.biz.entity.SysSubFunction;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_role_menu(角色关联菜单表)】的数据库操作Service
* @createDate 2024-10-15 17:25:14
*/
public interface SysRoleMenuService extends IService<SysRoleMenu> {

    /**
     * 查询角色关联的系统菜单
     * @param roleId
     * @param appId
     * @return
     */
    List<SysMenu> queryRelateMenus(String roleId, String appId);

    /**
     * 查询角色关联的应用菜单
     * @param roleId
     * @param menuId
     * @return
     */
    List<SysSubFunction> queryRelateSubFunctions(String roleId, String menuId);

    /**
     * 保存角色关联的系统和应用菜单
     * @param roleId
     * @param appId
     * @param menuIds
     */
    void saveRoleMenus(String roleId, String appId, List<String> menuIds);

    /**
     * 保存功能点
     * @param roleId
     * @param appId
     * @param subFunctionIds
     */
    void saveRoleSubFunctions(String roleId, String menuId, List<String> subFunctionIds);

    /**
     * 删除角色关联的系统菜单
     * @param roleId
     * @param appId
     * @return
     */
    void removeRelateMenus(String roleId, String appId);
}
