package com.geoway.jckj.biz.service.sys;

import com.baomidou.mybatisplus.extension.service.IService;
import com.geoway.jckj.biz.entity.SysTenantSubFunction;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_tenant_menu(租户表)】的数据库操作Service
* @createDate 2025-01-09 17:52:35
*/
public interface SysTenantSubFunctionService extends IService<SysTenantSubFunction> {
    /**
     * 查询特定租户下绑定了哪些菜单
     * @param tenantId
     * @param menuId
     * @return
     */
    List<SysTenantSubFunction> queryBindSubFunctions(String tenantId, String menuId);

    /**
     * 给租户绑定菜单信息
     * @param tenantId
     * @param menuId
     * @param subFunctionIds
     */
    void bindSubFunctions(String tenantId, String menuId, String subFunctionIds);
}
