package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysRoleSystem;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.entity.SysUserRole;
import com.geoway.jckj.biz.mapper.SysRoleMapper;
import com.geoway.jckj.biz.mapper.SysRoleSystemMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.jckj.biz.util.SaasEntityUtil;
import com.geoway.jckj.biz.util.SysUserUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * @author daidongdong
 * @description 针对表【sys_role】的数据库操作Service实现
 * @createDate 2021-11-26 17:00:03
 */

@Service
public class SysRoleServiceImpl extends MPJBaseServiceImpl<SysRoleMapper, SysRole>
        implements SysRoleService,ISaasEntityService<SysRole>{

    final String rootPid = "0";
    private final TreeNodeConfig treeNodeConfig =
            new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");

    @Autowired
    private IUnityUserService userService;

    @Autowired
    SysUserRoleService sysUserRoleService;

    @Autowired
    IOauth2Service auth2Service;

    @Autowired
    SysRoleSystemMapper sysRoleSystemMapper;



    @Autowired
    SysRoleMapper sysRoleMapper;
    @Override
    public void saveOrUp(SysRole role) throws Exception {
        //判断名称是否重复
        LambdaQueryWrapper<SysRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRole::getName, role.getName());
        wrapper.eq(SysRole::getPid, role.getPid());
        wrapper.eq(SysRole::getTenantid,StrUtil.isBlank(role.getTenantid())?getTenantId():role.getTenantid());
        //有id就是更新
        if (StrUtil.isNotBlank(role.getId())) {
            wrapper.ne(SysRole::getId, role.getId());
            SysRole oldRole = this.getById(role.getId());
            if (oldRole != null) {
                role.setCreateTime(oldRole.getCreateTime());
                role.setLevel(oldRole.getLevel());
                role.setSort(oldRole.getSort());
                role.setCreatorid(oldRole.getCreatorid());
            }
            if (!oldRole.getName().equals(role.getName())) {
                this.buildChildALlName(role);
            }
        } else {
            SysRole pRole = this.getById(role.getPid());
            int level = pRole == null ? 1 : pRole.getLevel() + 1;
            role.setLevel(level);

            LambdaQueryWrapper<SysRole> queryWrapper = Wrappers.lambdaQuery();
            queryWrapper.eq(SysRole::getPid, role.getPid());
            queryWrapper.orderByDesc(SysRole::getSort);
            queryWrapper.last(" limit 1");
            SysRole lastRole = this.getOne(queryWrapper);
            if (lastRole == null) {
                role.setSort(1);
            } else {
                role.setSort(lastRole.getSort() + 1);
            }
            wrapperEntity(role);
        }
        int iCount = this.count(wrapper);
        if (iCount > 0) {
            String typeStr = "角色";
            if (role.getType() == 0) {
                typeStr += "组";
            }
            throw new Exception(typeStr + "【" + role.getName() + "】已存在！");
        }
        this.buildAllName(role);
        this.saveOrUpdate(role);
    }

    @Override
    public List<SysRole> queryTree(String filterParam) throws Exception {

        //获取所有分类
        MPJLambdaWrapper<SysRole> wrapper = buildLambdaWrapper(filterParam,"");
        wrapper.eq(SysRole::getType, 0);
        List<SysRole> list = sysRoleMapper.selectList(wrapper);

        //获取所有角色
        if (filterParam == null) {
            filterParam = "";
        }

        MPJLambdaWrapper<SysRole> queryWrapper =buildLambdaWrapper(filterParam,"");
        queryWrapper.eq(SysRole::getType, 1);

        //查询角色
        List<SysRole> roleList = this.list(queryWrapper);

        list.addAll(roleList);

        List<SysRole> roleTrees = constructTree(list);
        return roleTrees;
    }

    @Override
    public List<SysRole> queryList(String filterParam)  {
        MPJLambdaWrapper<SysRole> queryWrapper =buildLambdaWrapper(filterParam,"");
        List<SysRole> roleList = this.list(queryWrapper);
        SaasEntityUtil.wrapper(roleList);
        return roleList;
    }


    @Override
    public  MPJLambdaWrapper<SysRole> buildLambdaWrapper(String filterParam,String sortParam) {
        MPJLambdaWrapper<SysRole>  queryWrapper = ISaasEntityService.super.buildLambdaWrapper(filterParam,sortParam);
        queryWrapper.orderByAsc("f_sort");
        return queryWrapper;
    }





    @Override
    public IPage<SysRole> queryPage(String filterParam, int page, int size) throws Exception {
        MPJLambdaWrapper<SysRole> queryWrapper = buildLambdaWrapper(filterParam,"");
        Page<SysRole> pages = new Page<>(page, size);
        pages= this.page(pages, queryWrapper);
        SaasEntityUtil.wrapper(pages.getRecords());
        return pages;
    }


    @Override
    public SysRole findOne(String id, String filterParam) throws Exception {
        SysRole role = this.getById(id);

        if (filterParam == null) {
            filterParam = "";
        }
        //如果是类型节点
        if (role.getType() == 0) {
            MPJLambdaWrapper<SysRole> queryWrapper = buildLambdaWrapper(filterParam,"");
            queryWrapper.eq(SysRole::getPid, id);
            queryWrapper.distinct();
            List<SysRole> childRoles = this.getBaseMapper().selectJoinList(SysRole.class, queryWrapper);
            if (role != null) {
                role.setChildren(childRoles.stream().distinct().collect(Collectors.toList()));
            }
        }
        SaasEntityUtil.wrapper(Collections.singletonList(role));
        return role;
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        if (StrUtil.isBlank(ids)) {
            return;
        }
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            this.deleteById(id);
        }
    }

    @Override
    public List<SysUser> queryRelUsers(String roleId) {
        LambdaQueryWrapper<SysUserRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid, roleId);
        List<SysUserRole> userRoles = sysUserRoleService.list(wrapper);
        if (userRoles == null || userRoles.size() == 0) {
            return null;
        }
        List<SysUser> users = userService.query(userRoles.stream().map(f -> f.getUserid()).collect(Collectors.toList()));
        SysUserUtil.wrapperUsers(users);
        return users;
    }

    @Override
    public IPage<SysUser> queryPageUsers(String roleId, String noRoleId, String filterParam, String sortParam, int page, int size) throws Exception {
        if (StrUtil.isBlank(sortParam)) {
            sortParam = "SORT_createtime_DESC";
        }
        if (StrUtil.isBlank(filterParam)){
            filterParam = "";
        }
        if (StrUtil.isNotBlank(filterParam)) {
            filterParam=filterParam+";";
        }


        if (StrUtil.isNotBlank(roleId)) {
            List<String> userIds = sysUserRoleService.queryRoleUserIds(roleId);
            if(userIds.size()>0){
                filterParam+="Q_id_N_IN="+StrUtil.join(",", userIds)+";";
            }else{
                filterParam+="Q_id_N_IN="+StrUtil.join(",", -100)+";";
            }

        }

        if (StrUtil.isNotBlank(noRoleId)) {
            List<String> userIds = sysUserRoleService.queryRoleUserIds(noRoleId);
            if(userIds.size()>0){
                filterParam+="Q_id_N_NOTIN="+StrUtil.join(",", userIds)+";";
            }
        }
        IPage<SysUser> results = userService.queryPage(filterParam, page, size);
        SysUserUtil.wrapperUsers(results.getRecords());

        return results;
    }

    @Override
    public List<SysRole> queryUserRoles(String userId) {
        List<SysRole> roles= this.baseMapper.queryUserRoles(userId);
        List<SysRole> total=queryList("");
        roles.removeIf(f->!total.stream().anyMatch(g->g.getId().equals(f.getId())));
        SaasEntityUtil.wrapper(roles);
        return roles;
    }

    @Override
    public void sortRoles(String id, String pid, int flag) {

        List<SysRole> roles = this.initSort(pid);
        int iCount = roles.size();
        if (iCount < 2) {
            return;
        }
        int index = roles.stream().map(i -> i.getId()).collect(Collectors.toList()).indexOf(id);
        if (index < 0) {
            return;
        }

        SysRole curRole = roles.get(index);
        List<SysRole> otherRoles = roles.stream().filter(item -> !item.getId().equals(id)).collect(Collectors.toList());
        switch (flag) {
            //置顶
            case 1:
                int start = 2;
                curRole.setSort(1);
                for (SysRole role : otherRoles) {
                    role.setSort(start);
                    start++;
                }
                otherRoles.add(curRole);
                this.updateBatchById(roles);
                break;
            //上移
            case 2:
                if (index > 0) {
                    SysRole changRole = roles.get(index - 1);
                    int iSort = changRole.getSort();
                    changRole.setSort(curRole.getSort());
                    curRole.setSort(iSort);

                    this.updateById(curRole);
                    this.updateById(changRole);
                }

                break;
            //下移
            case 3:
                //查询排序大一位的记录
                if (index < iCount - 1) {
                    SysRole changRole = roles.get(index + 1);
                    int iSort = changRole.getSort();
                    changRole.setSort(curRole.getSort());
                    curRole.setSort(iSort);

                    this.updateById(curRole);
                    this.updateById(changRole);
                }

                break;
            //置底
            case 4:

                int start2 = 1;
                for (SysRole role : otherRoles) {
                    role.setSort(start2);
                    start2++;
                }
                curRole.setSort(start2);
                otherRoles.add(curRole);
                this.updateBatchById(roles);
                break;
            default:
                break;
        }
    }

    @Override
    public List<SysRole> initSort(String pid) {

        LambdaQueryWrapper<SysRole> queryWrapper = Wrappers.lambdaQuery();
        if (pid == null) {
            queryWrapper.isNull(SysRole::getPid);
        } else {
            queryWrapper.eq(SysRole::getPid, pid);
        }
        queryWrapper.orderByAsc(SysRole::getSort);

        List<SysRole> roles = this.list(queryWrapper);
        int iCount = roles.size();
        if (iCount < 2) {
            return roles;
        }
        LambdaQueryWrapper<SysRole> queryWrapper2 = Wrappers.lambdaQuery();
        if (pid == null) {
            queryWrapper2.isNull(SysRole::getPid);
        } else {
            queryWrapper2.eq(SysRole::getPid, pid);
        }
        queryWrapper2.groupBy(SysRole::getSort);
        queryWrapper2.select(SysRole::getSort);

        List list2 = this.listMaps(queryWrapper2);
        int iCount2 = list2.size();

        if (iCount > iCount2) {
            for (int i = 0; i < roles.size(); i++) {
                SysRole role = roles.get(i);
                role.setSort(i + 1);
            }
            this.updateBatchById(roles);
        }
        SaasEntityUtil.wrapper(roles);
        return roles;
    }

    @Override
    public void dragRoleNode(String id, String refId, String type) throws Exception {
        SysRole role = this.getById(id);
        SysRole refRole = this.getById(refId);
        String pid = refRole.getPid();
        int sort = refRole.getSort();
        role.setLevel(refRole.getLevel());
        if (type.equals("inner")) {
            pid = refRole.getId();
            role.setLevel(refRole.getLevel() + 1);
        }
        role.setPid(pid);
        role.setSort(sort);


        this.buildAllName(role);
        this.saveOrUpdate(role);

        //重新排序
        this.initSort(pid);

        //默认上移
        int sortType = 2;
        if (type.equals("after")) {
            sortType = 3;
        } else if (type.equals("inner")) {
            sortType = 4;
        }

        this.sortRoles(id, pid, sortType);
    }

    @Override
    public int queryCount(String filterParam) throws Exception{
        MPJLambdaWrapper<SysRole>  queryWrapper = ISaasEntityService.super.buildLambdaWrapper(filterParam,"");
        //MPJLambdaWrapper<SysRole> queryWrapper = buildLambdaWrapper(filterParam,"");
        int count = this.count(queryWrapper);
        return count;
    }

    @Override
    public void bindUsers(String roleId, String userIds) {

        if (StrUtil.isBlank(userIds) || StrUtil.isBlank(roleId)) {
            return;
        }
        List<String> userIdList = Arrays.asList(userIds.split(","));
        sysUserRoleService.bindUsers(roleId, userIdList);
    }

    @Override
    public void removeBindUsers(String roleId, String userIds) {
        if (StrUtil.isBlank(userIds) || StrUtil.isBlank(roleId)) {
            return;
        }
        List<String> userIdList = Arrays.asList(userIds.split(","));
        sysUserRoleService.removeBindUsers(roleId, userIdList);
    }

    private void deleteById(String id) throws Exception {
        SysRole role = this.getById(id);
        //如果是角色
        if (role.getType() == 1) {
            LambdaQueryWrapper<SysUserRole> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysUserRole::getRoleid, id);
            int iCount = sysUserRoleService.count(wrapper);
            if (iCount > 0) {
                throw new Exception("该角色下已关联用户，不能删除!");
            }

            LambdaQueryWrapper<SysRoleSystem> wrapper2 = Wrappers.lambdaQuery();
            wrapper2.eq(SysRoleSystem::getRoleid, id);

            sysRoleSystemMapper.delete(wrapper2);
        } else {
            //如果是角色分组，则先删除下面的子节点
            LambdaQueryWrapper<SysRole> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRole::getPid, id);

            List<SysRole> subRoles = this.list(wrapper);
            for (SysRole subRole : subRoles) {
                this.deleteById(subRole.getId());
            }
        }

        this.removeById(id);
    }
    /**
     * 递归查询树
     *
     * @param list
     * @return
     */
    private List<SysRole> constructTree(List<SysRole> list) {

        int minLevel = 99;
        Map<String, List<SysRole>> mapParam = new HashMap<String, List<SysRole>>();
        for (SysRole role : list) {
            String key = role.getPid();
            if (!StringUtils.isEmpty(key) && !key.equals("0")) {
                if (mapParam.containsKey(key)) {
                    mapParam.get(key).add(role);
                } else {
                    List<SysRole> childList = new ArrayList<SysRole>();
                    childList.add(role);
                    mapParam.put(key, childList);
                }
            }

            if (role.getLevel() < minLevel) {
                minLevel = role.getLevel();
            }
        }
        List<SysRole> results = new ArrayList<SysRole>();
        for (SysRole role : list) {
            String key = role.getId();
            if (StringUtils.isNotBlank(key) && mapParam.containsKey(key)) {
                role.setChildren(mapParam.get(key));
            }
            if (role.getLevel() == minLevel) {
                results.add(role);
            }
        }

        return results;
    }

    private void buildChildALlName(SysRole role) {
        LambdaQueryWrapper<SysRole> wrapper = Wrappers.lambdaQuery();

        List<SysRole> roles = this.list(wrapper);
        for (SysRole subRole : roles) {
            this.buildAllName(subRole);
        }

    }

    private void buildAllName(SysRole role) {
        role.setAllname(role.getName());
    }
}




