package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.sso.client.annotation.OpLog;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysUserRole;
import com.geoway.jckj.biz.mapper.SysUserRoleMapper;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysUserRoleService;
import com.geoway.sso.client.enums.OpTypeEnum;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
* @author daidongdong
* @description 针对表【sys_user_role】的数据库操作Service实现
* @createDate 2021-11-30 19:24:11
*/
@Service
public class SysUserRoleServiceImpl extends ServiceImpl<SysUserRoleMapper, SysUserRole>
    implements SysUserRoleService {

    @Override
    @OpLog(name = "修改用户所属角色", opType = OpTypeEnum.update)
    public void updateUserRole(String userId, List<String> roleIds) {
        try {
            SysRoleService sysRoleService= SpringUtils.getBean(SysRoleService.class);
            List<SysRole> sysRoles = sysRoleService.queryList("");
            //判断名称是否重复
            LambdaQueryWrapper<SysUserRole> wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysUserRole::getUserid, userId);
            wrapper.in(SysUserRole::getRoleid,sysRoles.stream().map(f->f.getId()).collect(Collectors.toList()));
            //先移除
            this.remove(wrapper);
            if (roleIds == null) {
                return;
            }
            List<SysUserRole> userRoles = new ArrayList<>();
            for (String roleId : roleIds) {
                SysUserRole userRole = new SysUserRole();
                userRole.setUserid(userId);
                userRole.setRoleid(roleId);

                userRoles.add(userRole);
            }
            if (userRoles.size() > 0) {
                this.saveBatch(userRoles);
            }

        }
        catch (Exception exception){
            throw new ServiceException(exception);
        }
    }

    @Override
    public void updateRoleUsers(String roleId, List<String> userIds) {
        //判断名称是否重复
        LambdaQueryWrapper<SysUserRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid,roleId);

        //先移除
        this.remove(wrapper);
        List<SysUserRole> userRoles = new ArrayList<>();
        for(String userId: userIds){
            SysUserRole userRole = new SysUserRole();
            userRole.setUserid(userId);
            userRole.setRoleid(roleId);

            userRoles.add(userRole);
        }
        if(userRoles.size() > 0){
            this.saveBatch(userRoles);
        }
    }



    @Override
    public List<String> queryRoleUserIds(String roleId) {
        LambdaQueryWrapper<SysUserRole> wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysUserRole::getRoleid, roleId);


        List<String> userIds = this.list(wrapper).stream().map(i -> i.getUserid()).collect(Collectors.toList());

        return userIds;
    }

    @Override
    public void bindUsers(String roleId, List<String> userIds) {
        if(StrUtil.isBlank(roleId) || userIds == null || userIds.size() == 0){
            return;
        }

        this.removeBindUsers(roleId,userIds);
        List<SysUserRole> userRoles = new ArrayList<>();
        for (String userId : userIds) {
            SysUserRole userRole = new SysUserRole();

            userRole.setUserid(userId);
            userRole.setRoleid(roleId);
            userRoles.add(userRole);
        }
        this.saveBatch(userRoles);
    }

    @Override
    public void removeBindUsers(String roleId, List<String> userIds) {
        if(StrUtil.isBlank(roleId) || userIds == null || userIds.size() == 0){
            return;
        }
        LambdaQueryWrapper<SysUserRole> queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysUserRole::getRoleid,roleId);
        queryWrapper.in(SysUserRole::getUserid,userIds);

        this.remove(queryWrapper);
    }
}




