package com.geoway.jckj.biz.util;

import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.encryption.AESUtils;
import com.geoway.jckj.base.support.encryption.Md5Utils;
import com.geoway.jckj.biz.config.PasswordConfig;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Random;

/**
 * @author 连世忠
 * @ClassName PasswordUtil
 * @Description 密码帮助类
 * @date 2024/4/3 9:42
 * @Version 1.0
 */
@Service
public class PasswordUtil {
    @Autowired
    private PasswordConfig passwordConfig;

    public String getEncryptMethod(){
        return passwordConfig.getEncryptMethod();
    }

    /**
     * 获取md5密码
     * @param password
     * @return
     */
    public String getMD5Password(String password){
        try {
            if (getEncryptMethod().toUpperCase().equals("MD5")) {
                return password;
            }else if(getEncryptMethod().toUpperCase().equals("AES")) {
                String realPassword= AESUtils.decrypt(password, AESUtils.KEY);
                return Md5Utils.getMD5Str(realPassword,"UTF-8");
            }else if(getEncryptMethod().toUpperCase().equals("REAL")) {
                return Md5Utils.getMD5Str(password,"UTF-8");
            }else {
                throw new ServiceException("密码错误");
            }

        }catch (Exception exception){
            throw new ServiceException(exception);
        }
    }

    /**
     * 获取AES密码
     * @param password
     * @return
     */
    public String getAESPassword(String password){
        try {
            if (getEncryptMethod().toUpperCase().equals("MD5")) {
                throw new ServiceException("密码错误");
            } else if (getEncryptMethod().toUpperCase().equals("AES")) {
                return password;
            } else if (getEncryptMethod().toUpperCase().equals("REAL")) {
                return AESUtils.encrypt(password, AESUtils.KEY);
            } else {
                throw new ServiceException("密码错误");
            }
        }catch (Exception exception){
            throw new ServiceException(exception);
        }
    }
    /**
     * 获取明文密码
     * @param password
     * @return
     */
    public String getRealPassword(String password){
        return getRealPassword(password,getEncryptMethod());
    }
    /**
     * 获取明文密码
     * @param password
     * @return
     */
    public String getRealPassword(String password,String srcEncryptMethod){
        try {
            if (srcEncryptMethod.toUpperCase().equals("MD5")) {
                throw new ServiceException("密码错误");
            } else if (srcEncryptMethod.toUpperCase().equals("AES")) {
                return AESUtils.decrypt(password, AESUtils.KEY);
            } else if (srcEncryptMethod.toUpperCase().equals("REAL")) {
                return password;
            } else {
                throw new ServiceException("密码错误");
            }
        }catch (Exception exception){
            throw new ServiceException("密码错误",exception);
        }
    }
    /**
     * 将密码转换成当前系统的加密模式
     * @param srcPassword
     * @param srcEncryptMethod
     * @return
     */
    public String getTargetPassword(String srcPassword,String srcEncryptMethod){
        try {
            if(srcEncryptMethod.toUpperCase().equals(getEncryptMethod().toUpperCase())){
                return srcPassword;
            }
            String realPassword=getRealPassword(srcPassword,srcEncryptMethod);
            if (getEncryptMethod().toUpperCase().equals("MD5")) {
                return Md5Utils.getMD5Str(realPassword, "UTF-8");
            } else if (getEncryptMethod().toUpperCase().equals("AES")) {
                return AESUtils.encrypt(realPassword, AESUtils.KEY);
            } else if (getEncryptMethod().toUpperCase().equals("REAL")) {
                return realPassword;
            } else {
                throw new ServiceException("密码错误");
            }
        }catch (Exception exception){
            throw new ServiceException(exception);
        }

    }

    /**
     * 获取初始密码
     * @return
     */
    public String getInitRealPassrowd(){
        // 设置初始密码和复位密码
        String resetPassword = passwordConfig.getInitPassword();
        if (passwordConfig.isRandomPassword()) {
            resetPassword = getRandomPassword();
        }
        return resetPassword;
    }



    private String getRandomCharter(Random random, boolean upperCase) {
        int randomIndex = random.nextInt(26);
        char aa = upperCase ? 'A' : 'a';
        char randomChar = (char) (randomIndex + aa);

        return String.valueOf(randomChar);
    }

    private String getSpeCharter(Random random) {
        int randomIndex = random.nextInt(3);
        String[] secordArr = {"@", "#", "$", "!"};
        return secordArr[randomIndex];
    }
    private String getRandomPassword() {

        Random random = new Random();
        StringBuffer strBuf = new StringBuffer();
        strBuf.append(getRandomCharter(random, true));
        strBuf.append(getRandomCharter(random, false));
        strBuf.append(getRandomCharter(random, false));
        strBuf.append(getRandomCharter(random, false));

        strBuf.append(getSpeCharter(random));

        strBuf.append(random.nextInt(9));
        strBuf.append(random.nextInt(9));
        strBuf.append(random.nextInt(9));

        return strBuf.toString();

    }

}
