package com.geoway.jckj.biz.aspect;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.sso.client.annotation.RequireAuth;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.constant.SsoConstant;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.client.util.HttpServletUtil;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Method;

import static com.geoway.jckj.biz.constants.TenantConstants.AdminTenantId;

/**
 * 接口日志保存切面方法
 */
@Slf4j
@Aspect
@Service
@ConditionalOnExpression("#{T(com.geoway.sso.client.constant.SystemConstant).IS_SERVER}")
@SuppressWarnings("all")
public class RequireAuthAspect {


    /**
     *  配置织入点
     */
    //@Pointcut("@annotation(com.geoway.sso.client.annotation.RequireAuth)")
    @Pointcut("@within(com.geoway.sso.client.annotation.RequireAuth)")
    public void authClassPointCut() {
    }

    @Before("authClassPointCut()")
    public void beforeClassExec(JoinPoint joinPoint) {
        excute(joinPoint);
    }
    /**
     *  配置织入点
     */
    //@Pointcut("@annotation(com.geoway.sso.client.annotation.RequireAuth)")
    @Pointcut("@annotation(com.geoway.sso.client.annotation.RequireAuth)")
    public void authMethodPointCut() {
    }

    @Before("authMethodPointCut()")
    public void beforeMethodExec(JoinPoint joinPoint) {
        excute(joinPoint);
    }
    private void excute(JoinPoint joinPoint){
        RequireAuth requireAuth = getAnnotationAuth(joinPoint);
        if(requireAuth==null||requireAuth.roleLevel()== RoleLevelEnum.None){
            return;
        }
        SsoUser sysUser = CommonLoginUserUtil.getUser();// oauth2Service.queryCurrentSsoUser(request);
        if(sysUser==null){
            markLoginResponse("用户无权限访问");
            return;
        }
        switch (requireAuth.roleLevel()){
            case superAdmin:
                if(sysUser.getUserCatalog().equals(RoleLevelEnum.superAdmin.getValue())){
                    return;
                }
                throw new ServiceException("用户无权限访问,需系统管理员权限");
            case tenantAdmin:
                if(sysUser.getUserCatalog()> RoleLevelEnum.tenantAdmin.getValue()){
                    throw new ServiceException("用户无权限访问,需管理员权限");
                }
                SysTenant sysTenant=TenantUtil.getTenant();
                if(sysTenant.getId().equals(AdminTenantId)){
                    if(!sysUser.getUserCatalog().equals(RoleLevelEnum.superAdmin.getValue())){
                        throw new ServiceException("用户无权限访问,需系统管理员权限");
                    }
                }else{
                    if(!sysTenant.getUsers().stream().anyMatch(f->f.getId().equals(sysUser.getUserid()))){
                        throw new ServiceException("用户无权限访问,需管理员权限");
                    }
                }
        }
    }

    /**
     * 是否存在注解，如果存在就获取
     * @param joinPoint
     * @return
     */
    private RequireAuth getAnnotationAuth(JoinPoint joinPoint) {
        Signature signature = joinPoint.getSignature();
        MethodSignature methodSignature = (MethodSignature) signature;
        Method method = methodSignature.getMethod();
        RequireAuth requireAuth=null;
        if (method != null) {
            requireAuth= method.getAnnotation(RequireAuth.class);
        }
        if(requireAuth!=null){
            return requireAuth;
        }
        Class classT=methodSignature.getDeclaringType();
        if (classT != null) {
            requireAuth= (RequireAuth)classT.getAnnotation(RequireAuth.class);
        }
        return requireAuth;
    }

    //前后端分离登录拦截返回
    private void markLoginResponse(String msg) {
        try {
            HttpServletResponse response = HttpServletUtil.getResponse();
            response.setStatus(HttpStatus.OK.value());
            response.setContentType(MediaType.APPLICATION_JSON_VALUE);
            response.setCharacterEncoding("UTF-8");
            response.setHeader("Cache-Control", "no-cache, must-revalidate");
            JSONObject baseResopnse = new JSONObject();
            baseResopnse.put("code", SsoConstant.NO_LOGIN);
            baseResopnse.put("status", SsoConstant.RESPONSE_STATUS_LOGINOUT);
            baseResopnse.put("message", "无效token或token已过期");
            if (StrUtil.isNotEmpty(msg)) {
                baseResopnse.put("message", msg);
            }
            String jsonResult = JSON.toJSONString(baseResopnse, SerializerFeature.WriteNullStringAsEmpty);
            response.getOutputStream().write(jsonResult.getBytes());
        }catch (Exception exception){
            throw new ServiceException(exception);
        }
    }
}
