package com.geoway.jckj.biz.enums;

/**
 * @author 连世忠
 * @ClassName TenantUserRangeEnum
 * @Description TODO
 * @date 2025/6/3 10:16
 * @Version 1.0
 */
public enum  TenantUserRangeEnum {
    /**
     *仅管理自己辖区内的
     */
    REGION(1),

    /**
     * 仅管理自己组织内的
     */
    ORG(2),

    /**
     * 管理辖区以及组织内的
     */
    REGION_ORG(3);

    private final int value;

    TenantUserRangeEnum(int value){
        this.value = value;
    }

    public  int getValue(){
        return  this.value;
    }

    public static TenantUserRangeEnum getEnumByValue(int type) {
        for (TenantUserRangeEnum typeIdEnum : TenantUserRangeEnum.values()) {
            if (typeIdEnum.value == type) {
                return typeIdEnum;
            }
        }
        return REGION_ORG;
    }
}
