package com.geoway.jckj.biz.service.sys;

import com.geoway.jckj.biz.entity.SysMenu;
import com.github.yulichang.extension.mapping.base.MPJDeepService;

import java.util.HashMap;
import java.util.List;

/**
 * 菜单
 *
 * @author: wujing
 * @Date: 2021/11/11
 */
public interface SysMenuService extends MPJDeepService<SysMenu> {

    /**
     * 保存与编辑
     *
     * @param menu
     * @throws Exception
     */
    void saveOrUp(SysMenu menu) throws Exception;

    /**
     * 查询在租户空间下，指定系统的菜单树
     *
     * @param systemId
     * @return
     */
    List<SysMenu> queryMenuTree(String systemId, Integer group);
    /**
     * 查询在租户空间下，指定系统的菜单列表
     *
     * @param systemId
     * @return
     */
    List<SysMenu> queryMenuList(String systemId, Integer group);

    /**
     * 删除
     *
     * @param id
     * @throws Exception
     */
    void deleteMenu(String id) throws Exception;

    /**
     * 排序置换
     *
     * @param flag
     * @param id
     * @param pid
     * @param systemId
     * @param sort
     * @throws Exception
     */
    void sortUp(Integer flag, String id, String pid, String systemId, Integer sort) throws Exception;


    /**
     * 设成默认菜单
     *
     * @param id
     */
    void setDefault(String id);

    /**
     * 在租户空间下，查询当前用户的系统菜单列表（列表）
     *
     * @param systemId
     * @return
     */
    List<SysMenu> queryUserMenusList(String systemId,  Integer group);


    /**
     * 在租户空间下，查询指定用户的系统菜单树（树）
     *
     * @param systemId
     * @return
     */
    List<SysMenu> queryUserMenuTree(String systemId, Integer group);


    /**
     * 根据菜单功能key查询菜单
     * @param menuKey
     * @param systemId
     * @return
     */
    SysMenu queryMenuByKey(String menuKey,String systemId);

    /**
     * 获取到注册菜单
     * @param menuId
     * @return
     */
    SysMenu queryRegisterMenu(String menuId);
    /**
     * 设置资源隔离
     * @param menuId
     * @param tenantid
     * @param isIsolate
     */
    void setIsolate(String menuId,String tenantid,boolean isIsolate);


    /**
     * 查询用户所属系统的菜单
     * @param systemId
     * @return
     */
    HashMap<String, Object> queryUserSystemMenus(String systemId);

}
