package com.geoway.jckj.biz.service.sys;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysUser;
import com.github.yulichang.extension.mapping.base.MPJDeepService;

import java.util.List;

/**
* @author daidongdong
* @description 针对表【sys_role】的数据库操作Service
* @createDate 2021-11-25 18:51:53
*/
public interface SysRoleService extends MPJDeepService<SysRole> {

    /**
     * 保存与编辑
     * @param
     * @throws Exception
     */
    void saveOrUp(SysRole role) throws Exception;

    /**
     * 查询角色的树状结构
     * @return
     */
    List<SysRole> queryTree(String filterParam) throws Exception;

    /**
     * 根据过滤条件列表
     * @return
     */
    List<SysRole> queryList(String filterParam);



    /**
     * 根据过滤条件查询分页
     * @param filterParam
     * @param page
     * @param size
     * @return
     * @throws Exception
     */
    IPage<SysRole> queryPage(String filterParam, int page, int size) throws Exception;



    /**
     * 查询角色信息（含直属子节点）
     * @param id
     * @param filterParam
     * @return
     */
    SysRole findOne(String id,String filterParam) throws Exception;


    /**
     * 批量删除
     * @param ids 角色id（多个中间用逗号隔开）
     */
    void batchDelete(String ids) throws Exception;

    /**
     * 查询用角色关联的用户
     * @param roleId
     * @return
     */
    List<SysUser> queryRelUsers(String roleId);

    /**
     * 分页查询角色关联/非关联的用户
     * @param roleId
     * @param noRoleId
     * @param filterParam
     * @param sortParam
     * @param page
     * @param size
     * @return
     */
    IPage<SysUser> queryPageUsers(String roleId,String noRoleId,String filterParam, String sortParam,int page, int size) throws Exception;
    /**
     * 查询用户关联角色
     *
     * @param userId
     * @return
     */
    List<SysRole> queryUserRoles(String userId);
    /**
     * 对同一目录下的角色进行排序
     * @param id
     * @param pid
     * @param flag
     */
    void sortRoles(String id,String pid,int flag);

    /**
     * 初始化排序
     * @param pid
     * @return
     */
    List<SysRole>  initSort(String pid);

    /**
     * 拖拽节点操作
     * @param id
     * @param refId
     * @param type
     */
    void dragRoleNode(String id,String refId,String type) throws Exception;

    /**
     * 根据过滤条件查询个数
     * @return
     */
    int queryCount(String filterParam) throws Exception;

    /**
     * 绑定角色关联的用户
     * @param roleId
     * @param userIds
     */
    void bindUsers(String roleId,String userIds);

    /**
     * 移除角色绑定的用户
     * @param roleId
     * @param userIds
     */
    void removeBindUsers(String roleId,String userIds);


}
