/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.login.impl;

import cn.hutool.core.util.RandomUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.jckj.base.support.Pair;
import com.geoway.jckj.biz.dto.SmsCaptchaDTO;
import com.geoway.jckj.biz.service.login.ICaptchaService;
import com.geoway.jckj.biz.service.login.ISmsCaptchaService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SmsCaptchaServiceImpl
implements ISmsCaptchaService {
    @Autowired
    ICaptchaService captchaService;

    @Override
    public String createCaptcha(int size) {
        return RandomUtil.randomNumbers((int)6);
    }

    @Override
    public SmsCaptchaDTO storeCaptcha(String sessionId, String smsCode) {
        Long timeStamp = System.currentTimeMillis();
        SmsCaptchaDTO smsCaptchaDTO = new SmsCaptchaDTO();
        smsCaptchaDTO.setVerifyCode(smsCode);
        smsCaptchaDTO.setCreateTime(timeStamp);
        smsCaptchaDTO.setVerifyed(false);
        smsCaptchaDTO.setLeft(3);
        smsCaptchaDTO.setUid(sessionId);
        this.captchaService.storeCaptcha(sessionId, JSONUtil.toJsonStr((Object)smsCaptchaDTO));
        return smsCaptchaDTO;
    }

    @Override
    public Pair<Boolean, String> validateCaptcha(String sessionId, String verifyCode) {
        Pair result = null;
        long SMS_CODE_OUT_DATE = 300000L;
        String smsCodeObj = this.captchaService.queryCaptcha(sessionId);
        JSONObject smsCodeJson = null;
        if (smsCodeObj != null) {
            smsCodeJson = JSON.parseObject((String)smsCodeObj.toString());
            int left = smsCodeJson.getIntValue("left");
            if (left <= 0) {
                result = new Pair((Object)false, (Object)"\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
                return result;
            }
            if (System.currentTimeMillis() - Long.parseLong(smsCodeJson.getString("createTime")) > 300000L) {
                result = new Pair((Object)false, (Object)"\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
                return result;
            }
            if (!verifyCode.equalsIgnoreCase(smsCodeJson.getString("verifyCode"))) {
                smsCodeJson.put("left", (Object)(--left));
                this.captchaService.storeCaptcha(sessionId, smsCodeJson.toString());
                result = new Pair((Object)false, (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff0c\u8bf7\u91cd\u8bd5\uff01");
                return result;
            }
            smsCodeJson.put("isVerifyed", (Object)true);
            this.captchaService.storeCaptcha(sessionId, smsCodeJson.toString());
            result = new Pair((Object)true, (Object)"\u9a8c\u8bc1\u6210\u529f\uff01");
            return result;
        }
        result = new Pair((Object)false, (Object)"\u9a8c\u8bc1\u7801\u9519\u8bef\uff01");
        return result;
    }
}

