/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.oauth2.impl;

import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.exception.login.NoLoginException;
import com.geoway.jckj.biz.service.dev.unity.IUnityLoginService;
import com.geoway.jckj.biz.service.login.ISsoAppService;
import com.geoway.jckj.biz.service.oauth2.IOauth2Service;
import com.geoway.jckj.biz.service.sys.SysUserLimitService;
import com.geoway.jckj.biz.util.GuestUtil;
import com.geoway.jckj.biz.util.LoginUtil;
import com.geoway.sso.client.enums.GrantTypeEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CookieUtils;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.common.RefreshTokenContent;
import com.geoway.sso.server.session.AccessTokenManager;
import com.geoway.sso.server.session.CodeManager;
import com.geoway.sso.server.session.RefreshTokenManager;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service
public class Oauth2ServiceImpl
implements IOauth2Service {
    @Autowired
    private ISsoAppService ssoAppService;
    @Autowired
    private IUnityLoginService userService;
    @Autowired
    private CodeManager codeManager;
    @Autowired
    private AccessTokenManager accessTokenManager;
    @Autowired
    private RefreshTokenManager refreshTokenManager;
    @Autowired
    private TicketGrantingTicketManager ticketGrantingTicketManager;
    @Autowired
    private SysUserLimitService sysUserLimitService;

    @Override
    public RpcAccessToken getAccessToken(String grantType, String appId, String appSecret, String code, String username, String password, String tel, String sessionId, String catpcha) {
        return this.getAccessToken(grantType, appId, appSecret, code, username, password, tel, sessionId, catpcha, "", "", "", "", "");
    }

    @Override
    public RpcAccessToken getAccessToken(String grantType, String appId, String appSecret, String code, String username, String password, String tel, String sessionId, String catpcha, String caUserCert, String caOauthName, String oneProcessId, String oneToken, String oneAuthCode) {
        Result<Void> result = this.validateParam(grantType, code, username, password, tel, sessionId, catpcha, caUserCert, caOauthName, oneProcessId, oneToken, oneAuthCode);
        if (!result.isSuccess()) {
            throw new ServiceException(result.getMessage());
        }
        Result<Void> appResult = this.ssoAppService.validate(appId, appSecret);
        if (!appResult.isSuccess()) {
            throw new ServiceException(appResult.getMessage());
        }
        Result<AccessTokenContent> accessTokenResult = this.validateAuth(grantType, code, username, password, tel, appId, sessionId, catpcha, caUserCert, caOauthName, oneProcessId, oneToken, oneAuthCode);
        if (!accessTokenResult.isSuccess()) {
            throw new ServiceException(accessTokenResult.getMessage());
        }
        boolean isValid = this.sysUserLimitService.isValid(appId, ((AccessTokenContent)accessTokenResult.getData()).getUser().getId());
        if (!isValid) {
            throw new ServiceException("\u8be5\u7528\u6237\u88ab\u9650\u5236\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return LoginUtil.genereateRpcAccessToken((AccessTokenContent)accessTokenResult.getData(), null);
    }

    @Override
    public RpcAccessToken refreshToken(String appId, String refreshToken) {
        if (GuestUtil.validateGuestToken(refreshToken)) {
            return GuestUtil.getGuestRpcAccessToken(refreshToken);
        }
        if (!this.ssoAppService.exists(appId)) {
            throw new ServiceException("\u975e\u6cd5\u5e94\u7528");
        }
        RefreshTokenContent refreshTokenContent = this.refreshTokenManager.validate(refreshToken);
        if (refreshTokenContent == null) {
            throw new NoLoginException("refreshToken\u6709\u8bef\u6216\u5df2\u8fc7\u671f");
        }
        AccessTokenContent accessTokenContent = refreshTokenContent.getAccessTokenContent();
        if (!appId.equals(accessTokenContent.getAppId())) {
            throw new ServiceException("\u975e\u6cd5\u5e94\u7528");
        }
        SsoUser user = this.ticketGrantingTicketManager.getAndRefresh(accessTokenContent.getCodeContent().getTgt());
        if (user == null) {
            throw new NoLoginException("\u670d\u52a1\u7aefsession\u5df2\u8fc7\u671f");
        }
        return LoginUtil.genereateRpcAccessToken(accessTokenContent, refreshTokenContent.getAccessToken());
    }

    @Override
    public RpcAccessToken queryAccessToken(String token) {
        if (GuestUtil.validateGuestToken(token)) {
            return GuestUtil.getGuestRpcAccessToken(token);
        }
        AccessTokenContent tokenContent = this.accessTokenManager.get(token);
        if (tokenContent != null) {
            RpcAccessToken rpcAccessToken = new RpcAccessToken(token, this.accessTokenManager.getExpiresIn(), tokenContent.getRefreshToken(), tokenContent.getUser());
            return rpcAccessToken;
        }
        return null;
    }

    @Override
    public void revokeAccessToken(String token) {
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        AccessTokenContent tokenContent = this.accessTokenManager.get(token);
        if (tokenContent == null) {
            throw new NoLoginException("token\u6709\u8bef\u6216\u5df2\u8fc7\u671f");
        }
        String tgt = tokenContent.getCodeContent().getTgt();
        this.ticketGrantingTicketManager.remove(tgt);
        CookieUtils.removeCookie((String)"TGC", (String)"/", (HttpServletResponse)response);
        this.accessTokenManager.remove(tgt);
    }

    @Override
    public RpcAccessToken getAccessToken(String appId, String appSecret, String username, String password, String accessToken) {
        Result<Void> appResult = this.ssoAppService.validate(appId, appSecret);
        if (!appResult.isSuccess()) {
            throw new ServiceException(appResult.getMessage());
        }
        Result<SsoUser> loginResult = this.userService.login(username, password);
        if (!loginResult.isSuccess()) {
            throw new ServiceException(loginResult.getMessage());
        }
        SsoUser user = (SsoUser)loginResult.getData();
        user.setToken(accessToken);
        String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
        CodeContent codeContent = new CodeContent(tgt, false, null);
        AccessTokenContent accessTokenContent = new AccessTokenContent(codeContent, user, appId, null);
        boolean isValid = this.sysUserLimitService.isValid(appId, accessTokenContent.getUser().getId());
        if (!isValid) {
            throw new ServiceException("\u8be5\u7528\u6237\u88ab\u9650\u5236\u8bbf\u95ee\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        return LoginUtil.genereateRpcAccessToken(accessTokenContent, null);
    }

    @Override
    public String getAccessCode(String appId, String appSecret, String accessToken) {
        return this.getAccessCode(appId, appSecret, accessToken, 1);
    }

    @Override
    public String getAccessCode(String appId, String appSecret, String accessToken, int allowedUseCount) {
        Result<Void> appResult = this.ssoAppService.validate(appId, appSecret);
        if (!appResult.isSuccess()) {
            throw new ServiceException(appResult.getMessage());
        }
        AccessTokenContent tokenContent = this.accessTokenManager.get(accessToken);
        if (tokenContent != null) {
            String tgt = tokenContent.getCodeContent().getTgt();
            String code = this.codeManager.generate(tgt, true, "", allowedUseCount);
            return code;
        }
        throw new NoLoginException("token\u6709\u8bef\u6216\u5df2\u8fc7\u671f");
    }

    private Result<Void> validateParam(String grantType, String code, String username, String password, String tel, String sessionId, String catpcha, String caUserCert, String caOauthName, String oneProcessId, String oneToken, String oneAuthCode) {
        if (GrantTypeEnum.AUTHORIZATION_CODE.getValue().equals(grantType) || GrantTypeEnum.AUTHORIZATION_CODE_MORE.getValue().equals(grantType)) {
            if (StringUtils.isEmpty((Object)code)) {
                return Result.createError((String)"code\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (GrantTypeEnum.PASSWORD.getValue().equals(grantType)) {
            if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)password)) {
                return Result.createError((String)"username\u548cpassword\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (GrantTypeEnum.PASSWORD_CAPTCHA.getValue().equals(grantType)) {
            if (StringUtils.isEmpty((Object)username) || StringUtils.isEmpty((Object)password)) {
                return Result.createError((String)"username\u548cpassword\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtils.isEmpty((Object)sessionId) || StringUtils.isEmpty((Object)catpcha)) {
                return Result.createError((String)"\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (GrantTypeEnum.TEL_CAPTCHA.getValue().equals(grantType)) {
            if (StringUtils.isEmpty((Object)tel) || StringUtils.isEmpty((Object)catpcha)) {
                return Result.createError((String)"\u624b\u673a\u53f7\u548c\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (GrantTypeEnum.CA.getValue().equals(grantType)) {
            if (StringUtils.isEmpty((Object)caUserCert)) {
                return Result.createError((String)"CA\u8bc1\u4e66\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else if (GrantTypeEnum.ONE.getValue().equals(grantType)) {
            if (StringUtils.isEmpty((Object)oneProcessId) || StringUtils.isEmpty((Object)oneToken)) {
                return Result.createError((String)"oneProcessId\u548coneToken\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            return Result.createError((String)"\u6388\u6743\u65b9\u5f0f\u4e0d\u652f\u6301");
        }
        return Result.success();
    }

    private Result<AccessTokenContent> validateAuth(String grantType, String code, String username, String password, String tel, String appId, String sessionId, String catpcha, String caUserCert, String caOauthName, String oneProcessId, String oneToken, String oneAuthCode) {
        AccessTokenContent authDto = null;
        if (GrantTypeEnum.AUTHORIZATION_CODE.getValue().equals(grantType)) {
            CodeContent codeContent = this.codeManager.getAndRemove(code);
            if (codeContent == null) {
                return Result.createError((String)"code\u6709\u8bef\u6216\u5df2\u8fc7\u671f");
            }
            SsoUser user = this.ticketGrantingTicketManager.getAndRefresh(codeContent.getTgt());
            if (user == null) {
                return Result.createError((String)"\u670d\u52a1\u7aefsession\u5df2\u8fc7\u671f");
            }
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        } else if (GrantTypeEnum.AUTHORIZATION_CODE_MORE.getValue().equals(grantType)) {
            CodeContent codeContent = this.codeManager.get(code);
            if (codeContent == null) {
                return Result.createError((String)"code\u6709\u8bef\u6216\u5df2\u8fc7\u671f");
            }
            SsoUser user = this.ticketGrantingTicketManager.getAndRefresh(codeContent.getTgt());
            if (user == null) {
                return Result.createError((String)"\u670d\u52a1\u7aefsession\u5df2\u8fc7\u671f");
            }
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        } else if (GrantTypeEnum.PASSWORD.getValue().equals(grantType)) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = servletRequestAttributes.getRequest();
            Result<SsoUser> loginResult = this.userService.login(username, password, "", "", request);
            if (!loginResult.isSuccess()) {
                return Result.createError((String)loginResult.getMessage());
            }
            SsoUser user = (SsoUser)loginResult.getData();
            String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
            CodeContent codeContent = new CodeContent(tgt, false, null);
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        } else if (GrantTypeEnum.PASSWORD_CAPTCHA.getValue().equals(grantType)) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = servletRequestAttributes.getRequest();
            Result<SsoUser> loginResult = this.userService.login(username, password, sessionId, catpcha, request);
            if (!loginResult.isSuccess()) {
                return Result.createError((String)loginResult.getMessage());
            }
            SsoUser user = (SsoUser)loginResult.getData();
            String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
            CodeContent codeContent = new CodeContent(tgt, false, null);
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        } else if (GrantTypeEnum.TEL_CAPTCHA.getValue().equals(grantType)) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = servletRequestAttributes.getRequest();
            Result<SsoUser> loginResult = this.userService.loginBySms(tel, sessionId, catpcha, request);
            if (!loginResult.isSuccess()) {
                return Result.createError((String)loginResult.getMessage());
            }
            SsoUser user = (SsoUser)loginResult.getData();
            String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
            CodeContent codeContent = new CodeContent(tgt, false, null);
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        } else if (GrantTypeEnum.CA.getValue().equals(grantType)) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = servletRequestAttributes.getRequest();
            Result<SsoUser> loginResult = this.userService.loginByCa(caUserCert, caOauthName, request);
            if (!loginResult.isSuccess()) {
                return Result.createError((String)loginResult.getMessage());
            }
            SsoUser user = (SsoUser)loginResult.getData();
            String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
            CodeContent codeContent = new CodeContent(tgt, false, null);
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        } else if (GrantTypeEnum.ONE.getValue().equals(grantType)) {
            ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
            HttpServletRequest request = servletRequestAttributes.getRequest();
            Result<SsoUser> loginResult = this.userService.loginByOne(oneProcessId, oneToken, oneAuthCode, request);
            if (!loginResult.isSuccess()) {
                return Result.createError((String)loginResult.getMessage());
            }
            SsoUser user = (SsoUser)loginResult.getData();
            String tgt = this.ticketGrantingTicketManager.generate((SsoUser)loginResult.getData());
            CodeContent codeContent = new CodeContent(tgt, false, null);
            authDto = new AccessTokenContent(codeContent, user, appId, null);
        }
        return Result.createSuccess((Object)authDto);
    }
}

