/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTenantSubFunction;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.mapper.SysTenantSubfunctionMapper;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.service.sys.SysTenantSubFunctionService;
import com.geoway.jckj.biz.service.sys.impl.SysRoleMenuServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysTenantSubFunctionServiceImpl
extends ServiceImpl<SysTenantSubfunctionMapper, SysTenantSubFunction>
implements SysTenantSubFunctionService {
    @Autowired
    private SysTenantMapper sysTenantMapper;
    @Autowired
    private SysRoleMenuServiceImpl sysRoleMenuServiceImpl;
    @Autowired
    SysRoleSystemService sysRoleSystemService;

    @Override
    public void bindSubFunctions(String tenantId, String menuId, String subFunctionIds) {
        List<String> idArr = Arrays.asList(subFunctionIds.split(","));
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantSubFunction::getTenantid, (Object)tenantId);
        menuWrapper.eq(SysTenantSubFunction::getMenuid, (Object)menuId);
        SysTenant sysTenant = (SysTenant)this.sysTenantMapper.selectById((Serializable)((Object)tenantId));
        if (StrUtil.isNotBlank((CharSequence)sysTenant.getDefaultRoleId())) {
            this.sysRoleMenuServiceImpl.saveRoleSubFunctions(sysTenant.getDefaultRoleId(), menuId, idArr);
        }
        this.remove((Wrapper)menuWrapper);
        ArrayList<SysTenantSubFunction> subFunctions = new ArrayList<SysTenantSubFunction>();
        for (String subFunctionId : idArr) {
            SysTenantSubFunction subFunction = new SysTenantSubFunction();
            subFunction.setMenuid(menuId);
            subFunction.setTenantid(tenantId);
            subFunction.setSubfunctionid(subFunctionId);
            subFunctions.add(subFunction);
        }
        this.saveBatch(subFunctions);
    }

    @Override
    public List<SysTenantSubFunction> queryBindSubFunctions(String tenantId, String menuId) {
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantSubFunction::getTenantid, (Object)tenantId);
        menuWrapper.eq(SysTenantSubFunction::getMenuid, (Object)menuId);
        List menus = this.list((Wrapper)menuWrapper);
        return menus;
    }
}

