/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.base.support.BaseTreeUtil;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysMenuPath;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysRoleMenu;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.entity.SysUserRole;
import com.geoway.jckj.biz.exception.BizException;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.service.ISaasEntityService;
import com.geoway.jckj.biz.service.dev.base.IMenuUrlHandlerService;
import com.geoway.jckj.biz.service.sys.SysMenuPathService;
import com.geoway.jckj.biz.service.sys.SysMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysTenantMenuService;
import com.geoway.jckj.biz.service.sys.SysTenantService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysMenuServiceImpl
extends MPJBaseServiceImpl<SysMenuMapper, SysMenu>
implements SysMenuService,
ISaasEntityService<SysMenu> {
    final String rootPid = "0";
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setWeightKey("sort").setIdKey("id");
    public static final int m_relPath = 1;
    public static final int m_absPath = 2;
    @Autowired
    private IMenuUrlHandlerService urlDynamicParameterService;
    @Autowired
    private SysMenuPathService sysMenuPathService;
    @Autowired
    SysTenantMenuService sysTenantMenuService;
    @Autowired
    SysSystemMapper sysSystemMapper;
    @Autowired
    SysTenantService sysTenantService;
    @Autowired
    SysRoleService sysRoleService;

    @Override
    public void saveOrUp(SysMenu menu) throws Exception {
        if (menu.getMenuType() == 2) {
            if (StrUtil.isBlank((CharSequence)menu.getPathId())) {
                throw new BizException("\u6302\u63a5\u83dc\u5355\u8def\u5f84Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StrUtil.isBlank((CharSequence)menu.getRelMenuId())) {
                throw new BizException("\u6302\u63a5\u83dc\u5355\u5173\u8054\u83dc\u5355Id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysMenu::getSystemId, (Object)menu.getSystemId());
        if (StrUtil.isNotBlank((CharSequence)menu.getId())) {
            wrapper.ne(SysMenu::getId, (Object)menu.getId());
        }
        LambdaQueryWrapper nameWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.clone()).eq(SysMenu::getName, (Object)menu.getName());
        nameWrapper.eq(SysMenu::getPid, (Object)menu.getPid());
        nameWrapper.eq(SysMenu::getGroup, (Object)menu.getGroup());
        if (this.count((Wrapper)nameWrapper) > 0) {
            throw new ServiceException("\u83dc\u5355\u540d\u79f0:" + menu.getName() + " \u5df2\u5b58\u5728\uff01");
        }
        LambdaQueryWrapper keyWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.clone()).eq(SysMenu::getKey, (Object)menu.getKey());
        if (this.count((Wrapper)keyWrapper) > 0) {
            throw new ServiceException("\u83dc\u5355\u5173\u952e\u5b57:" + menu.getKey() + " \u5df2\u5b58\u5728\uff01");
        }
        if (StrUtil.isBlank((CharSequence)menu.getId())) {
            LambdaQueryWrapper brotherWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.clone()).eq(SysMenu::getPid, (Object)menu.getPid());
            List brotherMenus = this.list((Wrapper)brotherWrapper);
            Integer sort = 1;
            if (brotherMenus.size() > 0) {
                sort = brotherMenus.stream().flatMapToInt(f -> IntStream.of((int)f.getSort())).max().orElse(1) + 1;
            }
            menu.setSort(sort);
            this.wrapperEntity(menu);
        } else if (menu.getSort() == null) {
            throw new ServiceException("\u6392\u5e8f\u503c\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SysSystem sysSystem = (SysSystem)this.sysSystemMapper.selectById((Serializable)((Object)menu.getSystemId()));
        if (sysSystem != null && sysSystem.getType() == 1) {
            SysMenuPath sysMenuPath;
            if (StrUtil.isBlank((CharSequence)menu.getPathId())) {
                sysMenuPath = new SysMenuPath();
                sysMenuPath.setPid(menu.getSystemId());
            } else {
                sysMenuPath = (SysMenuPath)this.sysMenuPathService.getById((Serializable)((Object)menu.getPathId()));
            }
            if (StrUtil.isNotBlank((CharSequence)menu.getPath())) {
                sysMenuPath.setPath(menu.getPath());
            }
            if (menu.getPathType() != null) {
                sysMenuPath.setPathType(menu.getPathType());
            }
            this.sysMenuPathService.saveOrUpdate(sysMenuPath);
            menu.setPathId(sysMenuPath.getId());
        }
        this.saveOrUpdate(menu);
    }

    @Override
    public List<SysMenu> queryMenuTree(String systemId, Integer group) {
        List<SysMenu> menus = this.queryMenuList(systemId, group);
        List menuTrees = BaseTreeUtil.listToTree(menus, (TreeNodeConfig)this.treeNodeConfig, (String)"0");
        return menuTrees;
    }

    private MPJLambdaWrapper<SysMenu> buildMenuMPJLambdaWrapper(String systemId, Integer group) {
        SysSystem sysSystem = (SysSystem)this.sysSystemMapper.selectById((Serializable)((Object)systemId));
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.eq(SysMenu::getSystemId, (Object)systemId);
        queryWrapper.leftJoin(SysMenuPath.class, SysMenuPath::getId, SysMenu::getPathId);
        if (StringUtils.isNotEmpty((String)this.getTenantId()) && !sysSystem.getTenantid().equals(this.getTenantId())) {
            queryWrapper.leftJoin(SysTenantMenu.class, SysTenantMenu::getMenuid, SysMenu::getId);
            queryWrapper.eq(SysTenantMenu::getTenantid, (Object)this.getTenantId());
        }
        if (group != null) {
            queryWrapper.eq(SysMenu::getGroup, (Object)group);
        }
        queryWrapper.selectAssociation(SysMenuPath.class, SysMenu::getMenuPath);
        queryWrapper.orderByAsc(SysMenu::getSort);
        return queryWrapper;
    }

    private List<SysMenu> queryParentMenuList(List<SysMenu> menus) {
        ArrayList<SysMenu> parentMenus = new ArrayList<SysMenu>();
        ArrayList<String> allPids = new ArrayList<String>();
        this.queryAllPidsNoContains(menus, allPids);
        List allIds = menus.stream().map(menuItem -> menuItem.getId()).collect(Collectors.toList());
        List filterPids = allPids.stream().filter(pid -> !allIds.contains(pid)).collect(Collectors.toList());
        if (filterPids.size() > 0) {
            MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
            queryWrapper.in(SysMenu::getId, filterPids);
            queryWrapper.leftJoin(SysMenuPath.class, SysMenuPath::getId, SysMenu::getPathId);
            queryWrapper.selectAssociation(SysMenuPath.class, SysMenu::getMenuPath);
            queryWrapper.orderByAsc(SysMenu::getSort);
            List pMenus = this.selectJoinList(SysMenu.class, (MPJBaseJoin)queryWrapper);
            parentMenus.addAll(pMenus);
        }
        return parentMenus;
    }

    @Override
    public List<SysMenu> queryMenuList(String systemId, Integer group) {
        List menus = this.list((Wrapper)this.buildMenuMPJLambdaWrapper(systemId, group));
        List<SysMenu> pmenus = this.queryParentMenuList(menus);
        menus.addAll(pmenus);
        this.wrapperMenus(menus);
        return menus;
    }

    public void wrapperMenus(List<SysMenu> menus) {
        for (SysMenu menu : menus) {
            SysMenuPath sysMenuPath = menu.getMenuPath();
            if (sysMenuPath == null) continue;
            menu.setPath(sysMenuPath.getPath());
            menu.setPathType(sysMenuPath.getPathType());
        }
        this.wrapperMenuIsolate(menus);
        this.wrapperMenuAbsPath(menus);
    }

    @Override
    public void deleteMenu(String id) throws Exception {
        SysMenu menu = (SysMenu)this.getById((Serializable)((Object)id));
        if (menu == null) {
            return;
        }
        LambdaQueryWrapper baseWrapper = Wrappers.lambdaQuery();
        int count = this.count((Wrapper)((LambdaQueryWrapper)baseWrapper.clone()).eq(SysMenu::getPid, (Object)id));
        if (count > 0) {
            throw new BizException("\u5b58\u5728\u5b50\u83dc\u5355,\u65e0\u6cd5\u5220\u9664\uff01");
        }
        List relMenus = this.list((Wrapper)((LambdaQueryWrapper)baseWrapper.clone()).eq(SysMenu::getRelMenuId, (Object)id));
        if (relMenus.size() > 0) {
            throw new BizException("\u83dc\u5355\u5df2\u6302\u63a5\u529f\u80fd,\u65e0\u6cd5\u5220\u9664,\u8bf7\u53d6\u6d88\u6302\u63a5\u529f\u80fd\u91cd\u8bd5\uff01");
        }
        String pathId = menu.getPathId();
        this.removeById((Serializable)((Object)id));
        int iPathCount = this.count((Wrapper)((LambdaQueryWrapper)baseWrapper.clone()).eq(SysMenu::getPathId, (Object)pathId));
        if (iPathCount == 0 && StrUtil.isNotBlank((CharSequence)pathId)) {
            this.sysMenuPathService.removeById((Serializable)((Object)pathId));
        }
    }

    @Override
    public void sortUp(Integer flag, String id, String pid, String systemId, Integer sort) throws Exception {
        SysMenu menu = (SysMenu)this.getById((Serializable)((Object)id));
        if (menu == null) {
            return;
        }
        sort = menu.getSort();
        int otherSort = sort;
        if (flag != null) {
            LambdaUpdateWrapper queryWrapper = Wrappers.lambdaUpdate();
            switch (flag) {
                case 1: {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).orderByAsc(SysMenu::getSort)).last("limit 1");
                    SysMenu minInfo = this.list((Wrapper)queryWrapper).stream().findFirst().orElse(null);
                    if (minInfo != null && !minInfo.getSort().equals(sort)) {
                        Integer min = minInfo.getSort();
                        sort = sort - 1;
                        while (sort >= min) {
                            this.updateSort(pid, systemId, sort, sort + 1);
                            Integer n = sort;
                            Integer n2 = sort = Integer.valueOf(sort - 1);
                        }
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)id)).set(SysMenu::getSort, (Object)min));
                        break;
                    }
                    throw new Exception("\u8be5\u6761\u8bb0\u5f55\u5df2\u7ecf\u7f6e\u9876\u4e86\uff01");
                }
                case 2: {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).lt(SysMenu::getSort, (Object)sort)).orderByDesc(SysMenu::getSort);
                    SysMenu info = this.list((Wrapper)queryWrapper).stream().findFirst().orElse(null);
                    if (info != null && !info.getSort().equals(sort)) {
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)id)).set(SysMenu::getSort, (Object)info.getSort()));
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)info.getId())).set(SysMenu::getSort, (Object)sort));
                        break;
                    }
                    throw new Exception("\u8be5\u6761\u8bb0\u5f55\u5df2\u7ecf\u7f6e\u9876\u4e86\uff01");
                }
                case 3: {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).gt(SysMenu::getSort, (Object)sort)).orderByAsc(SysMenu::getSort);
                    SysMenu one = this.list((Wrapper)queryWrapper).stream().findFirst().orElse(null);
                    if (one != null && !one.getSort().equals(sort)) {
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)id)).set(SysMenu::getSort, (Object)one.getSort()));
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)one.getId())).set(SysMenu::getSort, (Object)sort));
                        break;
                    }
                    throw new Exception("\u8be5\u6761\u8bb0\u5f55\u5df2\u7ecf\u7f6e\u5e95\u4e86\uff01");
                }
                case 4: {
                    ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)queryWrapper.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).orderByDesc(SysMenu::getSort)).last("limit 1");
                    SysMenu maxInfo = this.list((Wrapper)queryWrapper).stream().findFirst().orElse(null);
                    if (maxInfo != null && !maxInfo.getSort().equals(sort)) {
                        Integer max = maxInfo.getSort();
                        sort = sort + 1;
                        while (sort <= max) {
                            this.updateSort(pid, systemId, sort, sort - 1);
                            Integer n = sort;
                            Integer n3 = sort = Integer.valueOf(sort + 1);
                        }
                        this.update((Wrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(SysMenu.class).eq(SysMenu::getId, (Object)id)).set(SysMenu::getSort, (Object)max));
                        break;
                    }
                    throw new Exception("\u8be5\u6761\u8bb0\u5f55\u5df2\u7ecf\u7f6e\u5e95\u4e86\uff01");
                }
            }
        }
    }

    @Override
    public void setDefault(String id) {
        SysMenu menu = (SysMenu)this.getById((Serializable)((Object)id));
        if (menu != null && StrUtil.isNotBlank((CharSequence)menu.getSystemId())) {
            LambdaUpdateWrapper updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.eq(SysMenu::getSystemId, (Object)menu.getSystemId());
            updateWrapper.set(SysMenu::getIsdefault, (Object)0);
            this.update((Wrapper)updateWrapper);
            updateWrapper.clear();
            updateWrapper.eq(SysMenu::getId, (Object)id);
            updateWrapper.set(SysMenu::getIsdefault, (Object)1);
            this.update((Wrapper)updateWrapper);
        }
    }

    private List<SysMenu> queryNoLoginMenuList(String systemId, Integer group) {
        MPJLambdaWrapper<SysMenu> baseQueryWrapper = this.buildMenuMPJLambdaWrapper(systemId, group);
        baseQueryWrapper.eq(SysMenu::getNologin, (Object)1);
        List noLoginMenus = this.selectJoinList(SysMenu.class, (MPJBaseJoin)baseQueryWrapper);
        return noLoginMenus;
    }

    private List<SysMenu> queryLoginMenuList(String systemId, Integer group) {
        if (StrUtil.isBlank((CharSequence)this.getQueryUserId())) {
            return new ArrayList<SysMenu>();
        }
        List<SysRole> sysRoles = this.sysRoleService.queryUserRoles(this.getQueryUserId());
        if (sysRoles.size() == 0) {
            return new ArrayList<SysMenu>();
        }
        MPJLambdaWrapper<SysMenu> roleQueryWrapper = this.buildMenuMPJLambdaWrapper(systemId, group);
        roleQueryWrapper.eq(SysMenu::getNologin, (Object)0);
        roleQueryWrapper.leftJoin(SysMenuPath.class, SysMenuPath::getId, SysMenu::getPathId);
        roleQueryWrapper.leftJoin(SysRoleMenu.class, SysRoleMenu::getMenuid, SysMenu::getId);
        roleQueryWrapper.leftJoin(SysUserRole.class, SysUserRole::getRoleid, SysRoleMenu::getRoleid);
        roleQueryWrapper.leftJoin(SysRole.class, SysRole::getId, SysUserRole::getRoleid);
        roleQueryWrapper.eq(SysUserRole::getUserid, (Object)this.getQueryUserId());
        roleQueryWrapper.in(SysRole::getId, (Collection)sysRoles.stream().map(g -> g.getId()).collect(Collectors.toList()));
        roleQueryWrapper.distinct();
        roleQueryWrapper.selectAssociation(SysMenuPath.class, SysMenu::getMenuPath);
        roleQueryWrapper.orderByAsc(SysMenu::getSort);
        List userMenus = this.selectJoinList(SysMenu.class, (MPJBaseJoin)roleQueryWrapper);
        return userMenus;
    }

    @Override
    public List<SysMenu> queryUserMenusList(String systemId, Integer group) {
        ArrayList<SysMenu> menus = new ArrayList<SysMenu>();
        List<SysMenu> noLoginMenus = this.queryNoLoginMenuList(systemId, group);
        List<SysMenu> loginMenus = this.queryLoginMenuList(systemId, group);
        loginMenus.removeIf(f -> noLoginMenus.stream().anyMatch(g -> g.getId().equals(f.getId())));
        menus.addAll(noLoginMenus);
        menus.addAll(loginMenus);
        this.wrapperMenus(menus);
        return menus;
    }

    @Override
    public List<SysMenu> queryUserMenuTree(String systemId, Integer group) {
        List<SysMenu> menus = this.queryUserMenusList(systemId, group);
        menus.addAll(this.queryParentMenuList(menus));
        List menuTrees = BaseTreeUtil.listToTree(menus, (TreeNodeConfig)this.treeNodeConfig, (String)"0");
        return menuTrees;
    }

    private void wrapperMenuAbsPath(List<SysMenu> menus) {
        HashMap<String, String> mapSystemPath = new HashMap<String, String>();
        String absPath = "";
        for (SysMenu menu : menus) {
            SysSystem sysSystem;
            if (menu.getMenuPath() == null || StrUtil.isBlank((CharSequence)menu.getMenuPath().getPath())) continue;
            String sysId = menu.getMenuPath().getPid();
            if (menu.getMenuPath().getPathType() == 2) {
                menu.setAbsPath(menu.getMenuPath().getPath());
                menu.setPath(menu.getMenuPath().getPath());
                continue;
            }
            if (!mapSystemPath.containsKey(sysId) && (sysSystem = (SysSystem)this.sysSystemMapper.selectById((Serializable)((Object)sysId))) != null) {
                String url = sysSystem.getUrl() == null ? "" : sysSystem.getUrl();
                mapSystemPath.put(sysId, url);
            }
            if (!mapSystemPath.containsKey(sysId)) continue;
            String url = (String)mapSystemPath.get(sysId);
            String joinTag = menu.getMenuPath().getPath().startsWith("/") || url.endsWith("/") ? "" : "/";
            absPath = url + joinTag + menu.getMenuPath().getPath();
            menu.setAbsPath(absPath);
            menu.setPath(menu.getMenuPath().getPath());
        }
    }

    private void wrapperMenuIsolate(List<SysMenu> menus) {
        MPJLambdaWrapper isolateJoinWrapper = MPJWrappers.lambdaJoin();
        isolateJoinWrapper.leftJoin(SysTenantMenu.class, SysTenantMenu::getMenuid, SysMenu::getId);
        isolateJoinWrapper.eq(SysTenantMenu::getTenantid, (Object)this.getTenantId());
        isolateJoinWrapper.eq(SysTenantMenu::getIsolate, (Object)1);
        List isolateMenus = this.selectJoinList(SysMenu.class, (MPJBaseJoin)isolateJoinWrapper);
        List<String> menuIds = isolateMenus.stream().map(i -> i.getId()).collect(Collectors.toList());
        this.wrapperMenuIsolate(menuIds, menus);
    }

    private void wrapperMenuIsolate(List<String> menuIds, List<SysMenu> menus) {
        for (SysMenu menu : menus) {
            if (menuIds.contains(menu.getId()) || menuIds.contains(menu.getRelMenuId())) {
                menu.setIsolate(1);
            }
            if (menu.getChildren() == null) continue;
            this.wrapperMenuIsolate(menuIds, menu.getChildren());
        }
    }

    private void queryAllPidsNoContains(List<SysMenu> menus, List<String> pids) {
        ArrayList<String> newPids = new ArrayList<String>();
        for (SysMenu menu : menus) {
            boolean exists = StrUtil.isNotBlank((CharSequence)menu.getPid()) && !menu.getPid().equals("0");
            if (!exists || pids.contains(menu.getPid())) continue;
            newPids.add(menu.getPid());
        }
        pids.addAll(newPids);
        if (newPids.size() > 0) {
            List pMenus = this.listByIds(newPids);
            this.queryAllPidsNoContains(pMenus, pids);
        }
    }

    @Override
    public SysMenu queryMenuByKey(String menuKey, String systemId) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysMenu::getSystemId, (Object)systemId);
        wrapper.eq(SysMenu::getKey, (Object)menuKey);
        wrapper.last("LIMIT 1");
        SysMenu menu = (SysMenu)this.getOne((Wrapper)wrapper);
        SysMenuPath sysMenuPath = (SysMenuPath)this.sysMenuPathService.getById((Serializable)((Object)menu.getPathId()));
        if (sysMenuPath != null) {
            menu.setPath(sysMenuPath.getPath());
            menu.setPathType(sysMenuPath.getPathType());
            menu.setMenuPath(sysMenuPath);
        }
        return menu;
    }

    @Override
    public SysMenu queryRegisterMenu(String menuId) {
        SysMenu srcMenu = (SysMenu)this.getById((Serializable)((Object)menuId));
        if (StrUtil.isBlank((CharSequence)srcMenu.getRelMenuId()) || StrUtil.isBlank((CharSequence)srcMenu.getPathId())) {
            return srcMenu;
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysMenu::getPathId, (Object)srcMenu.getPathId());
        List menus = this.list((Wrapper)queryWrapper);
        return menus.stream().filter(f -> StrUtil.isBlank((CharSequence)f.getRelMenuId())).findAny().orElse(null);
    }

    @Override
    public void setIsolate(String menuId, String tenantId, boolean isIsolate) {
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysTenantMenu::getMenuid, (Object)menuId);
        queryWrapper.eq(SysTenantMenu::getTenantid, (Object)tenantId);
        SysTenantMenu sysTenantMenu = (SysTenantMenu)this.sysTenantMenuService.getOne((Wrapper)queryWrapper);
        if (sysTenantMenu == null) {
            return;
        }
        sysTenantMenu.setIsolate(isIsolate ? 1 : 0);
        this.sysTenantMenuService.saveOrUpdate(sysTenantMenu, (Wrapper)queryWrapper);
    }

    @Override
    public HashMap<String, Object> queryUserSystemMenus(String systemId) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (StrUtil.isBlank((CharSequence)this.getQueryUserId()) || StrUtil.isBlank((CharSequence)systemId)) {
            return map;
        }
        List<SysMenu> sysMenus = this.queryUserMenuTree(systemId, 0);
        List<SysMenu> uCenterMenu = this.queryUserMenuTree(systemId, 1);
        map.put("menu", sysMenus);
        map.put("uCenterMenu", uCenterMenu);
        return map;
    }

    private void updateSort(String pid, String systemId, Integer sort, Integer value) {
        LambdaUpdateWrapper update = Wrappers.lambdaUpdate();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)update.eq(SysMenu::getPid, (Object)pid)).eq(SysMenu::getSystemId, (Object)systemId)).eq(SysMenu::getSort, (Object)sort)).set(SysMenu::getSort, (Object)value);
        this.update((Wrapper)update);
    }

    private List<SysMenu> buildTree(List<SysMenu> list, Integer flag) {
        for (SysMenu menuSys : list) {
            List children;
            SysMenuPath sysMenuPath = (SysMenuPath)this.sysMenuPathService.getById((Serializable)((Object)menuSys.getPathId()));
            if (sysMenuPath != null) {
                menuSys.setPath(sysMenuPath.getPath());
                menuSys.setPathType(sysMenuPath.getPathType());
            }
            if ((children = this.list((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"f_pid", (Object)menuSys.getId())).orderByAsc((Object)"f_sort"))).size() > 0) {
                menuSys.setChildren(this.buildTree(children, flag));
                continue;
            }
            menuSys.setChildren(new ArrayList<SysMenu>());
        }
        return list;
    }

    private List<SysMenu> menuSort(List<SysMenu> menuList) {
        Collections.sort(menuList, new Comparator<SysMenu>(){

            @Override
            public int compare(SysMenu menu1, SysMenu menu2) {
                int flag = menu1.getSort() - menu2.getSort();
                return flag;
            }
        });
        return menuList;
    }
}

