/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysTenantMenu;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysTenantMapper;
import com.geoway.jckj.biz.mapper.SysTenantMenuMapper;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.service.sys.SysTenantMenuService;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysTenantMenuServiceImpl
extends ServiceImpl<SysTenantMenuMapper, SysTenantMenu>
implements SysTenantMenuService {
    @Autowired
    private SysTenantMapper sysTenantMapper;
    @Autowired
    private SysRoleMenuService sysRoleMenuService;
    @Autowired
    SysRoleSystemService sysRoleSystemService;
    @Autowired
    private SysMenuMapper sysMenuMapper;

    @Override
    public void bindMenus(String tenantId, String systemId, List<SysTenantMenu> menus) {
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysTenantMenu::getTenantid, (Object)tenantId);
        menuWrapper.eq(SysTenantMenu::getSystemid, (Object)systemId);
        SysTenant sysTenant = (SysTenant)this.sysTenantMapper.selectById((Serializable)((Object)tenantId));
        if (StrUtil.isNotBlank((CharSequence)sysTenant.getDefaultRoleId())) {
            this.sysRoleMenuService.removeRelateMenus(sysTenant.getDefaultRoleId(), systemId);
            this.sysRoleMenuService.saveRoleMenus(sysTenant.getDefaultRoleId(), systemId, menus.stream().map(f -> f.getMenuid()).collect(Collectors.toList()));
        }
        this.remove((Wrapper)menuWrapper);
        this.saveBatch(menus);
    }

    @Override
    public List<SysTenantMenu> queryBindMenus(String tenantId, String systemId) {
        LambdaQueryWrapper sysTenantMenuWrapper = Wrappers.lambdaQuery();
        sysTenantMenuWrapper.eq(SysTenantMenu::getTenantid, (Object)tenantId);
        sysTenantMenuWrapper.eq(SysTenantMenu::getSystemid, (Object)systemId);
        List sysTenantMenus = this.list((Wrapper)sysTenantMenuWrapper);
        if (sysTenantMenus.size() == 0) {
            return sysTenantMenus;
        }
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.in(SysMenu::getPid, (Collection)sysTenantMenus.stream().map(f -> f.getMenuid()).collect(Collectors.toList()));
        List pIds = this.sysMenuMapper.selectList((Wrapper)menuWrapper).stream().map(f -> f.getPid()).collect(Collectors.toList());
        sysTenantMenus.removeIf(f -> pIds.contains(f.getMenuid()));
        return sysTenantMenus;
    }
}

