/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.util;

import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.SysBizManage;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.sys.SysBizManageService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class BizManageUtil {
    public static SysBizManage getBizManage() {
        String userId = CommonLoginUserUtil.getUserId();
        if (StrUtil.isBlank((CharSequence)userId)) {
            return null;
        }
        SysBizManageService sysBizManageService = (SysBizManageService)SpringUtils.getBean(SysBizManageService.class);
        SysBizManage sysBizManage = sysBizManageService.queryByUserId(userId);
        return sysBizManage;
    }

    public static String getBizManageId() {
        String userId = CommonLoginUserUtil.getUserId();
        if (StrUtil.isBlank((CharSequence)userId)) {
            return null;
        }
        SysBizManageService sysBizManageService = (SysBizManageService)SpringUtils.getBean(SysBizManageService.class);
        SysBizManage sysBizManage = sysBizManageService.queryByUserId(userId);
        if (sysBizManage == null) {
            return null;
        }
        return sysBizManage.getId();
    }

    public static List<String> getBizManageOrgIds() {
        String userId = CommonLoginUserUtil.getUserId();
        if (StrUtil.isBlank((CharSequence)userId)) {
            return new ArrayList<String>();
        }
        SysBizManageService sysBizManageService = (SysBizManageService)SpringUtils.getBean(SysBizManageService.class);
        SysBizManage sysBizManage = sysBizManageService.queryByUserId(userId);
        if (sysBizManage == null) {
            return new ArrayList<String>();
        }
        IUnityOrganizationService organizationService = (IUnityOrganizationService)SpringUtils.getBean(IUnityOrganizationService.class);
        ArrayList<String> orgs = new ArrayList<String>();
        List manageOrgs = sysBizManage.getOrganizations().stream().map(SysOrganization::getId).collect(Collectors.toList());
        for (String orgId : manageOrgs) {
            orgs.addAll(organizationService.queryAllChildOrg(orgId).stream().map(SysOrganization::getId).collect(Collectors.toList()));
        }
        return orgs;
    }

    public static List<String> getBizManageRegionIds() {
        String userId = CommonLoginUserUtil.getUserId();
        if (StrUtil.isBlank((CharSequence)userId)) {
            return new ArrayList<String>();
        }
        SysRegionService sysRegionService = (SysRegionService)SpringUtils.getBean(SysRegionService.class);
        SysBizManageService sysBizManageService = (SysBizManageService)SpringUtils.getBean(SysBizManageService.class);
        SysBizManage sysBizManage = sysBizManageService.queryByUserId(userId);
        if (sysBizManage == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> regions = new ArrayList<String>();
        List manageRegions = sysBizManage.getRegions().stream().map(SysRegion::getId).collect(Collectors.toList());
        for (String regionId : manageRegions) {
            regions.addAll(sysRegionService.queryRegionListById(regionId).stream().map(SysRegion::getId).collect(Collectors.toList()));
        }
        return regions;
    }

    public static List<String> getBizManageRoleIds() {
        String userId = CommonLoginUserUtil.getUserId();
        if (StrUtil.isBlank((CharSequence)userId)) {
            return new ArrayList<String>();
        }
        SysBizManageService sysBizManageService = (SysBizManageService)SpringUtils.getBean(SysBizManageService.class);
        SysBizManage sysBizManage = sysBizManageService.queryByUserId(userId);
        if (sysBizManage == null) {
            return new ArrayList<String>();
        }
        return sysBizManage.getSysRoles().stream().map(f -> f.getId()).collect(Collectors.toList());
    }
}

