/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.util;

import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.SysOrganization;
import com.geoway.jckj.biz.entity.SysRegion;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysTenant;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.base.IUserService;
import com.geoway.jckj.biz.service.dev.unity.IUnityOrganizationService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysRegionService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.geoway.jckj.biz.service.sys.SysTenantService;
import com.geoway.jckj.biz.service.sys.SysUserCatalogService;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.SsoUser;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class SysUserUtil {
    public static void wrapperUsers(List<SysUser> users) {
        SysUserUtil.wrapperUserRolesNames(users);
        SysUserUtil.wrapperUserOrgsNames(users);
        SysUserUtil.wrapperUserCatalogs(users);
        SysUserUtil.wrapperUserRegions(users);
    }

    public static void wrapperUserRolesNames(List<SysUser> users) {
        SysRoleService sysRoleService = (SysRoleService)SpringUtils.getBean(SysRoleService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            List<SysRole> roles = sysRoleService.queryUserRoles(user.getId());
            List<String> roleAllNames = roles.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setRoles(roles);
            user.setRoleNames(roleAllNames);
        }
    }

    public static void wrapperUserOrgsNames(List<SysUser> users) {
        IUnityOrganizationService organizationService = (IUnityOrganizationService)SpringUtils.getBean(IUnityOrganizationService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            List<SysOrganization> organizations = organizationService.queryUserOrgs(user.getId());
            List<String> organizationNames = organizations.stream().map(x -> x.getName()).collect(Collectors.toList());
            user.setOrganizations(organizations);
            user.setOrgNames(organizationNames);
        }
    }

    public static void wrapperUserCatalogs(List<SysUser> users) {
        SysUserCatalogService userCatalogService = (SysUserCatalogService)SpringUtils.getBean(SysUserCatalogService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            user.setCatalog(userCatalogService.getUserCatalog(user.getId()));
        }
    }

    public static void wrapperUserRegions(List<SysUser> users) {
        SysRegionService userRegionService = (SysRegionService)SpringUtils.getBean(SysRegionService.class);
        for (SysUser user : users) {
            if (user == null) continue;
            user.setRegions(userRegionService.queryUserRegions(user.getId()));
        }
    }

    public static SsoUser convertToSsoUser(SysUser user) {
        SsoUser ssoUser = new SsoUser();
        SysUserUtil.wrapperUsers(Collections.singletonList(user));
        SysRegionService sysRegionService = (SysRegionService)SpringUtils.getBean(SysRegionService.class);
        SysTenantService sysTenantService = (SysTenantService)SpringUtils.getBean(SysTenantService.class);
        SysRoleService sysRoleService = (SysRoleService)SpringUtils.getBean(SysRoleService.class);
        List<SysRegion> regions = sysRegionService.queryUserRegions(user.getId());
        String regionCode = regions.stream().map(i -> i.getCode()).collect(Collectors.joining(","));
        String regionName = regions.stream().map(i -> i.getName()).collect(Collectors.joining(","));
        if (user.getCatalog().equals(RoleLevelEnum.tenantAdmin.getValue())) {
            List<SysTenant> sysTenants = sysTenantService.queryByUserId(user.getId());
            String tenant = sysTenants.stream().map(f -> f.getId()).collect(Collectors.joining(","));
            ssoUser.setTenantIds(tenant);
        }
        ssoUser.setRoldIds(sysRoleService.queryUserRoles(user.getId()).stream().map(f -> f.getId()).collect(Collectors.joining(",")));
        ssoUser.setId(user.getId());
        ssoUser.setUserid(user.getId());
        ssoUser.setUserName(user.getAname());
        ssoUser.setLoginName(user.getName());
        ssoUser.setRegionCode(regionCode);
        ssoUser.setRegionName(regionName);
        ssoUser.setUserCatalog(user.getCatalog());
        ssoUser.setSource(user.getSource());
        return ssoUser;
    }

    public static SysUser getGuestUser() {
        IUnityUserService unityUserService = (IUnityUserService)SpringUtils.getBean(IUnityUserService.class);
        SysUser sysUser = ((IUserService)unityUserService.getLocalService()).query("guest");
        sysUser.setCatalog(RoleLevelEnum.guest.getValue());
        return sysUser;
    }
}

