/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysRoleMenu;
import com.geoway.jckj.biz.mapper.SysMenuMapper;
import com.geoway.jckj.biz.mapper.SysRoleMenuMapper;
import com.geoway.jckj.biz.mapper.SysSubFunctionMapper;
import com.geoway.jckj.biz.service.sys.SysRoleMenuService;
import com.geoway.jckj.biz.service.sys.SysRoleSubFunctionService;
import com.geoway.jckj.biz.service.sys.SysSubFunctionService;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.JoinWrappers;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysRoleMenuServiceImpl
extends ServiceImpl<SysRoleMenuMapper, SysRoleMenu>
implements SysRoleMenuService {
    @Autowired
    SysMenuMapper sysMenuMapper;
    @Autowired
    SysSubFunctionMapper sysSubFunctionMapper;
    @Autowired
    SysRoleSubFunctionService sysRoleSubfunctionService;
    @Autowired
    SysSubFunctionService sysSubFunctionService;

    @Override
    public List<SysMenu> queryRelateMenus(String roleId, String appId) {
        MPJLambdaWrapper wrapper = MPJWrappers.lambdaJoin();
        wrapper.leftJoin(SysRoleMenu.class, SysRoleMenu::getMenuid, SysMenu::getId);
        wrapper.eq(SysRoleMenu::getRoleid, (Object)roleId);
        wrapper.eq(SysMenu::getSystemId, (Object)appId);
        List sysMenus = this.sysMenuMapper.selectJoinList(SysMenu.class, (MPJBaseJoin)wrapper);
        if (sysMenus.size() == 0) {
            return sysMenus;
        }
        wrapper.clear();
        wrapper.in(SysMenu::getPid, (Collection)sysMenus.stream().map(f -> f.getId()).collect(Collectors.toList()));
        List pIds = this.sysMenuMapper.selectList((Wrapper)wrapper).stream().map(f -> f.getPid()).collect(Collectors.toList());
        sysMenus.removeIf(f -> pIds.contains(f.getId()));
        return sysMenus;
    }

    @Override
    public void saveRoleMenus(String roleId, String appId, List<String> menuIds) {
        List systemMenuIds = this.sysMenuMapper.selectList((Wrapper)Wrappers.lambdaQuery(SysMenu.class).eq(SysMenu::getSystemId, (Object)appId)).stream().map(f -> f.getId()).collect(Collectors.toList());
        if (systemMenuIds.size() > 0) {
            this.remove((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(SysRoleMenu.class).eq(SysRoleMenu::getRoleid, (Object)roleId)).in(SysRoleMenu::getMenuid, systemMenuIds));
        }
        if (menuIds.size() > 0) {
            ArrayList<SysRoleMenu> roleMenus = new ArrayList<SysRoleMenu>();
            for (String menuId : menuIds) {
                SysRoleMenu roleMenu = new SysRoleMenu();
                roleMenu.setMenuid(menuId);
                roleMenu.setRoleid(roleId);
                roleMenus.add(roleMenu);
            }
            this.saveBatch(roleMenus);
        }
    }

    @Override
    public void removeRelateMenus(String roleId, String appId) {
        MPJLambdaWrapper joinQueryWrapper = JoinWrappers.lambda();
        joinQueryWrapper.leftJoin(SysMenu.class, SysMenu::getId, SysRoleMenu::getMenuid);
        joinQueryWrapper.eq(SysMenu::getSystemId, (Object)appId);
        joinQueryWrapper.eq(SysRoleMenu::getRoleid, (Object)roleId);
        List roleMenus = ((SysRoleMenuMapper)this.baseMapper).selectJoinList(SysRoleMenu.class, (MPJBaseJoin)joinQueryWrapper);
        if (roleMenus.size() > 0) {
            List roleMenuIds = roleMenus.stream().map(i -> i.getId()).collect(Collectors.toList());
            this.removeByIds(roleMenuIds);
        }
        roleMenus.forEach(f -> this.sysRoleSubfunctionService.saveRoleSubFunctions(f.getRoleid(), f.getMenuid(), null));
    }
}

