/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.support.BaseTreeUtil;
import com.geoway.jckj.base.support.MybatisIdGenerator;
import com.geoway.jckj.base.support.StringUtils;
import com.geoway.jckj.base.support.query.MyBatisQueryMapperUtils;
import com.geoway.jckj.base.support.spring.SpringUtils;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysSubFunction;
import com.geoway.jckj.biz.entity.SysTenantSubFunction;
import com.geoway.jckj.biz.mapper.SysSubFunctionMapper;
import com.geoway.jckj.biz.service.sys.SysMenuService;
import com.geoway.jckj.biz.service.sys.SysSubFunctionService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysSubFunctionServiceImpl
extends MPJBaseServiceImpl<SysSubFunctionMapper, SysSubFunction>
implements SysSubFunctionService {
    final String rootPid = "0";
    private final TreeNodeConfig treeNodeConfig = new TreeNodeConfig().setParentIdKey("pid").setIdKey("id");
    @Autowired
    MybatisIdGenerator mybatisIdGenerator;

    private void getAllSysSubFunctions(List<SysSubFunction> sysSubFunctions, List<SysSubFunction> result) {
        for (SysSubFunction sysSubFunction : sysSubFunctions) {
            if (StrUtil.isBlank((CharSequence)sysSubFunction.getPid())) {
                sysSubFunction.setPid("0");
            }
            result.add(sysSubFunction);
            sysSubFunction.getChildren().forEach(child -> {
                child.setId(this.mybatisIdGenerator.nextUUID(child));
                child.setPid(sysSubFunction.getId());
            });
            this.getAllSysSubFunctions(sysSubFunction.getChildren(), result);
        }
    }

    @Override
    public void batchSave(String systemId, String menuId, String pid, List<SysSubFunction> srcSubFunctions) {
        if (srcSubFunctions.size() == 0) {
            return;
        }
        srcSubFunctions.forEach(f -> {
            if (StrUtil.isBlank((CharSequence)pid)) {
                f.setPid("0");
            } else {
                f.setPid(pid);
            }
        });
        List<SysSubFunction> tarSubFunctions = this.getChildren(menuId, pid);
        ArrayList<SysSubFunction> insertFunctions = new ArrayList<SysSubFunction>();
        this.compare(tarSubFunctions, srcSubFunctions, insertFunctions);
        insertFunctions.stream().forEach(f -> f.setMenuId(menuId));
        insertFunctions.stream().forEach(f -> f.setSystemId(systemId));
        this.saveBatch(insertFunctions);
    }

    private void compare(List<SysSubFunction> tarSubFunctions, List<SysSubFunction> srcSubFunctions, List<SysSubFunction> result) {
        if (srcSubFunctions == null || srcSubFunctions.size() == 0) {
            return;
        }
        List<SysSubFunction> inserts = null;
        inserts = tarSubFunctions == null || tarSubFunctions.size() == 0 ? srcSubFunctions : srcSubFunctions.stream().filter(src -> !tarSubFunctions.stream().anyMatch(tar -> tar.getKey().equalsIgnoreCase(src.getKey()) || tar.getName().equalsIgnoreCase(src.getName()))).collect(Collectors.toList());
        inserts.stream().forEach(f -> f.setId(this.mybatisIdGenerator.nextUUID(f)));
        this.getAllSysSubFunctions(inserts, result);
        for (SysSubFunction srcSubFunction : srcSubFunctions) {
            SysSubFunction tarSubFunction = tarSubFunctions.stream().filter(tar -> srcSubFunctions.stream().anyMatch(src -> tar.getKey().equalsIgnoreCase(src.getKey()) || tar.getName().equalsIgnoreCase(src.getName()))).findAny().orElse(null);
            if (tarSubFunction == null) continue;
            this.compare(tarSubFunction.getChildren(), srcSubFunction.getChildren(), result);
        }
    }

    private List<SysSubFunction> getChildren(String menuId, String id) {
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysSubFunction::getMenuId, (Object)menuId);
        List list = this.list((Wrapper)wrapper);
        List trees = BaseTreeUtil.listToTree((List)list, (TreeNodeConfig)this.treeNodeConfig, (String)"0");
        return this.getChildren(trees, id);
    }

    private List<SysSubFunction> getChildren(List<SysSubFunction> trees, String id) {
        Iterator<SysSubFunction> iterator = trees.iterator();
        if (iterator.hasNext()) {
            SysSubFunction sysSubFunction = iterator.next();
            if (sysSubFunction.getId().equalsIgnoreCase(id)) {
                return sysSubFunction.getChildren();
            }
            return this.getChildren(sysSubFunction.getChildren(), id);
        }
        return new ArrayList<SysSubFunction>();
    }

    @Override
    public void saveOrUp(SysSubFunction subFunction) throws Exception {
        int iCount;
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysSubFunction::getName, (Object)subFunction.getName());
        wrapper.eq(SysSubFunction::getSystemId, (Object)subFunction.getSystemId());
        wrapper.eq(SysSubFunction::getMenuId, (Object)subFunction.getMenuId());
        if (StrUtil.isNotBlank((CharSequence)subFunction.getPid())) {
            wrapper.eq(SysSubFunction::getPid, (Object)subFunction.getPid());
        }
        if (StrUtil.isNotBlank((CharSequence)subFunction.getId())) {
            wrapper.ne(SysSubFunction::getId, (Object)subFunction.getId());
        }
        if ((iCount = this.count((Wrapper)wrapper)) > 0) {
            throw new Exception("\u529f\u80fd\u70b9: " + subFunction.getName() + "  \u5df2\u5b58\u5728\uff01");
        }
        this.saveOrUpdate(subFunction);
    }

    @Override
    public List<SysSubFunction> queryTree(List<SysSubFunction> functions) {
        ArrayList<SysSubFunction> result = new ArrayList<SysSubFunction>();
        result.addAll(functions);
        if (result.size() > 0) {
            List<SysSubFunction> parentList = this.queryParentList(result);
            result.addAll(parentList);
        }
        List trees = BaseTreeUtil.listToTree(result, (TreeNodeConfig)this.treeNodeConfig, (String)"0");
        return trees;
    }

    @Override
    public List<SysSubFunction> queryTree(String filterParam) throws Exception {
        MyBatisQueryMapperUtils qmu = new MyBatisQueryMapperUtils();
        QueryWrapper queryWrapper = qmu.queryMapper(filterParam, SysSubFunction.class);
        List list = this.list((Wrapper)queryWrapper);
        if (StrUtil.isNotBlank((CharSequence)filterParam) && list.size() > 0) {
            List<SysSubFunction> parentList = this.queryParentList(list);
            list.addAll(parentList);
        }
        List trees = BaseTreeUtil.listToTree((List)list, (TreeNodeConfig)this.treeNodeConfig, (String)"0");
        return trees;
    }

    private List<SysSubFunction> queryParentList(List<SysSubFunction> menus) {
        ArrayList<SysSubFunction> parentMenus = new ArrayList<SysSubFunction>();
        ArrayList<String> allPids = new ArrayList<String>();
        this.queryAllPidsNoContains(menus, allPids);
        List allIds = menus.stream().map(menuItem -> menuItem.getId()).collect(Collectors.toList());
        List filterPids = allPids.stream().filter(pid -> !allIds.contains(pid)).collect(Collectors.toList());
        if (filterPids.size() > 0) {
            List pMenus = this.listByIds(filterPids);
            parentMenus.addAll(pMenus);
        }
        return parentMenus;
    }

    private void queryAllPidsNoContains(List<SysSubFunction> menus, List<String> pids) {
        ArrayList<String> newPids = new ArrayList<String>();
        for (SysSubFunction menu : menus) {
            boolean exists = StrUtil.isNotBlank((CharSequence)menu.getPid()) && !menu.getPid().equals("0");
            if (!exists || pids.contains(menu.getPid())) continue;
            newPids.add(menu.getPid());
        }
        pids.addAll(newPids);
        if (newPids.size() > 0) {
            List pMenus = this.listByIds(newPids);
            this.queryAllPidsNoContains(pMenus, pids);
        }
    }

    @Override
    public List<SysSubFunction> queryByMenuId(String menuId) {
        List list;
        SysMenuService sysMenuService = (SysMenuService)SpringUtils.getBean(SysMenuService.class);
        SysMenu registerMenu = sysMenuService.queryRegisterMenu(menuId);
        if (registerMenu == null) {
            return new ArrayList<SysSubFunction>();
        }
        String curTenantId = TenantUtil.getTenantId();
        MPJLambdaWrapper wrapper = MPJWrappers.lambdaJoin();
        wrapper.eq(SysSubFunction::getMenuId, (Object)registerMenu.getId());
        if (StringUtils.isNotEmpty((String)curTenantId) && !registerMenu.getTenantid().equals(curTenantId)) {
            wrapper.leftJoin(SysTenantSubFunction.class, SysTenantSubFunction::getSubfunctionid, SysSubFunction::getId);
            wrapper.eq(SysTenantSubFunction::getMenuid, (Object)menuId);
            wrapper.eq(SysTenantSubFunction::getTenantid, (Object)curTenantId);
            wrapper.distinct();
        }
        if ((list = this.list((Wrapper)wrapper)).size() > 0) {
            List<SysSubFunction> parentList = this.queryParentList(list);
            list.addAll(parentList);
        }
        List trees = BaseTreeUtil.listToTree((List)list, (TreeNodeConfig)this.treeNodeConfig, (String)"0");
        return trees;
    }

    @Override
    public void batchDelete(String ids) throws Exception {
        List<String> idList = Arrays.asList(ids.split(","));
        for (String id : idList) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysSubFunction::getPid, (Object)id);
            int iCount = this.count((Wrapper)wrapper);
            if (iCount <= 0) continue;
            SysSubFunction sysSubFunction = (SysSubFunction)this.getById((Serializable)((Object)id));
            throw new Exception("\u529f\u80fd\u70b9: " + sysSubFunction.getName() + "  \u5b58\u5728\u5b50\u529f\u80fd\u70b9\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        this.removeByIds(idList);
    }
}

