/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.geoway.jckj.biz.dto.UserOnlineStatDTO;
import com.geoway.jckj.biz.entity.SysUser;
import com.geoway.jckj.biz.service.dev.unity.IUnityLoginService;
import com.geoway.jckj.biz.service.dev.unity.IUnityUserService;
import com.geoway.jckj.biz.service.sys.SysUserOnlineService;
import com.geoway.jckj.biz.util.TenantUtil;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CommonLoginUserUtil;
import com.geoway.sso.server.session.AccessTokenManager;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysUserOnlineServiceImpl
implements SysUserOnlineService {
    private static final Logger log = LoggerFactory.getLogger(SysUserOnlineServiceImpl.class);
    @Autowired
    private IUnityUserService unityUserService;
    @Autowired
    private IUnityLoginService loginService;
    @Autowired
    private AccessTokenManager accessTokenManager;

    @Override
    public UserOnlineStatDTO getStatInfo() {
        UserOnlineStatDTO result = new UserOnlineStatDTO();
        int offline = 0;
        int all = this.unityUserService.queryCount("");
        List users = this.accessTokenManager.getOnlineUsers();
        if (!TenantUtil.isSuperTenant() && users.size() > 0) {
            String filterParam = "Q_id_N_IN=" + StrUtil.join((CharSequence)",", (Iterable)users.stream().map(f -> f.getId()).collect(Collectors.toList())) + ";";
            List<SysUser> sysUsers = this.unityUserService.queryList(filterParam, false);
            users = users.stream().filter(f -> sysUsers.stream().anyMatch(g -> g.getId().equals(f.getId()))).collect(Collectors.toList());
        }
        int online = users.size();
        offline = all - online;
        result.setAll(all);
        result.setOffline(offline);
        result.setOnline(online);
        SsoUser sysUser = CommonLoginUserUtil.getUser();
        if (RoleLevelEnum.getEnumByValue((int)sysUser.getUserCatalog()).getLevel() <= RoleLevelEnum.tenantAdmin.getLevel()) {
            result.setUsers(users);
        }
        return result;
    }

    @Override
    public boolean isOnline(String userName, String password) {
        try {
            Result<SsoUser> loginResult = this.loginService.login(userName, password);
            if (loginResult == null) {
                return false;
            }
            if (!loginResult.isSuccess() || loginResult.getData() == null) {
                return false;
            }
            List onlineUsers = this.accessTokenManager.getOnlineUsers(((SsoUser)loginResult.getData()).getUserid());
            return CollectionUtil.isNotEmpty((Collection)onlineUsers);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }
}

