/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.geoway.jckj.base.exception.ServiceException;
import com.geoway.jckj.biz.entity.SysBizManageRole;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.mapper.SysBizManageRoleMapper;
import com.geoway.jckj.biz.service.sys.SysBizManageRoleService;
import com.geoway.jckj.biz.service.sys.SysRoleService;
import com.github.yulichang.base.MPJBaseServiceImpl;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SysBizManageRoleServiceImpl
extends MPJBaseServiceImpl<SysBizManageRoleMapper, SysBizManageRole>
implements SysBizManageRoleService {
    @Autowired
    private SysRoleService sysRoleService;

    @Override
    public List<SysRole> queryBindRoles(String bizManageId) {
        try {
            MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
            queryWrapper.leftJoin(SysBizManageRole.class, SysBizManageRole::getRoleId, SysRole::getId);
            queryWrapper.eq(SysBizManageRole::getBizManageId, (Object)bizManageId);
            return this.sysRoleService.list((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    @Override
    public void bindRoles(String bizManageId, String roleIds) {
        LambdaQueryWrapper menuWrapper = Wrappers.lambdaQuery();
        menuWrapper.eq(SysBizManageRole::getBizManageId, (Object)bizManageId);
        this.remove((Wrapper)menuWrapper);
        if (StrUtil.isBlank((CharSequence)roleIds)) {
            return;
        }
        List<String> idList = Arrays.asList(roleIds.split(","));
        ArrayList<SysBizManageRole> bizManageRoles = new ArrayList<SysBizManageRole>();
        for (String id : idList) {
            SysBizManageRole bizManageRole = new SysBizManageRole();
            bizManageRole.setRoleId(id);
            bizManageRole.setBizManageId(bizManageId);
            bizManageRoles.add(bizManageRole);
        }
        this.saveBatch(bizManageRoles);
    }
}

