/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.jckj.biz.service.sys.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.jckj.biz.dto.RoleSystemsDTO;
import com.geoway.jckj.biz.entity.SaasEntity;
import com.geoway.jckj.biz.entity.SysMenu;
import com.geoway.jckj.biz.entity.SysRole;
import com.geoway.jckj.biz.entity.SysRoleMenu;
import com.geoway.jckj.biz.entity.SysRoleSubfunction;
import com.geoway.jckj.biz.entity.SysRoleSystem;
import com.geoway.jckj.biz.entity.SysSystem;
import com.geoway.jckj.biz.mapper.SysRoleMapper;
import com.geoway.jckj.biz.mapper.SysRoleMenuMapper;
import com.geoway.jckj.biz.mapper.SysRoleSubfunctionMapper;
import com.geoway.jckj.biz.mapper.SysRoleSystemMapper;
import com.geoway.jckj.biz.mapper.SysSystemMapper;
import com.geoway.jckj.biz.service.sys.SysRoleSystemService;
import com.geoway.jckj.biz.util.SaasEntityUtil;
import com.geoway.jckj.biz.util.SysSystemUtil;
import com.geoway.jckj.biz.util.TenantUtil;
import com.github.yulichang.interfaces.MPJBaseJoin;
import com.github.yulichang.toolkit.JoinWrappers;
import com.github.yulichang.toolkit.MPJWrappers;
import com.github.yulichang.wrapper.MPJLambdaWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class SysRoleSystemServiceImpl
extends ServiceImpl<SysRoleSystemMapper, SysRoleSystem>
implements SysRoleSystemService {
    @Autowired
    SysSystemMapper sysSystemMapper;
    @Autowired
    SysRoleMapper sysRoleMapper;
    @Autowired
    SysRoleMenuMapper sysRoleMenuMapper;
    @Autowired
    SysRoleSubfunctionMapper sysSubFunctionMapper;

    @Override
    public void saveRoleSystems(String roleId, List<String> systemIds, boolean isClear) {
        if (systemIds == null || systemIds.size() == 0) {
            return;
        }
        if (isClear) {
            LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
            wrapper.eq(SysRoleSystem::getRoleid, (Object)roleId);
            this.remove((Wrapper)wrapper);
        }
        ArrayList roleSystems = new ArrayList();
        systemIds.forEach(systemId -> {
            SysRoleSystem roleApp = new SysRoleSystem();
            roleApp.setSystemid((String)systemId);
            roleApp.setRoleid(roleId);
            roleSystems.add(roleApp);
        });
        this.saveBatch(roleSystems);
    }

    @Override
    public List<SysSystem> queryRoleSystems(String roleId) {
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysRoleSystem.class, SysRoleSystem::getSystemid, SysSystem::getId);
        queryWrapper.eq(SysRoleSystem::getRoleid, (Object)roleId);
        queryWrapper.selectAll(SysSystem.class);
        List sysSystems = this.sysSystemMapper.selectJoinList(SysSystem.class, (MPJBaseJoin)queryWrapper);
        SysSystemUtil.wrapper(sysSystems);
        return sysSystems;
    }

    @Override
    public RoleSystemsDTO queryRoleSystemDTOs(String roleId) {
        List<SysSystem> systems = this.queryRoleSystems(roleId);
        RoleSystemsDTO roleSystemsDTO = new RoleSystemsDTO();
        roleSystemsDTO.setRoleId(roleId);
        roleSystemsDTO.setSystems(systems);
        return roleSystemsDTO;
    }

    @Override
    public void removeRoleSystem(String roleId, List<String> systemIds) {
        for (String systemId : systemIds) {
            this.removeRoleSystem(roleId, systemId);
        }
    }

    @Override
    public void removeRoleSystem(String roleId, String systemId) {
        MPJLambdaWrapper joinQueryWrapper = JoinWrappers.lambda();
        joinQueryWrapper.leftJoin(SysMenu.class, SysMenu::getId, SysRoleMenu::getMenuid);
        joinQueryWrapper.eq(SysMenu::getSystemId, (Object)systemId);
        joinQueryWrapper.eq(SysRoleMenu::getRoleid, (Object)roleId);
        List roleMenus = this.sysRoleMenuMapper.selectJoinList(SysRoleMenu.class, (MPJBaseJoin)joinQueryWrapper);
        if (roleMenus.size() > 0) {
            List roleMenuIds = roleMenus.stream().map(i -> i.getId()).collect(Collectors.toList());
            this.sysRoleMenuMapper.deleteBatchIds(roleMenuIds);
        }
        MPJLambdaWrapper subFunctionQueryWrapper = JoinWrappers.lambda();
        subFunctionQueryWrapper.leftJoin(SysMenu.class, SysMenu::getId, SysRoleSubfunction::getMenuId);
        subFunctionQueryWrapper.eq(SysMenu::getSystemId, (Object)systemId);
        subFunctionQueryWrapper.eq(SysRoleSubfunction::getRoleid, (Object)roleId);
        List roleSubfunctions = this.sysSubFunctionMapper.selectJoinList(SysRoleSubfunction.class, (MPJBaseJoin)subFunctionQueryWrapper);
        if (roleSubfunctions.size() > 0) {
            List roleSubfunctionIds = roleSubfunctions.stream().map(i -> i.getId()).collect(Collectors.toList());
            this.sysSubFunctionMapper.deleteBatchIds(roleSubfunctionIds);
        }
        LambdaQueryWrapper queryWrapper = Wrappers.lambdaQuery();
        queryWrapper.eq(SysRoleSystem::getRoleid, (Object)roleId);
        queryWrapper.eq(SysRoleSystem::getSystemid, (Object)systemId);
        this.remove((Wrapper)queryWrapper);
    }

    @Override
    public void saveSystemRoles(String systemId, String roleIds) {
        List<SysRole> sysRoles = this.systemRelateRoles(systemId);
        LambdaQueryWrapper wrapper = Wrappers.lambdaQuery();
        wrapper.eq(SysRoleSystem::getSystemid, (Object)systemId);
        if (sysRoles.size() > 0) {
            wrapper.in(SysRoleSystem::getRoleid, (Collection)sysRoles.stream().collect(Collectors.toList()));
        }
        this.remove((Wrapper)wrapper);
        if (StrUtil.isNotBlank((CharSequence)roleIds)) {
            ArrayList roleApps = new ArrayList();
            Arrays.asList(roleIds.split(",")).forEach(roleId -> {
                SysRoleSystem roleApp = new SysRoleSystem();
                roleApp.setSystemid(systemId);
                roleApp.setRoleid((String)roleId);
                roleApps.add(roleApp);
            });
            this.saveBatch(roleApps);
        }
    }

    @Override
    public List<SysRole> systemRelateRoles(String systemId) {
        MPJLambdaWrapper queryWrapper = MPJWrappers.lambdaJoin();
        queryWrapper.leftJoin(SysRoleSystem.class, SysRoleSystem::getRoleid, SysRole::getId);
        queryWrapper.eq(SysRoleSystem::getSystemid, (Object)systemId);
        queryWrapper.eq(SaasEntity::getTenantid, (Object)TenantUtil.getTenantId());
        List roles = this.sysRoleMapper.selectJoinList(SysRole.class, (MPJBaseJoin)queryWrapper);
        SaasEntityUtil.wrapper(roles);
        return roles;
    }
}

