/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.api.controller;

import com.geoway.sso.client.client.LoginClient;
import com.geoway.sso.client.client.SsoClient;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcAccessToken;
import com.geoway.sso.client.rpc.RpcImgCaptchaDTO;
import com.geoway.sso.client.rpc.RpcSmsCaptchaDTO;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jckj/client/login"})
public class ClientLoginController {
    @Autowired
    private SsoClient ssoClient;
    @Autowired
    private LoginClient loginClient;

    @RequestMapping(value={"/captchaIMG"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcImgCaptchaDTO> captchaIMG(HttpServletRequest request) {
        return Result.createSuccess((Object)this.loginClient.getImgCaptcha());
    }

    @RequestMapping(value={"/loginByPassword"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcAccessToken> login(HttpServletRequest request, @RequestParam(value="username") String username, @RequestParam(value="password") String password, @RequestParam(value="code") String code, @RequestParam(value="uid") String uid) {
        return Result.createSuccess((Object)this.ssoClient.getAccessToken(username, password, uid, code));
    }

    @RequestMapping(value={"/getSmsCode"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcSmsCaptchaDTO> getSmsCode(HttpServletRequest request) {
        return Result.createSuccess((Object)this.loginClient.getSmsCode());
    }

    @RequestMapping(value={"/loginBySms"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcAccessToken> loginBySms(HttpServletRequest request, @RequestParam(value="phoneNumber") String phoneNumber, @RequestParam(value="code") String code, @RequestParam(value="uid") String uid) {
        return Result.createSuccess((Object)this.ssoClient.getAccessTokenBySms(phoneNumber, uid, code));
    }

    @RequestMapping(value={"/loginByCa"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcAccessToken> loginByCa(HttpServletRequest request, @RequestParam(value="usercert") String usercert, @RequestParam(value="oauthname") String oauthname) {
        return Result.createSuccess((Object)this.ssoClient.getAccessTokenByCa(usercert, oauthname));
    }

    @RequestMapping(value={"/loginByOne"}, method={RequestMethod.GET, RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    @ResponseBody
    public Result<RpcAccessToken> loginByOne(HttpServletRequest request, @RequestParam(value="processId") String processId, @RequestParam(value="token") String token, @RequestParam(value="authCode", required=false) String authCode) {
        return Result.createSuccess((Object)this.ssoClient.getAccessTokenByOne(processId, token, authCode));
    }
}

