/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.api.controller;

import com.geoway.sso.client.annotation.RequireAuth;
import com.geoway.sso.client.client.UserClient;
import com.geoway.sso.client.enums.RoleLevelEnum;
import com.geoway.sso.client.rpc.Result;
import com.geoway.sso.client.rpc.RpcSysMenu;
import com.geoway.sso.client.rpc.RpcSysUser;
import com.geoway.sso.client.rpc.RpcUserSystem;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jckj/client/user"})
public class ClientUserController {
    @Autowired
    private UserClient userClient;

    @RequestMapping(value={"/validSecure"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public Result<Boolean> validSecure(HttpServletRequest request, String systemKey) throws Exception {
        Boolean validSecure = this.userClient.validSecure();
        return Result.createSuccess((Object)validSecure);
    }

    @RequireAuth(roleLevel=RoleLevelEnum.commonUser)
    @RequestMapping(value={"/changePwd"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Result<Boolean> changePwd(HttpServletRequest request, @RequestParam(value="oldPwd") String oldPwd, @RequestParam(value="newPwd") String newPwd) throws Exception {
        return Result.createSuccess((Object)this.userClient.modifyCurrentUserPassword(oldPwd, newPwd));
    }

    @RequireAuth(roleLevel=RoleLevelEnum.commonUser)
    @RequestMapping(value={"/modifyPassword"}, method={RequestMethod.POST}, produces={"application/json;charset=UTF-8"})
    public Result<Boolean> modifyPassword(@RequestParam String phoneNum, @RequestParam String verifyCode, @RequestParam String verifyCodeUid, @RequestParam String password, String userSys) throws Exception {
        return Result.createSuccess((Object)this.userClient.modifyPassword(phoneNum, verifyCode, verifyCodeUid, password));
    }

    @RequireAuth(roleLevel=RoleLevelEnum.commonUser)
    @RequestMapping(value={"/getCurrentUserInfo"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public Result<RpcSysUser> getCurrentUserInfo(HttpServletRequest request) throws Exception {
        return Result.createSuccess((Object)this.userClient.getCurrentUserInfo());
    }

    @RequireAuth(roleLevel=RoleLevelEnum.None)
    @RequestMapping(value={"/getUserSystems"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public Result<List<RpcUserSystem>> getUserSystems() throws Exception {
        return Result.createSuccess((Object)this.userClient.getUserSystems());
    }

    @RequireAuth(roleLevel=RoleLevelEnum.None)
    @RequestMapping(value={"/getUserSystemMenus"}, method={RequestMethod.GET}, produces={"application/json;charset=UTF-8"})
    public Result<List<RpcSysMenu>> getUserSystemMenus(String systemId) throws Exception {
        return Result.createSuccess((Object)this.userClient.getUserSystemMenus(systemId));
    }
}

