/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.local;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.server.common.ExpirationPolicy;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="local")
public class LocalTicketGrantingTicketManager
implements TicketGrantingTicketManager,
ExpirationPolicy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${sso.timeout}")
    private int timeout;
    @Value(value="${sso.app-token-timeout:604800}")
    private int appTokenTimeout;
    private Map<String, DummyTgt> tgtMap = new ConcurrentHashMap<String, DummyTgt>();

    @Override
    public void create(String tgt, SsoUser user) {
        this.tgtMap.put(tgt, new DummyTgt(user, System.currentTimeMillis() + (long)(this.getExpiresIn() * 1000)));
        this.logger.info("\u767b\u5f55\u51ed\u8bc1\u751f\u6210\u6210\u529f, tgt:{}", (Object)tgt);
    }

    @Override
    public SsoUser getAndRefresh(String tgt) {
        DummyTgt dummyTgt = this.tgtMap.get(tgt);
        long currentTime = System.currentTimeMillis();
        if (dummyTgt == null || currentTime > dummyTgt.expired) {
            return null;
        }
        dummyTgt.expired = currentTime + (long)(this.getExpiresIn() * 1000);
        return dummyTgt.user;
    }

    @Override
    public void set(String tgt, SsoUser user) {
        DummyTgt dummyTgt = this.tgtMap.get(tgt);
        if (dummyTgt == null) {
            return;
        }
        dummyTgt.user = user;
    }

    @Override
    public void remove(String tgt) {
        this.tgtMap.remove(tgt);
        this.logger.debug("\u767b\u5f55\u51ed\u8bc1\u5220\u9664\u6210\u529f, tgt:{}", (Object)tgt);
    }

    @Override
    @Scheduled(cron="0 */5 * * * ?")
    public void verifyExpired() {
        this.tgtMap.forEach((tgt, dummyTgt) -> {
            if (System.currentTimeMillis() > ((DummyTgt)dummyTgt).expired) {
                this.tgtMap.remove(tgt);
                this.logger.debug("\u767b\u5f55\u51ed\u8bc1\u5df2\u5931\u6548, tgt:{}", tgt);
            }
        });
    }

    @Override
    public int getExpiresIn() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        if (request != null && ObjectUtil.equal((Object)request.getParameter("appFlag"), (Object)"true")) {
            return this.appTokenTimeout;
        }
        return this.timeout;
    }

    private class DummyTgt {
        private SsoUser user;
        private long expired;

        public DummyTgt(SsoUser user, long expired) {
            this.user = user;
            this.expired = expired;
        }
    }
}

