package com.geoway.sso.server.session.redis;

import cn.hutool.core.util.BooleanUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.client.constant.Oauth2Constant;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.server.common.RefreshTokenContent;
import com.geoway.sso.server.config.PropertyConfig;
import com.geoway.sso.server.constant.AppConstant;
import com.geoway.sso.server.session.RefreshTokenManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.concurrent.TimeUnit;

/**
 * @author ALMJ
 * @desc 分布式刷新凭证管理
 */
@Component
@ConditionalOnProperty(name = "sso.session.manager", havingValue = "redis")
public class RedisRefreshTokenManager implements RefreshTokenManager {


    @Autowired
    private PropertyConfig propertyConfig;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void create(String refreshToken, RefreshTokenContent refreshTokenContent) {
        redisTemplate.opsForValue().set(AppConstant.REDIS_TOKEN_PREFIX + refreshToken, JSON.toJSONString(refreshTokenContent), getExpiresIn(),
                TimeUnit.SECONDS);
    }

    @Override
    public RefreshTokenContent validate(String refreshToken) {
        String rtc = redisTemplate.opsForValue().get(AppConstant.REDIS_TOKEN_PREFIX + refreshToken);
        //if (!StringUtils.isEmpty(rtc)) {
        //redisTemplate.delete(AppConstant.REDIS_TOKEN_PREFIX + refreshToken);
        //}
        return JSONObject.parseObject(rtc, RefreshTokenContent.class);
    }

    /*
     * refreshToken时效和登录session时效一致
     */
    @Override
    public int getExpiresIn() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        if (request != null) {
            if (ObjectUtil.equal(request.getParameter(Oauth2Constant.APP_FLAG), "true")) {
                return propertyConfig.getSsoAppTokenTimeout();
            }
        }
        return propertyConfig.getSsoTimeout();
    }
}
