/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session;

import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.CookieUtils;
import com.geoway.sso.server.session.AccessTokenManager;
import com.geoway.sso.server.session.TicketGrantingTicketManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Component
public class SessionManager {
    @Autowired
    private AccessTokenManager accessTokenManager;
    @Autowired
    private TicketGrantingTicketManager ticketGrantingTicketManager;

    public String setUser(SsoUser user, HttpServletRequest request, HttpServletResponse response) {
        String tgt = this.getCookieTgt(request);
        if (StringUtils.isEmpty((Object)tgt)) {
            tgt = this.ticketGrantingTicketManager.generate(user);
            CookieUtils.addCookie((String)"TGC", (String)tgt, (String)"/", (HttpServletRequest)request, (HttpServletResponse)response);
        } else if (this.ticketGrantingTicketManager.getAndRefresh(tgt) == null) {
            this.ticketGrantingTicketManager.create(tgt, user);
        } else {
            this.ticketGrantingTicketManager.set(tgt, user);
        }
        return tgt;
    }

    public String setUser(SsoUser user, String path, HttpServletRequest request, HttpServletResponse response) {
        String tgt = this.getCookieTgt(request);
        if (ObjectUtils.isEmpty((Object)tgt)) {
            tgt = this.ticketGrantingTicketManager.generate(user);
            CookieUtils.addCookie((String)"TGC", (String)tgt, (String)path, (HttpServletRequest)request, (HttpServletResponse)response);
            CookieUtils.addCookie((String)"loginName", (String)user.getLoginName(), (String)path, (HttpServletRequest)request, (HttpServletResponse)response);
        } else if (this.ticketGrantingTicketManager.getAndRefresh(tgt) == null) {
            this.ticketGrantingTicketManager.create(tgt, user);
        } else {
            this.ticketGrantingTicketManager.set(tgt, user);
        }
        return tgt;
    }

    public SsoUser getUser(HttpServletRequest request) {
        String tgt = this.getCookieTgt(request);
        if (ObjectUtils.isEmpty((Object)tgt)) {
            return null;
        }
        return this.ticketGrantingTicketManager.getAndRefresh(tgt);
    }

    public void invalidate(HttpServletRequest request, HttpServletResponse response) {
        String tgt = this.getCookieTgt(request);
        if (StringUtils.isEmpty((Object)tgt)) {
            return;
        }
        this.ticketGrantingTicketManager.remove(tgt);
        CookieUtils.removeCookie((String)"TGC", (String)"/", (HttpServletResponse)response);
        this.accessTokenManager.remove(tgt);
    }

    public String getTgt(HttpServletRequest request) {
        String tgt = this.getCookieTgt(request);
        if (StringUtils.isEmpty((Object)tgt) || this.ticketGrantingTicketManager.getAndRefresh(tgt) == null) {
            return null;
        }
        return tgt;
    }

    private String getCookieTgt(HttpServletRequest request) {
        return CookieUtils.getCookie((HttpServletRequest)request, (String)"TGC");
    }
}

