/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.local;

import cn.hutool.core.util.ObjectUtil;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.common.CodeContent;
import com.geoway.sso.server.common.ExpirationPolicy;
import com.geoway.sso.server.session.AccessTokenManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="local")
public class LocalAccessTokenManager
implements AccessTokenManager,
ExpirationPolicy {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${sso.timeout}")
    private int timeout;
    @Value(value="${sso.app-token-timeout:604800}")
    private int appTokenTimeout;
    private Map<String, DummyAccessToken> accessTokenMap = new ConcurrentHashMap<String, DummyAccessToken>();
    private Map<String, Set<String>> tgtMap = new ConcurrentHashMap<String, Set<String>>();

    @Override
    public void create(String accessToken, AccessTokenContent accessTokenContent) {
        DummyAccessToken dat = new DummyAccessToken(accessTokenContent, System.currentTimeMillis() + (long)this.getExpiresIn() * 1000L);
        this.accessTokenMap.put(accessToken, dat);
        this.tgtMap.computeIfAbsent(accessTokenContent.getCodeContent().getTgt(), a -> new HashSet()).add(accessToken);
        this.logger.info("\u8c03\u7528\u51ed\u8bc1\u751f\u6210\u6210\u529f, accessToken:{}", (Object)accessToken);
    }

    @Override
    public AccessTokenContent get(String accessToken) {
        DummyAccessToken dummyAt = this.accessTokenMap.get(accessToken);
        if (dummyAt == null || System.currentTimeMillis() > dummyAt.expired) {
            return null;
        }
        return dummyAt.accessTokenContent;
    }

    @Override
    public boolean refresh(String accessToken) {
        DummyAccessToken dummyAt = this.accessTokenMap.get(accessToken);
        if (dummyAt == null || System.currentTimeMillis() > dummyAt.expired) {
            return false;
        }
        dummyAt.expired = System.currentTimeMillis() + (long)this.getExpiresIn() * 1000L;
        return true;
    }

    @Override
    public void remove(String tgt) {
        Set<String> accessTokenSet = this.tgtMap.remove(tgt);
        if (CollectionUtils.isEmpty(accessTokenSet)) {
            return;
        }
        accessTokenSet.forEach(accessToken -> {
            DummyAccessToken dummyAt = this.accessTokenMap.get(accessToken);
            if (dummyAt == null || System.currentTimeMillis() > dummyAt.expired) {
                return;
            }
            CodeContent codeContent = dummyAt.accessTokenContent.getCodeContent();
            if (codeContent == null || !codeContent.isSendLogoutRequest()) {
                return;
            }
            this.logger.debug("\u53d1\u8d77\u5ba2\u6237\u7aef\u767b\u51fa\u8bf7\u6c42, accessToken:{}, url:{}", accessToken, (Object)codeContent.getRedirectUri());
            this.sendLogoutRequest(codeContent.getRedirectUri(), (String)accessToken);
        });
    }

    @Override
    public List<SsoUser> getOnlineUsers() {
        return null;
    }

    @Override
    public List<SsoUser> getOnlineUsers(String userId) {
        return null;
    }

    @Override
    @Scheduled(cron="0 */5 * * * ?")
    public void verifyExpired() {
        this.accessTokenMap.forEach((accessToken, dummyAt) -> {
            if (System.currentTimeMillis() > ((DummyAccessToken)dummyAt).expired) {
                this.accessTokenMap.remove(accessToken);
                this.logger.debug("\u8c03\u7528\u51ed\u8bc1\u5df2\u5931\u6548, accessToken:{}", accessToken);
            }
        });
    }

    @Override
    public int getExpiresIn() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        if (request != null && ObjectUtil.equal((Object)request.getParameter("appFlag"), (Object)"true")) {
            return this.appTokenTimeout / 2;
        }
        return this.timeout / 2;
    }

    private class DummyAccessToken {
        private AccessTokenContent accessTokenContent;
        private long expired;

        public DummyAccessToken(AccessTokenContent accessTokenContent, long expired) {
            this.accessTokenContent = accessTokenContent;
            this.expired = expired;
        }
    }
}

