/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.sso.server.session.redis;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.sso.client.rpc.SsoUser;
import com.geoway.sso.client.util.HttpServletUtil;
import com.geoway.sso.server.common.AccessTokenContent;
import com.geoway.sso.server.config.PropertyConfig;
import com.geoway.sso.server.session.AccessTokenManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@ConditionalOnProperty(name={"sso.session.manager"}, havingValue="redis")
public class RedisAccessTokenManager
implements AccessTokenManager {
    @Autowired
    private PropertyConfig propertyConfig;
    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public void create(String accessToken, AccessTokenContent accessTokenContent) {
        accessTokenContent.setToken(accessToken);
        if (this.propertyConfig.getSingeUser().booleanValue()) {
            this.remove(accessTokenContent.getCodeContent().getTgt());
        }
        String tokenKey = this.getTokenKey(accessToken);
        this.redisTemplate.opsForValue().set((Object)tokenKey, (Object)JSON.toJSONString((Object)accessTokenContent), (long)this.getExpiresIn(), TimeUnit.SECONDS);
        String tgtKey = this.getTgtKey(accessTokenContent.getCodeContent().getTgt());
        this.redisTemplate.opsForSet().add((Object)tgtKey, (Object[])new String[]{accessToken});
        this.redisTemplate.expire((Object)tgtKey, (long)this.getExpiresIn(), TimeUnit.SECONDS);
        String userKey = this.getUserIdKey(accessTokenContent);
        this.redisTemplate.opsForValue().set((Object)userKey, (Object)JSON.toJSONString((Object)accessTokenContent), (long)this.getExpiresIn(), TimeUnit.SECONDS);
        String userSession = this.getUserSessionKey(accessTokenContent);
        this.redisTemplate.opsForSet().add((Object)userSession, (Object[])new String[]{accessToken});
        this.redisTemplate.expire((Object)userSession, (long)this.getExpiresIn(), TimeUnit.SECONDS);
    }

    @Override
    public AccessTokenContent get(String accessToken) {
        String atcStr = (String)this.redisTemplate.opsForValue().get((Object)this.getTokenKey(accessToken));
        if (StringUtils.isEmpty((Object)atcStr)) {
            return null;
        }
        return (AccessTokenContent)JSONObject.parseObject((String)atcStr, AccessTokenContent.class);
    }

    @Override
    public boolean refresh(String accessToken) {
        String atcStr = (String)this.redisTemplate.opsForValue().get((Object)this.getTokenKey(accessToken));
        if (StrUtil.isBlank((CharSequence)atcStr)) {
            return false;
        }
        this.redisTemplate.expire((Object)this.getTokenKey(accessToken), (long)this.getExpiresIn(), TimeUnit.SECONDS);
        AccessTokenContent accessTokenContent = (AccessTokenContent)JSONObject.parseObject((String)atcStr, AccessTokenContent.class);
        String userIdKey = this.getUserIdKey(accessTokenContent);
        String tgtKey = this.getTgtKey(accessTokenContent.getCodeContent().getTgt());
        String userSessionKey = this.getUserSessionKey(accessTokenContent);
        if (this.redisTemplate.hasKey((Object)userIdKey).booleanValue()) {
            this.redisTemplate.expire((Object)userIdKey, (long)this.getExpiresIn(), TimeUnit.SECONDS);
        }
        if (this.redisTemplate.hasKey((Object)tgtKey).booleanValue()) {
            this.redisTemplate.expire((Object)tgtKey, (long)this.getExpiresIn(), TimeUnit.SECONDS);
        }
        if (this.redisTemplate.hasKey((Object)userSessionKey).booleanValue()) {
            this.redisTemplate.expire((Object)userSessionKey, (long)this.getExpiresIn(), TimeUnit.SECONDS);
        }
        return true;
    }

    @Override
    public void remove(String tgt) {
        Set accessTokenSet = this.redisTemplate.opsForSet().members((Object)this.getTgtKey(tgt));
        if (CollectionUtils.isEmpty((Collection)accessTokenSet)) {
            return;
        }
        this.redisTemplate.delete((Object)this.getTgtKey(tgt));
        String userKey = "";
        String userSessionKey = "";
        for (String accessToken : accessTokenSet) {
            String atcStr = (String)this.redisTemplate.opsForValue().get((Object)("SSO_" + accessToken));
            this.redisTemplate.delete((Object)("SSO_" + accessToken));
            if (StringUtils.isEmpty((Object)atcStr)) continue;
            AccessTokenContent accessTokenContent = (AccessTokenContent)JSONObject.parseObject((String)atcStr, AccessTokenContent.class);
            userSessionKey = this.getUserSessionKey(accessTokenContent);
            this.redisTemplate.opsForSet().remove((Object)userSessionKey, new Object[]{accessToken});
            userKey = this.getUserIdKey(accessTokenContent);
            if (!accessTokenContent.getCodeContent().isSendLogoutRequest()) continue;
            this.sendLogoutRequest(accessTokenContent.getCodeContent().getRedirectUri(), accessToken);
        }
        if (StrUtil.isNotBlank((CharSequence)userKey) && StrUtil.isNotBlank((CharSequence)((CharSequence)this.redisTemplate.opsForValue().get((Object)userKey))) && this.redisTemplate.opsForSet().size((Object)userSessionKey) == 0L) {
            this.redisTemplate.delete((Object)userKey);
        }
    }

    @Override
    public List<SsoUser> getOnlineUsers() {
        return this.getOnlineUsers(null);
    }

    @Override
    public List<SsoUser> getOnlineUsers(String userId) {
        Set onlineUserKeys;
        ArrayList<SsoUser> result = new ArrayList<SsoUser>();
        String userIdKey = "UserMonitor:OnLineUser:*";
        if (StrUtil.isNotBlank((CharSequence)userId)) {
            userIdKey = this.getUserIdKey(userId);
        }
        if ((onlineUserKeys = this.redisTemplate.keys((Object)userIdKey)) == null || onlineUserKeys.size() == 0) {
            return result;
        }
        List userStrs = this.redisTemplate.opsForValue().multiGet((Collection)onlineUserKeys);
        for (String userStr : userStrs) {
            if (StrUtil.isBlank((CharSequence)userStr)) continue;
            AccessTokenContent accessTokenContent = (AccessTokenContent)JSONObject.parseObject((String)userStr, AccessTokenContent.class);
            result.add(accessTokenContent.getUser());
        }
        return result;
    }

    private String getTgtKey(String tgt) {
        return "SSO_" + tgt + "_access_token";
    }

    private String getTokenKey(String accessToken) {
        return "SSO_" + accessToken;
    }

    private String getUserIdKey(AccessTokenContent accessTokenContent) {
        return "UserMonitor:OnLineUser:" + accessTokenContent.getUser().getId();
    }

    private String getUserIdKey(String userId) {
        return "UserMonitor:OnLineUser:" + userId;
    }

    private String getUserSessionKey(AccessTokenContent accessTokenContent) {
        return "UserMonitor:Session:" + accessTokenContent.getUser().getId();
    }

    @Override
    public int getExpiresIn() {
        HttpServletRequest request = HttpServletUtil.getRequest();
        if (request != null && ObjectUtil.equal((Object)request.getParameter("appFlag"), (Object)"true")) {
            return this.propertyConfig.getSsoAppTokenTimeout();
        }
        return this.propertyConfig.getSsoTimeout();
    }
}

