/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool.yhxz;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson2.JSON;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.dms.datasource.dao.DmDistrictDao;
import com.geoway.adf.dms.datasource.entity.DmDistrict;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.chat.message.AiToolMessage;
import com.geoway.ns.ai.base.tool.AIToolParam;
import com.geoway.ns.ai.base.tool.AiBaseTool;
import com.geoway.ns.ai.base.tool.AiToolResult;
import com.geoway.ns.ai.tool.yhxz.YhxzToolDefinition;
import com.geoway.ns.ai.tool.yhxz.YhxzToolParam;
import com.geoway.ns.ai.tool.yhxz.YhxzToolResult;
import com.geoway.ns.base.util.CommonsUtil;
import com.geoway.ns.smart.fzxz.dto.FzxzRequestDTO;
import com.geoway.ns.smart.fzxz.entity.FzxzModel;
import com.geoway.ns.smart.fzxz.entity.FzxzModelFactor;
import com.geoway.ns.smart.fzxz.entity.FzxzModelLimitLayer;
import com.geoway.ns.smart.fzxz.entity.FzxzTask;
import com.geoway.ns.smart.fzxz.service.FzxzModelService;
import com.geoway.ns.smart.fzxz.service.FzxzTaskService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class YhxzTool
extends AiBaseTool<YhxzToolParam, YhxzToolDefinition> {
    public static final String TOOL_NAME = "yhxz";

    protected AiToolResult call(YhxzToolParam param) {
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            LoginUserInfo loginUserInfo = YhxzTool.getLoginUserService().getUserInfo(requestAttributes.getRequest());
            YhxzToolResult requestParam = new YhxzToolResult("yhxzParam");
            requestParam.setMessage(JSON.toJSONString((Object)param));
            this.messageInvoke((AiMessage)new AiToolMessage((Object)requestParam, ""));
            FzxzRequestDTO requestDTO = this.transformation(param);
            String taskId = YhxzTool.getFzxzTaskService().createTask(requestDTO, loginUserInfo.getUserId());
            Date start = new Date();
            YhxzToolResult result = new YhxzToolResult();
            while (true) {
                FzxzTask task;
                if ((task = (FzxzTask)YhxzTool.getFzxzTaskService().getById((Serializable)((Object)taskId))).getStatus() == 1 || task.getStatus() == -1) {
                    result.setTask(task);
                    result.setMessage(task.getStatus() == 1 ? "" : task.getMessage());
                    AiToolResult toolResult = new AiToolResult(task.getStatus() == 1 ? "\u5206\u6790\u6210\u529f" : "\u5206\u6790\u5931\u8d25", (Object)result, (AIToolParam)param);
                    return toolResult;
                }
                if (start.getTime() - new Date().getTime() > 600000L) {
                    task.setStatus(Integer.valueOf(-1));
                    result.setMessage("\u7b49\u5f85\u7ed3\u679c\u8d85\u65f6\uff01");
                    AiToolResult aiToolResult = new AiToolResult("\u5206\u6790\u5931\u8d25", (Object)result, (AIToolParam)param);
                    return aiToolResult;
                }
                Thread.sleep(1000L);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private FzxzRequestDTO transformation(YhxzToolParam dto) {
        FzxzRequestDTO param = new FzxzRequestDTO();
        FzxzModel model = YhxzTool.getFzxzModelService().queryDetailName(dto.getModelName());
        ArrayList<FzxzRequestDTO.LimitLayerIParam> limitLayers = new ArrayList<FzxzRequestDTO.LimitLayerIParam>();
        for (YhxzToolParam.LimitLayerIParam limitLayerIParam : dto.getLimitLayers()) {
            FzxzModelLimitLayer filter = (FzxzModelLimitLayer)CommonsUtil.Lists.filter((List)model.getLimitLayers(), f -> f.getLayerAlias().equals(limitLayerIParam.getId()));
            if (filter == null) continue;
            FzxzRequestDTO.LimitLayerIParam layerIParam = new FzxzRequestDTO.LimitLayerIParam();
            layerIParam.setId(filter.getLayerId());
            layerIParam.setLimitType(this.getLimitType(limitLayerIParam.getLimitType()));
            limitLayers.add(layerIParam);
        }
        ArrayList<FzxzRequestDTO.FactorParam> factorParams = new ArrayList<FzxzRequestDTO.FactorParam>();
        for (YhxzToolParam.FactorParam factorParam : dto.getFactorInfo()) {
            FzxzModelFactor filter = (FzxzModelFactor)CommonsUtil.Lists.filter((List)model.getFactors(), f -> f.getFactorName().equals(factorParam.getFid()));
            if (filter == null) continue;
            FzxzRequestDTO.FactorParam factorParam1 = new FzxzRequestDTO.FactorParam();
            factorParam1.setFid(filter.getFactorId());
            factorParam1.setFilterType(this.getFilterType(factorParam.getFilterType()));
            factorParam1.setUnit(this.getUnit(factorParam.getUnit()));
            factorParam1.setFilterValue(factorParam.getFilterValue());
            factorParams.add(factorParam1);
        }
        if (StringUtils.isBlank((CharSequence)dto.getXzqdm())) {
            List list = YhxzTool.getDmDistrictDao().queryByName(dto.getXzqmc());
            DmDistrict district = (DmDistrict)list.get(0);
            dto.setXzqdm(district.getCode());
        }
        param.setModelId(model.getId());
        param.setXzqdm(dto.getXzqdm());
        param.setXzqmc(dto.getXzqmc());
        param.setLandType(model.getYdlx());
        param.setMinArea(dto.getMinArea());
        param.setMaxArea(dto.getMaxArea());
        param.setUnit(dto.getUnit());
        param.setTaskName(dto.getXzqmc() + model.getName());
        param.setLimitLayers(limitLayers);
        param.setFactorInfo(factorParams);
        return param;
    }

    private String getLimitType(String type) {
        String limitType = "";
        switch (type) {
            case "\u7981\u6b62": {
                limitType = "1";
                break;
            }
            case "\u843d\u5165": {
                limitType = "2";
                break;
            }
            case "\u90e8\u5206\u843d\u5165": {
                limitType = "3";
            }
        }
        return limitType;
    }

    private String getFilterType(String type) {
        String filterType = "";
        switch (type) {
            case "\u5927\u4e8e": {
                filterType = "3";
                break;
            }
            case "\u5c0f\u4e8e": {
                filterType = "4";
                break;
            }
            case "\u7b49\u4e8e": {
                filterType = "1";
                break;
            }
            case "\u4e0d\u7b49\u4e8e": {
                filterType = "2";
            }
        }
        return filterType;
    }

    private Integer getUnit(String value) {
        Integer unit = 1;
        switch (value) {
            case "\u7c73": {
                unit = 1;
                break;
            }
            case "\u5343\u7c73": {
                unit = 2;
                break;
            }
            case "\u516c\u91cc": {
                unit = 3;
            }
        }
        return unit;
    }

    private static FzxzModelService getFzxzModelService() {
        return YhxzToolHolder.fzxzModelService;
    }

    private static FzxzTaskService getFzxzTaskService() {
        return YhxzToolHolder.fzxzTaskService;
    }

    private static LoginUserService getLoginUserService() {
        return YhxzToolHolder.loginUserService;
    }

    private static DmDistrictDao getDmDistrictDao() {
        return YhxzToolHolder.dmDistrictDao;
    }

    private static class YhxzToolHolder {
        private static final FzxzModelService fzxzModelService = (FzxzModelService)SpringUtil.getBean(FzxzModelService.class);
        private static final FzxzTaskService fzxzTaskService = (FzxzTaskService)SpringUtil.getBean(FzxzTaskService.class);
        private static final LoginUserService loginUserService = (LoginUserService)SpringUtil.getBean(LoginUserService.class);
        private static final DmDistrictDao dmDistrictDao = (DmDistrictDao)SpringUtil.getBean(DmDistrictDao.class);

        private YhxzToolHolder() {
        }
    }
}

