/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool.znts;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSON;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.chat.message.AiToolMessage;
import com.geoway.ns.ai.base.tool.AIToolParam;
import com.geoway.ns.ai.base.tool.AiBaseTool;
import com.geoway.ns.ai.base.tool.AiToolResult;
import com.geoway.ns.ai.tool.location.LocationResultDTO;
import com.geoway.ns.ai.tool.util.PoiUtil;
import com.geoway.ns.ai.tool.znts.ZntsToolDefinition;
import com.geoway.ns.ai.tool.znts.ZntsToolParam;
import com.geoway.ns.ai.tool.znts.ZntsToolResult;
import com.geoway.ns.base.util.CommonsUtil;
import com.geoway.ns.base.util.GeometryUtils;
import com.geoway.ns.smart.znts.service.ProvincialCloudQueryService;
import com.geoway.ns.smart.zntsnew.dto.CloudAnalaysParamDTO;
import com.geoway.ns.smart.zntsnew.entity.CloudQueryTask;
import com.geoway.ns.smart.zntsnew.service.CloudQueryManageService;
import com.geoway.ns.smart.zntsnew.service.CloudQueryTaskService;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ZntsTool
extends AiBaseTool<ZntsToolParam, ZntsToolDefinition> {
    protected AiToolResult call(ZntsToolParam zntsToolParam) {
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            LoginUserInfo loginUserInfo = ZntsTool.getLoginUserService().getUserInfo(requestAttributes.getRequest());
            ZntsToolResult requestRes = new ZntsToolResult("zntsParam");
            requestRes.setMessage(JSON.toJSONString((Object)zntsToolParam));
            this.messageInvoke((AiMessage)new AiToolMessage((Object)requestRes, ""));
            List<String> wkt = this.getWkt(zntsToolParam.getLocation(), zntsToolParam.getRadius());
            List<String> items = this.getItemIds(loginUserInfo.getUserId(), zntsToolParam.getGroups());
            CloudAnalaysParamDTO param = new CloudAnalaysParamDTO();
            param.setWkts(wkt);
            param.setProvince(items);
            String taskId = ZntsTool.getCloudQueryManageService().addCloudQuery(param, loginUserInfo.getUserId());
            Date start = new Date();
            ZntsToolResult result = new ZntsToolResult();
            while (true) {
                CloudQueryTask task;
                if ((task = ZntsTool.getCloudQueryTaskService().queryInfoById(taskId)).getStatus() == 1 || task.getStatus() == -1) {
                    result.setTask(task);
                    AiToolResult toolResult = new AiToolResult(task.getStatus() == 1 ? "\u5206\u6790\u6210\u529f" : "\u5206\u6790\u5931\u8d25", (Object)result, (AIToolParam)zntsToolParam);
                    return toolResult;
                }
                if (start.getTime() - new Date().getTime() > 600000L) {
                    task.setStatus(Integer.valueOf(-1));
                    AiToolResult aiToolResult = new AiToolResult("\u5206\u6790\u5931\u8d25", (Object)result, (AIToolParam)zntsToolParam);
                    return aiToolResult;
                }
                Thread.sleep(2000L);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<String> getWkt(String location, Integer radius) {
        try {
            List o = this.aiToolContext.getList("geometryList", String.class);
            if (o != null && o.size() > 0) {
                return o;
            }
            List<LocationResultDTO> localtions = PoiUtil.getLocations(location);
            if (localtions != null & localtions.size() != 0) {
                GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
                Point point = geometryFactory.createPoint(new Coordinate(localtions.get(0).getLocation().getLon(), localtions.get(0).getLocation().getLat()));
                point.setSRID(4490);
                final Geometry geometry = GeometryUtils.bufferGeometry((Geometry)point, (int)radius);
                return new ArrayList<String>(){
                    {
                        this.add(geometry.toText());
                    }
                };
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        throw new RuntimeException("\u5730\u540d\u5730\u5740\u83b7\u53d6\u5931\u8d25\uff1a" + location);
    }

    private List<String> getItemIds(String userId, List<ZntsToolParam.ZntsGroupRequest> groups) throws Exception {
        ArrayList<String> ids = new ArrayList<String>();
        Map<String, List> map = groups.stream().collect(Collectors.toMap(a -> a.getName(), a -> a.getItems()));
        List mapList = ZntsTool.getProvincialCloudQueryService().getCloudQueryConfig(null, userId);
        for (Map objectMap : mapList) {
            List service = map.get(objectMap.get("groupType"));
            if (!CollectionUtil.isNotEmpty((Collection)service)) continue;
            ArrayList services = (ArrayList)objectMap.get("services");
            for (String name : service) {
                JSONObject object = (JSONObject)CommonsUtil.Lists.filter((List)services, a -> name.equals(a.getString("serviceAlias")));
                if (object == null) continue;
                ids.add(object.getString("serviceId"));
            }
        }
        return ids;
    }

    private static LoginUserService getLoginUserService() {
        return ZntsToolHolder.loginUserService;
    }

    private static ProvincialCloudQueryService getProvincialCloudQueryService() {
        return ZntsToolHolder.provincialCloudQueryService;
    }

    private static CloudQueryManageService getCloudQueryManageService() {
        return ZntsToolHolder.cloudQueryManageService;
    }

    private static CloudQueryTaskService getCloudQueryTaskService() {
        return ZntsToolHolder.cloudQueryTaskService;
    }

    private static class ZntsToolHolder {
        private static final LoginUserService loginUserService = (LoginUserService)SpringUtil.getBean(LoginUserService.class);
        private static final ProvincialCloudQueryService provincialCloudQueryService = (ProvincialCloudQueryService)SpringUtil.getBean(ProvincialCloudQueryService.class);
        private static final CloudQueryManageService cloudQueryManageService = (CloudQueryManageService)SpringUtil.getBean(CloudQueryManageService.class);
        private static final CloudQueryTaskService cloudQueryTaskService = (CloudQueryTaskService)SpringUtil.getBean(CloudQueryTaskService.class);

        private ZntsToolHolder() {
        }
    }
}

