/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool.util;

import cn.hutool.core.lang.Dict;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateUtil;
import cn.hutool.json.JSONObject;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.district.DistrictItemDTO;
import com.geoway.adf.dms.datasource.dto.query.FilterDTO;
import com.geoway.adf.dms.datasource.service.DistrictService;
import com.geoway.adf.dms.datasource.util.SpatailQueryUtil;
import com.geoway.adf.gis.geodb.filter.SpatialRelationType;
import com.geoway.ns.ai.base.chat.AiChatResult;
import com.geoway.ns.ai.base.chat.client.AiChatClient;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.base.chat.message.AiToolMessage;
import com.geoway.ns.ai.base.tool.AiToolContext;
import com.geoway.ns.ai.tool.aigeometry.AiGeometryToolCallResult;
import com.geoway.ns.ai.tool.location.LocationResultDTO;
import com.geoway.ns.ai.tool.util.AIReturnContentUtil;
import com.geoway.ns.ai.tool.util.PoiUtil;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public class AIGeometryToolUtil {
    private static final String KEY_MESSAGE_GEOMETRY = "KEY_MESSAGE_GEOMETRY";
    private static final String TOOL_CALL_GEOMETRY_WKT = "geometryList";
    private static final String TOOL_CALL_GEOMETRY_RELATION = "relation";
    private static final Template SCHEMA_PROMPT = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig()).getTemplate("\u4ece\u7528\u6237\u7684\u81ea\u7136\u8bed\u8a00\u4e2d\u63d0\u53d6\u51fa\u67e5\u8be2\u7a7a\u95f4\u8303\u56f4\uff0c\u6309\u4ee5\u4e0bjson\u683c\u5f0f\u8f93\u51fa\uff0c\u4e0d\u8981\u5305\u542b\u4efb\u4f55\u89e3\u91ca\u6027\u8bed\u8a00\u3002\n{\n\"address\": \"\u5b57\u7b26\u578b\uff0c\u5fc5\u586b\uff0c\u586b\u5199\u5730\u540d\u5730\u5740\u6216\u884c\u653f\u533a\u4ee3\u7801\uff08\u82e5adderssType\u4e3a'\u884c\u653f\u533a'\uff0c\u9700\u8f6c\u6362\u4e3a\u6807\u51c6\u653f\u533a\u7f16\u7801\uff09\",\n\"addressType\": \"\u679a\u4e3e\u578b\uff0c\u5fc5\u586b\uff0c\u53ef\u9009\u503c\uff1a'\u5730\u540d\u5730\u5740'/'\u884c\u653f\u533a'/'\u65e0'\",\n\"startRadius\": \"\u6574\u578b\uff0c\u5fc5\u586b\uff0c\u7b2c\u4e00\u7f13\u51b2\u533a\u8d77\u59cb\u534a\u5f84\uff08\u5355\u4f4d\uff1a\u7c73\uff0c\u975e\u7c73\u5355\u4f4d\u5c06\u81ea\u52a8\u6362\u7b97\uff09\",\n\"endRadius\": \"\u6574\u578b\uff0c\u5fc5\u586b\uff0c\u7b2c\u4e8c\u7f13\u51b2\u533a\u7ed3\u675f\u534a\u5f84\uff08\u5355\u4f4d\uff1a\u7c73\uff0c\u975e\u7c73\u5355\u4f4d\u5c06\u81ea\u52a8\u6362\u7b97\uff0c\u503c\u5927\u4e8e\u7b2c\u4e00\u7f13\u51b2\u533a\u534a\u5f84\uff09\uff0c\u5f53\u53ea\u6709\u4e00\u4e2a\u7f13\u51b2\u533a\u534a\u5f84\u65f6\uff0c\u503c\u4e3a0\",\n\"relation\": \"\u679a\u4e3e\u578b\uff0c\u5fc5\u586b\uff0c\u53ef\u9009\u503c\uff1a'\u8303\u56f4\u5185'/'\u8303\u56f4\u5916'\"\n}\n\u7528\u6237\u95ee\u9898:${question}");

    public static AiGeometryToolCallResult getGeometry(String message, AiToolContext aiToolContext, Consumer<AiMessage> messageConsumer) {
        if (aiToolContext.containsKey(KEY_MESSAGE_GEOMETRY)) {
            return (AiGeometryToolCallResult)((Object)aiToolContext.get(KEY_MESSAGE_GEOMETRY, AiGeometryToolCallResult.class));
        }
        AiGeometryToolCallResult geometryResult = null;
        List wkts = aiToolContext.getList(TOOL_CALL_GEOMETRY_WKT, String.class);
        if (wkts != null && wkts.size() > 0) {
            geometryResult = new AiGeometryToolCallResult();
            geometryResult.setIsXzq(false);
            FilterDTO filterDTO = new FilterDTO();
            filterDTO.setGeometryList(wkts);
            geometryResult.setShape(SpatailQueryUtil.getFilterGeometry((FilterDTO)filterDTO).toWkt());
            String relation = ((String)aiToolContext.getOrDefault(TOOL_CALL_GEOMETRY_RELATION, String.class, (Object)SpatialRelationType.Intersects.getDesc())).toString();
            geometryResult.setRelationType(SpatialRelationType.valueOf((String)relation));
            return geometryResult;
        }
        String prompt = SCHEMA_PROMPT.render((Map)Dict.create().set("question", (Object)message));
        long start = System.currentTimeMillis();
        AiChatClient chatClient = aiToolContext.getChatClient();
        AiChatResult chatResult = chatClient.chat(prompt, aiToolContext);
        System.out.println("\u81ea\u7136\u8f6c\u7a7a\u95f4\u8303\u56f4\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
        String sqlQuery = AIReturnContentUtil.removeThink(chatResult.getContent());
        sqlQuery = AIReturnContentUtil.removeJson(sqlQuery);
        JSONObject jsonObject = new JSONObject((Object)sqlQuery);
        AiReturnResult aiReturnResult = (AiReturnResult)jsonObject.toBean(AiReturnResult.class);
        switch (aiReturnResult.getAddressType()) {
            case "\u5730\u540d\u5730\u5740": {
                List<LocationResultDTO> pois = PoiUtil.getLocations(aiReturnResult.getAddress());
                if (pois.size() == 0) {
                    return null;
                }
                if (aiReturnResult.getEndRadius() == 0 && aiReturnResult.getStartRadius() == 0 && pois.get(0).getShape().toUpperCase().startsWith("POINT")) {
                    aiReturnResult.setStartRadius(1000);
                }
                String geometry = PoiUtil.getBufferWkt(pois.get(0), aiReturnResult.getStartRadius(), aiReturnResult.getEndRadius());
                geometryResult = new AiGeometryToolCallResult();
                String strBuffer = "";
                if (aiReturnResult.getEndRadius() > 0 && aiReturnResult.getStartRadius() > 0) {
                    strBuffer = String.format("(%s\u7c73-%s\u7c73%s)", aiReturnResult.getStartRadius(), aiReturnResult.getEndRadius(), aiReturnResult.getRelation());
                } else if (aiReturnResult.getEndRadius() > 0) {
                    strBuffer = String.format("(%s\u7c73%s)", aiReturnResult.getEndRadius(), aiReturnResult.getRelation());
                } else if (aiReturnResult.getStartRadius() > 0) {
                    strBuffer = String.format("(%s\u7c73%s)", aiReturnResult.getStartRadius(), aiReturnResult.getRelation());
                }
                geometryResult.setIsXzq(false);
                geometryResult.setAddress(pois.get(0).getAddress() + strBuffer);
                geometryResult.setLocation(PoiUtil.getWkt(pois.get(0)));
                geometryResult.setShape(geometry);
                geometryResult.setName(pois.get(0).getName());
                geometryResult.setRelationType(aiReturnResult.relation.equalsIgnoreCase("\u8303\u56f4\u5916") ? SpatialRelationType.Disjoint : SpatialRelationType.Intersects);
                if (messageConsumer == null) break;
                messageConsumer.accept((AiMessage)new AiToolMessage((Object)geometryResult, "\u5df2\u83b7\u53d6\u5230\u7a7a\u95f4\u8303\u56f4"));
                break;
            }
            case "\u884c\u653f\u533a": {
                DistrictService districtService = (DistrictService)SpringContextUtil.getBean(DistrictService.class);
                DistrictItemDTO districtItemDTO = districtService.getDistrictItemDetail(null, aiReturnResult.getAddress());
                geometryResult = new AiGeometryToolCallResult();
                geometryResult.setIsXzq(true);
                geometryResult.setName(districtItemDTO.getName());
                geometryResult.setAddress(districtItemDTO.getName());
                geometryResult.setShape(districtService.getDistrictItemGeometry(districtItemDTO.getId()).toWkt());
                geometryResult.setLocation(PoiUtil.getWkt(districtItemDTO.getCenterX(), districtItemDTO.getCenterY()));
                geometryResult.setRelationType(aiReturnResult.relation.equalsIgnoreCase("\u8303\u56f4\u5916") ? SpatialRelationType.Disjoint : SpatialRelationType.Intersects);
                if (messageConsumer == null) break;
                messageConsumer.accept((AiMessage)new AiToolMessage((Object)geometryResult, "\u5df2\u83b7\u53d6\u5230\u7a7a\u95f4\u8303\u56f4"));
                break;
            }
        }
        aiToolContext.put(KEY_MESSAGE_GEOMETRY, (Object)geometryResult);
        return geometryResult;
    }

    private static class AiReturnResult {
        private String address;
        private String addressType;
        private int startRadius;
        private int endRadius;
        private String relation;

        public String getAddress() {
            return this.address;
        }

        public String getAddressType() {
            return this.addressType;
        }

        public int getStartRadius() {
            return this.startRadius;
        }

        public int getEndRadius() {
            return this.endRadius;
        }

        public String getRelation() {
            return this.relation;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setAddressType(String addressType) {
            this.addressType = addressType;
        }

        public void setStartRadius(int startRadius) {
            this.startRadius = startRadius;
        }

        public void setEndRadius(int endRadius) {
            this.endRadius = endRadius;
        }

        public void setRelation(String relation) {
            this.relation = relation;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AiReturnResult)) {
                return false;
            }
            AiReturnResult other = (AiReturnResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getStartRadius() != other.getStartRadius()) {
                return false;
            }
            if (this.getEndRadius() != other.getEndRadius()) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            String this$addressType = this.getAddressType();
            String other$addressType = other.getAddressType();
            if (this$addressType == null ? other$addressType != null : !this$addressType.equals(other$addressType)) {
                return false;
            }
            String this$relation = this.getRelation();
            String other$relation = other.getRelation();
            return !(this$relation == null ? other$relation != null : !this$relation.equals(other$relation));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AiReturnResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getStartRadius();
            result = result * 59 + this.getEndRadius();
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            String $addressType = this.getAddressType();
            result = result * 59 + ($addressType == null ? 43 : $addressType.hashCode());
            String $relation = this.getRelation();
            result = result * 59 + ($relation == null ? 43 : $relation.hashCode());
            return result;
        }

        public String toString() {
            return "AIGeometryToolUtil.AiReturnResult(address=" + this.getAddress() + ", addressType=" + this.getAddressType() + ", startRadius=" + this.getStartRadius() + ", endRadius=" + this.getEndRadius() + ", relation=" + this.getRelation() + ")";
        }
    }
}

