/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool;

import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.adf.dms.config.util.ThreadLocalUtil;
import com.geoway.ns.ai.base.chat.dto.AiChatDTO;
import com.geoway.ns.ai.base.chat.message.AiMessage;
import com.geoway.ns.ai.chat.service.impl.AiChatHistoryServiceImpl;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import javax.annotation.Resource;
import org.springframework.context.annotation.Primary;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import reactor.core.publisher.Flux;

@Primary
@Service
public class XxptAiChatHistoryServiceImpl
extends AiChatHistoryServiceImpl {
    private Map<String, LoginUserInfo> userInfoMap = new ConcurrentHashMap<String, LoginUserInfo>();
    private Map<String, RequestAttributes> attributesMap = new ConcurrentHashMap<String, RequestAttributes>();
    @Resource
    private LoginUserService loginUserService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void chat(String pid, String sessionId, AiChatDTO chatDTO, Consumer<AiMessage> messageConsumer) {
        try {
            RequestContextHolder.setRequestAttributes((RequestAttributes)this.attributesMap.get(chatDTO.getUuid()));
            ThreadLocalUtil.addCurrentUser((LoginUserInfo)this.userInfoMap.get(chatDTO.getUuid()));
            super.chat(pid, sessionId, chatDTO, messageConsumer);
        }
        finally {
            this.userInfoMap.remove(chatDTO.getUuid());
            this.attributesMap.remove(chatDTO.getUuid());
        }
    }

    public Flux<ServerSentEvent<AiMessage>> chatStream(String pid, AiChatDTO chatDTO) {
        ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        LoginUserInfo loginUserInfo = this.loginUserService.getUserInfo(requestAttributes.getRequest());
        this.userInfoMap.put(chatDTO.getUuid(), loginUserInfo);
        this.attributesMap.put(chatDTO.getUuid(), (RequestAttributes)requestAttributes);
        return super.chatStream(pid, chatDTO);
    }
}

