/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool.queryonline;

import cn.hutool.json.JSONUtil;
import com.geoway.adf.dms.common.util.StringUtil;
import com.geoway.adf.dms.common.web.SpringContextUtil;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.GeoDatabaseService;
import com.geoway.adf.gis.geodb.IFeatureWorkspace;
import com.geoway.ns.ai.base.tool.AIToolParam;
import com.geoway.ns.ai.base.tool.AiBaseTool;
import com.geoway.ns.ai.base.tool.AiToolResult;
import com.geoway.ns.ai.tool.aisql.AiSqlTool;
import com.geoway.ns.ai.tool.aisql.AiSqlToolCallResult;
import com.geoway.ns.ai.tool.aisql.AiSqlToolParam;
import com.geoway.ns.ai.tool.dto.AiCatalogDataNodeDTO;
import com.geoway.ns.ai.tool.dto.AiSqlResultDTO;
import com.geoway.ns.ai.tool.dto.QueryOnlineResultDTO;
import com.geoway.ns.ai.tool.queryonline.QueryOnlineToolDefinition;
import com.geoway.ns.ai.tool.queryonline.QueryOnlineToolParam;
import com.geoway.ns.ai.tool.queryonline.QueryOnlineToolResult;
import com.geoway.ns.ai.tool.util.AICatalogNodeUtil;
import java.util.List;
import java.util.stream.Collectors;

public class QueryOnlineTool
extends AiBaseTool<QueryOnlineToolParam, QueryOnlineToolDefinition> {
    private GeoDatabaseService geoDatabaseService = (GeoDatabaseService)SpringContextUtil.getBean(GeoDatabaseService.class);

    protected AiToolResult call(QueryOnlineToolParam param) {
        List<AiCatalogDataNodeDTO> relateTables = AICatalogNodeUtil.getCatalogNodesFromCache(this.aiToolContext);
        if (relateTables == null || relateTables.size() == 0) {
            return new AiToolResult("\u672a\u67e5\u8be2\u5230\u7b26\u5408\u6761\u4ef6\u7684\u56fe\u5c42", null, (AIToolParam)param);
        }
        relateTables.forEach(f -> AICatalogNodeUtil.wrapper(f));
        AiSqlToolParam aiSqlToolParam = new AiSqlToolParam();
        aiSqlToolParam.setMessage(this.aiToolContext.getUserInput());
        aiSqlToolParam.setLayers(relateTables.stream().map(f -> f.getNodeName()).collect(Collectors.joining(",")));
        AiSqlTool aiSqlTool = new AiSqlTool();
        AiToolResult toolResult = aiSqlTool.call(aiSqlToolParam, this.aiToolContext, this.aiMessageConsumer);
        AiSqlToolCallResult aiSqlToolCallResult = (AiSqlToolCallResult)((Object)toolResult.getCallResult());
        QueryOnlineToolResult queryOnlineToolResult = new QueryOnlineToolResult();
        String modelResult = "";
        for (AiSqlResultDTO aiSqlResultDTO : aiSqlToolCallResult.getSqlResults()) {
            DataSourceDTO dataSourceDTO = aiSqlResultDTO.getLayers().get(0).getDataset().getDataSource();
            String sql = StringUtil.trimEnd((String)aiSqlResultDTO.getSql(), (String)";");
            String countSql = String.format("select count(0) from (%s) t", sql);
            String limitSql = String.format("select * from  (%s) t %s ", sql, aiSqlResultDTO.getIsStat() != false ? "" : "limit 5");
            IFeatureWorkspace featureWorkspace = this.geoDatabaseService.openGeoWorkspace(dataSourceDTO.getKey());
            try {
                QueryOnlineResultDTO queryOnlineResult = new QueryOnlineResultDTO();
                queryOnlineResult.setCatalogId(aiSqlResultDTO.getLayers().get(0).getNodeId());
                queryOnlineResult.setCatalogName(aiSqlResultDTO.getLayers().get(0).getNodeName());
                long count = (Long)featureWorkspace.queryScalar(countSql, new Object[0]);
                queryOnlineResult.setTotal(count);
                queryOnlineResult.setData(featureWorkspace.queryList(limitSql, new Object[0]));
                queryOnlineResult.setStat(aiSqlResultDTO.getIsStat());
                queryOnlineToolResult.getQueryOnlineResults().add(queryOnlineResult);
                if (aiSqlResultDTO.getIsStat().booleanValue()) {
                    modelResult = modelResult + String.format("\u5df2\u5728\u56fe\u5c42\u3010%s\u3011\u7edf\u8ba1\u5230\u76f8\u5173\u6570\u636e\uff1a%s\n", aiSqlResultDTO.getLayers().get(0).getNodeName(), JSONUtil.toJsonStr(queryOnlineResult.getData()));
                    continue;
                }
                modelResult = modelResult + String.format("\u5df2\u5728\u56fe\u5c42\u3010%s\u3011\u67e5\u8be2\u5230%s\u6761\u76f8\u5173\u6570\u636e\uff0c\u8fd4\u56de\u5176\u4e2d\u7684%s\u6761\u6570\u636e\uff1a%s\n", aiSqlResultDTO.getLayers().get(0).getNodeName(), JSONUtil.toJsonStr((Object)queryOnlineResult), count, queryOnlineResult.getData().size());
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            finally {
                if (featureWorkspace == null) continue;
                featureWorkspace.close();
            }
        }
        return new AiToolResult(modelResult, (Object)queryOnlineToolResult, (AIToolParam)param);
    }
}

