/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool.util;

import cn.hutool.core.net.url.UrlQuery;
import cn.hutool.core.util.CharsetUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import com.geoway.ns.ai.tool.location.LocationResultDTO;
import com.geoway.ns.ai.tool.util.AgiParamConfigUtil;
import com.geoway.ns.base.util.GeometryUtils;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.geotools.geometry.jts.JTSFactoryFinder;

public class PoiUtil {
    public static List<LocationResultDTO> getLocations(String address) {
        String poiUrl = AgiParamConfigUtil.getParam("poi-api");
        if (poiUrl.contains("amap")) {
            return PoiUtil.getLocationsFromAmap(poiUrl, address);
        }
        return PoiUtil.getLocationsFromIme(poiUrl, address);
    }

    public static String getBufferWkt(LocationResultDTO location, Integer radius) {
        try {
            GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
            Point point = geometryFactory.createPoint(new Coordinate(location.getLocation().getLon(), location.getLocation().getLat()));
            point.setSRID(4490);
            Geometry geometry = GeometryUtils.bufferGeometry((Geometry)point, (int)radius);
            return geometry.toText();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String getWkt(LocationResultDTO location) {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        Point point = geometryFactory.createPoint(new Coordinate(location.getLocation().getLon(), location.getLocation().getLat()));
        point.setSRID(4490);
        return point.toText();
    }

    public static String getWkt(double lon, double lat) {
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        Point point = geometryFactory.createPoint(new Coordinate(lon, lat));
        point.setSRID(4490);
        return point.toText();
    }

    public static String getBufferWkt(LocationResultDTO location, Integer startRadius, Integer endRadius) {
        try {
            if (startRadius == 0 && endRadius == 0) {
                return "";
            }
            Geometry geometry = GeometryUtils.wktToGeometry((String)location.getShape());
            geometry.setSRID(4490);
            Geometry startGeometry = null;
            if (startRadius > 0) {
                startGeometry = GeometryUtils.bufferGeometry((Geometry)geometry, (int)startRadius);
            }
            Geometry endGeometry = null;
            if (endRadius > 0 && endRadius > startRadius) {
                endGeometry = GeometryUtils.bufferGeometry((Geometry)geometry, (int)endRadius);
            }
            Geometry resultGeometry = null;
            resultGeometry = startGeometry != null && endGeometry != null ? endGeometry.difference(startGeometry) : (startGeometry != null ? startGeometry : (endGeometry != null ? endGeometry : geometry));
            return resultGeometry.toText();
        }
        catch (Exception exception) {
            throw new RuntimeException("\u5730\u540d\u5730\u5740\u83b7\u53d6\u5931\u8d25\uff1a" + location, exception);
        }
    }

    private static List<LocationResultDTO> getLocationsFromAmap(String poiUrl, String address) {
        poiUrl = poiUrl + "&address=" + address;
        String queryresult = HttpUtil.get((String)poiUrl);
        JSONObject jsonObject = JSONUtil.parseObj((String)queryresult);
        ArrayList<LocationResultDTO> result = new ArrayList<LocationResultDTO>();
        JSONArray geoArray = jsonObject.getJSONArray((Object)"geocodes");
        if (geoArray == null || geoArray.size() == 0) {
            return new ArrayList<LocationResultDTO>();
        }
        String key = ((CharSequence)UrlQuery.of((String)poiUrl, (Charset)CharsetUtil.CHARSET_UTF_8).getQueryMap().get("key")).toString();
        Integer i = 0;
        while (i < geoArray.size()) {
            JSONObject geoObject = geoArray.getJSONObject((Object)i);
            LocationResultDTO resultDTO = new LocationResultDTO();
            String locations = geoObject.getStr((Object)"location");
            String[] split = locations.split(",");
            resultDTO.getLocation().setLon(Double.valueOf(split[0]));
            resultDTO.getLocation().setLat(Double.valueOf(split[1]));
            resultDTO.setAddress(geoObject.getStr((Object)"formatted_address"));
            resultDTO.setOid(i.toString());
            resultDTO.setName(geoObject.getStr((Object)"formatted_address"));
            String poiId = PoiUtil.getPoiIDFromAmap(resultDTO.getAddress(), key);
            String aoiWkt = PoiUtil.getAOIWktFromAmap(poiId, key);
            if (StrUtil.isBlank((CharSequence)aoiWkt)) {
                resultDTO.setShape(PoiUtil.getWkt(Double.valueOf(split[0]), Double.valueOf(split[1])));
            } else {
                resultDTO.setShape(aoiWkt);
            }
            result.add(resultDTO);
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        }
        return result;
    }

    private static String getPoiIDFromAmap(String address, String key) {
        String poiUrl = String.format("https://restapi.amap.com/v3/place/text?key=%s&keywords=%s", key, address);
        String queryResult = HttpUtil.get((String)poiUrl);
        JSONObject jsonObject = JSONUtil.parseObj((String)queryResult);
        if (!jsonObject.getStr((Object)"status").equalsIgnoreCase("1")) {
            return "";
        }
        ArrayList result = new ArrayList();
        JSONArray poisArray = jsonObject.getJSONArray((Object)"pois");
        if (poisArray == null || poisArray.size() == 0) {
            return "";
        }
        return poisArray.getJSONObject((Object)0).getStr((Object)"id");
    }

    private static String getAOIWktFromAmap(String aoiId, String key) {
        String[] points;
        if (StrUtil.isBlank((CharSequence)aoiId)) {
            return "";
        }
        String aoiUrl = String.format("https://restapi.amap.com/v5/aoi/polyline?key=%s&id=%s", key, aoiId);
        String queryResult = HttpUtil.get((String)aoiUrl);
        JSONObject jsonObject = JSONUtil.parseObj((String)queryResult);
        if (!jsonObject.getStr((Object)"status").equalsIgnoreCase("1")) {
            return "";
        }
        if (jsonObject.getInt((Object)"count") <= 0) {
            return "";
        }
        JSONArray aoiArray = jsonObject.getJSONArray((Object)"aois");
        String polyline = aoiArray.getJSONObject((Object)0).getStr((Object)"polyline", "");
        if (StrUtil.isBlank((CharSequence)polyline)) {
            return "";
        }
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (String point : points = polyline.split("_")) {
            String[] split = point.split(",");
            coordinates.add(new Coordinate(Double.parseDouble(split[0]), Double.parseDouble(split[1])));
        }
        GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
        Polygon polygon = geometryFactory.createPolygon(coordinates.toArray(new Coordinate[coordinates.size()]));
        return polygon.toText();
    }

    private static List<LocationResultDTO> getLocationsFromIme(String poiUrl, String address) {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("format", "json");
        paramMap.put("page_num", 0);
        paramMap.put("page_size", 5);
        paramMap.put("q", address);
        String result = HttpUtil.get((String)poiUrl, paramMap);
        if (StrUtil.isBlank((CharSequence)result)) {
            return new ArrayList<LocationResultDTO>();
        }
        JSONObject jsonObject = JSONUtil.parseObj((String)result);
        if (!jsonObject.containsKey((Object)"status")) {
            return new ArrayList<LocationResultDTO>();
        }
        if (!jsonObject.getStr((Object)"status").equals("ok")) {
            return new ArrayList<LocationResultDTO>();
        }
        if (!jsonObject.containsKey((Object)"results")) {
            return new ArrayList<LocationResultDTO>();
        }
        if (jsonObject.getJSONArray((Object)"results").size() == 0) {
            return new ArrayList<LocationResultDTO>();
        }
        List locations = JSONUtil.toList((JSONArray)jsonObject.getJSONArray((Object)"results"), LocationResultDTO.class);
        locations.forEach(f -> {
            if (StrUtil.isBlank((CharSequence)f.getShape())) {
                f.setShape(PoiUtil.getWkt(f));
            }
        });
        return locations;
    }
}

