/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.ai.tool.znts;

import cn.hutool.extra.spring.SpringUtil;
import com.geoway.adf.dms.config.dto.user.LoginUserInfo;
import com.geoway.adf.dms.config.service.LoginUserService;
import com.geoway.ns.ai.base.tool.AiToolDefinition;
import com.geoway.ns.smart.znts.service.ProvincialCloudQueryService;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ZntsToolDefinition
implements AiToolDefinition {
    public static final String TOOL_NAME = "znts";

    public LoginUserService getLoginUserService() {
        return ServiceHolder.LOGIN_USER_SERVICE;
    }

    public ProvincialCloudQueryService getProvincialCloudQueryService() {
        return ServiceHolder.PROVINCIAL_CLOUD_QUERY_SERVICE;
    }

    public String name() {
        return TOOL_NAME;
    }

    public String description() {
        return "\u667a\u80fd\u56fe\u5ba1\u5de5\u5177(\u8fd9\u7c7b\u5de5\u5177\u90fd\u662f\u6700\u540e\u4e00\u4e2a\u5de5\u5177\u8c03\u7528)\uff0c\u662f\u4e00\u6b3e\u57fa\u4e8e\u5730\u7406\u7a7a\u95f4\u4f4d\u7f6e\u7684\u4e13\u4e1a\u5206\u6790\u5de5\u5177\uff0c\u53ef\u4ee5\u6839\u636e\u6307\u5b9a\u5730\u70b9\u6216\u7a7a\u95f4\u4f4d\u7f6e\u8fdb\u884c\u591a\u7ef4\u5ea6\u548c\u591a\u4e3b\u9898\u7684\u7a7a\u95f4\u6570\u636e\u67e5\u8be2\u548c\u5206\u6790\uff0c\u80fd\u591f\u6574\u5408\u67e5\u8be2\u5305\u62ec\u571f\u5730\u5206\u7c7b\u3001\u4e09\u533a\u4e09\u7ebf\u3001\u571f\u5730\u5229\u7528\u73b0\u72b6\u7b49\u5728\u5185\u7684\u5185\u5bb9\uff0c\u652f\u6301\u901a\u8fc7\u7075\u6d3b\u5206\u7ec4\uff08\u57fa\u7840\u67e5\u8be2\u3001\u89c4\u5212\u67e5\u8be2\u3001\u5386\u5e74\u73b0\u72b6\u7b49\uff09\u7ec4\u5408\u6240\u9700\u5206\u6790\u9879\uff0c\u4e3a\u571f\u5730\u8d44\u6e90\u8bc4\u4f30\u3001\u89c4\u5212\u5408\u89c4\u6027\u5ba1\u67e5\u3001\u751f\u6001\u4fdd\u62a4\u76d1\u7ba1\u3001\u5386\u53f2\u53d8\u8fc1\u5206\u6790\u7b49\u63d0\u4f9b\u9ad8\u6548\u4e14\u5168\u9762\u7684\u7a7a\u95f4\u6570\u636e\u652f\u6301\u4e0e\u51b3\u7b56\u8f85\u52a9\uff0c\u540c\u65f6\u652f\u6301\u751f\u6210\u62a5\u544a\u3002\u8fd4\u56de\u7684\u5206\u6790\u9879\u5fc5\u987b\u8981\u5b58\u5728\u4e8e\u5206\u7ec4\u89c4\u5219\u4e2d\uff0c\u89c4\u5219\u5982\u4e0b\uff1a" + this.getAnalysis();
    }

    public String inputSchema() {
        return "{\n\t\"type\": \"function\",\n\t\"function\": {\n\t\t\"name\": \"znts\",\n\t\t\"description\": \"" + this.description() + "\",\n\t\t\"parameters\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"properties\": {\n\t\t\t\t\"location\": {\n\t\t\t\t\t\"type\": \"string\",\n\t\t\t\t\t\"description\": \"\u5206\u6790\u70b9\u4f4d\u5730\u5740\uff08\u5982\uff1a\u94f6\u5ddd\u5e02\u9a6c\u5170\u82b1\u5e7f\u573a\uff09\"\n\t\t\t\t},\n\t\t\t\t\"radius\": {\n\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\"description\": \"\u5206\u6790\u70b9\u4f4d\u534a\u5f84\uff08\u5355\u4f4d\uff1a\u7c73 \uff0c\u9ed8\u8ba4100\u7c73\uff09\",\n\t\t\t\t\t\"default\": 100\n\t\t\t\t},\n\t\t\t\t\"groups\": {\n\t\t\t\t\t\"type\": \"array\",\n\t\t\t\t\t\"description\": \"\u5206\u6790\u7ec4\u914d\u7f6e\uff0c\u6ce8\u610f\uff1a\u6839\u636e\u5bf9\u8bdd\u5185\u5bb9\u5c06\u5206\u6790\u9879\u9700\u6309\u5206\u7ec4\u89c4\u5219\u9009\u62e9\",\n\t\t\t\t\t\"items\": {\n\t\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\t\"type\": \"string\",\n\t\t\t\t\t\t\t\t\"description\": \"\u5206\u7ec4\u7c7b\u578b\"\n\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\"items\": {\n\t\t\t\t\t\t\t\t\"type\": \"array\",\n\t\t\t\t\t\t\t\t\"items\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"string\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"required\": [\"name\", \"items\"]\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"is_final_tool\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"description\": \"\u662f\u5426\u662f\u6700\u540e\u4e00\u4e2a\u88ab\u8c03\u7528\u7684\u5de5\u5177,\u4f7f\u7528\u9ed8\u8ba4\u503c\",\n\t\t\t\t\t\"default\": true\n\t\t\t\t}\n\t\t\t},\n\t\t\t\"required\": [\"is_final_tool\"],\n\t\t\t\"examples\": [{\n\t\t\t\t\"location\": \"\u94f6\u5ddd\u5e02\u9a6c\u5170\u82b1\u5e7f\u573a\",\n\t\t\t\t\"radius\": 100,\n\t\t\t\t\"groups\": [{\n\t\t\t\t\t\t\"name\": \"\u57fa\u7840\u67e5\u8be2\",\n\t\t\t\t\t\t\"items\": [\"\u571f\u5730\u5206\u7c7b\", \"\u6c38\u4e45\u57fa\u672c\u519c\u7530\"]\n\t\t\t\t\t},\n\t\t\t\t\t{\n\t\t\t\t\t\t\"name\": \"\u571f\u5730\u7ba1\u7406\",\n\t\t\t\t\t\t\"items\": [\"\u571f\u5730\u4f9b\u5e94\"]\n\t\t\t\t\t}\n\t\t\t\t]\n\t\t\t}]\n\t\t}\n\t}\n}";
    }

    private String getAnalysis() {
        try {
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            LoginUserInfo loginUserInfo = this.getLoginUserService().getUserInfo(requestAttributes.getRequest());
            List mapList = this.getProvincialCloudQueryService().getCloudQueryConfig(null, loginUserInfo.getUserId());
            StringBuilder sbr = new StringBuilder();
            for (Map map : mapList) {
                String type = map.get("groupType").toString();
                sbr.append(type).append("\u5305\u542b");
                List services = (List)map.get("services");
                List names = services.stream().map(m -> m.getString("serviceAlias")).collect(Collectors.toList());
                sbr.append(String.join((CharSequence)"\u3001", names));
                sbr.append("\uff1b");
            }
            return sbr.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static class ServiceHolder {
        private static final LoginUserService LOGIN_USER_SERVICE = (LoginUserService)SpringUtil.getBean(LoginUserService.class);
        private static final ProvincialCloudQueryService PROVINCIAL_CLOUD_QUERY_SERVICE = (ProvincialCloudQueryService)SpringUtil.getBean(ProvincialCloudQueryService.class);

        private ServiceHolder() {
        }
    }
}

