/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.analy.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONReader;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogDataNodeDTO;
import com.geoway.adf.dms.catalog.dto.res.ResCatalogNodeDTO;
import com.geoway.adf.dms.catalog.service.impl.ResCatalogNodeServiceImpl;
import com.geoway.adf.dms.config.dto.sysparam.SysParamDTO;
import com.geoway.adf.dms.config.dto.sysparam.SysParamGroupDTO;
import com.geoway.adf.dms.config.service.SysParamsService;
import com.geoway.adf.dms.datasource.dto.datasource.DataSourceDTO;
import com.geoway.adf.dms.datasource.service.DataSourceService;
import com.geoway.ns.analy.constant.AtlasConstant;
import com.geoway.ns.analy.dto.AtlasParamTypeDTO;
import com.geoway.ns.analy.dto.TaskStatusInfoDTO;
import com.geoway.ns.analy.dto.ZxfxParamDTO;
import com.geoway.ns.analy.dto.ZxfxParamGroupDTO;
import com.geoway.ns.analy.entity.TbZxfxModel;
import com.geoway.ns.analy.entity.TbZxfxModelParam;
import com.geoway.ns.analy.enums.DataBaseType;
import com.geoway.ns.analy.enums.EnumValueType;
import com.geoway.ns.analy.enums.ModelParamTypeEnum;
import com.geoway.ns.analy.enums.TaskStatusEnum;
import com.geoway.ns.analy.service.AnalysisNewService;
import com.geoway.ns.analy.vo.TbZxfxModelVO;
import com.geoway.ns.analy.vo.ZxfxModelGroupVO;
import com.geoway.ns.analy.vo.ZxfxTaskLogVO;
import com.geoway.ns.geoserver3.service.IDatabaseService;
import com.geoway.ns.sys.dto.PageDataResponse;
import com.geoway.ns.sys.dto.PageParam;
import com.geoway.ns.sys.enums.SysParamGroupEnum;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AltasAnalysisServiceImpl
implements AnalysisNewService {
    @Autowired
    private DataSourceService dataSourceService;
    @Autowired
    private SysParamsService sysParamsService;
    @Autowired
    private IDatabaseService databaseService;
    @Autowired
    private ResCatalogNodeServiceImpl resCatalogService;

    @Override
    public Integer getType() {
        return 1;
    }

    @Override
    public TbZxfxModel convertToModel(String serviceId) {
        List<JSONObject> list;
        JSONObject result = this.getModelInfo(serviceId);
        TbZxfxModel model = new TbZxfxModel();
        model.setServiceId(result.getString("id"));
        model.setName(result.getString("alias"));
        model.setDesc(result.getString("desc"));
        model.setType(this.getType());
        model.setRegisterTime(new Date());
        List<Object> list2 = list = result.getJSONArray("publicParamMetas") == null ? new ArrayList<JSONObject>() : result.getJSONArray("publicParamMetas").toJavaList(JSONObject.class);
        if (list.size() > 0) {
            List<ZxfxParamGroupDTO> group = this.getModelParamGroup(serviceId);
            list = this.paramFilter(result.getJSONArray("argjson"), list);
            model.setParams(this.convertToModelParams(list, group));
        } else {
            model.setParams(new ArrayList<TbZxfxModelParam>());
        }
        return model;
    }

    @Override
    public String analysis(TbZxfxModel model, List<ZxfxParamDTO> analysisParam) {
        JSONObject modelInfo = this.getModelInfo(model.getServiceId());
        String name = modelInfo.getString("name");
        String url = AtlasConstant.Api.POST_ATLAS_ANALYSIS + "/" + name;
        HttpRequest http = this.getHttp(Method.POST, url);
        SysParamGroupDTO sysParamGroupDTO = this.sysParamsService.getGroupDetail(AtlasConstant.SYS_PARAM_GROUP_ATLAS_TASK_ADVANCED_SETTING);
        SysParamDTO strategyParamDTO = sysParamGroupDTO.getParams().stream().filter(p -> Objects.equals(p.getKey(), AtlasConstant.SYS_PARAM_ATLAS_TASK_STRATEGY)).findFirst().get();
        SysParamDTO priorityParamDTO = sysParamGroupDTO.getParams().stream().filter(p -> Objects.equals(p.getKey(), AtlasConstant.SYS_PARAM_ATLAS_TASK_PRIORITY)).findFirst().get();
        SysParamDTO queueParamDTO = sysParamGroupDTO.getParams().stream().filter(p -> Objects.equals(p.getKey(), AtlasConstant.SYS_PARAM_ATLAS_TASK_QUEUE)).findFirst().get();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("priority", Integer.parseInt(priorityParamDTO.getValue()));
        map.put("strategy", Integer.parseInt(strategyParamDTO.getValue()));
        map.put("queue", Integer.parseInt(queueParamDTO.getValue()));
        map.put("svcRequestArgs", this.getAnalysisParam(analysisParam, model.getParams()));
        http.body(JSON.toJSONString(map));
        JSONObject result = (JSONObject)this.getResult(http);
        return result.getString("taskId");
    }

    @Override
    public List<ZxfxModelGroupVO> getModelList(String name) {
        HttpRequest http = this.getHttp(Method.GET, AtlasConstant.Api.GET_SERVICE_SEARCH);
        http.form("name", (Object)name);
        JSONObject result = (JSONObject)this.getResult(http);
        ArrayList list = result.getJSONArray("items") == null ? new ArrayList() : result.getJSONArray("items").toJavaList(JSONObject.class);
        List models = list.stream().map(m -> TbZxfxModelVO.builder().id(m.getString("id")).name(m.getString("alias")).groupId(m.getString("categoryId")).build()).collect(Collectors.toList());
        Map<String, List<TbZxfxModelVO>> map = models.stream().collect(Collectors.groupingBy(TbZxfxModelVO::getGroupId));
        List<ZxfxModelGroupVO> modelCatalog = this.getModelCatalog();
        modelCatalog.forEach(f -> f.setModels((List)map.get(f.getId())));
        return modelCatalog;
    }

    private List<JSONObject> paramFilter(com.alibaba.fastjson.JSONArray argjson, List<JSONObject> params) {
        ArrayList<JSONObject> result = new ArrayList();
        if (argjson != null && argjson.size() > 0) {
            List objectList = argjson.toJavaList(com.alibaba.fastjson2.JSONObject.class);
            for (com.alibaba.fastjson2.JSONObject json : objectList) {
                JSONArray children = json.getJSONArray("children");
                if (children == null) continue;
                List list = children.toJavaList(com.alibaba.fastjson2.JSONObject.class, new JSONReader.Feature[0]);
                List name = list.stream().map(m -> m.getString("name")).collect(Collectors.toList());
                String groupId = json.getString("id");
                List collect = params.stream().filter(f -> groupId.equals(f.getString("categoryId")) && name.contains(f.getString("name"))).collect(Collectors.toList());
                result.addAll(collect);
            }
        } else {
            result = params;
        }
        return result;
    }

    private List<ZxfxParamGroupDTO> getModelParamGroup(String serviceId) {
        HttpRequest http = this.getHttp(Method.GET, AtlasConstant.Api.GET_SERVICE_ALLPARAMS);
        http.form("id", (Object)serviceId);
        JSONObject result = (JSONObject)this.getResult(http);
        ArrayList list = result.getJSONArray("items") == null ? new ArrayList() : result.getJSONArray("items").toJavaList(JSONObject.class);
        return list.stream().map(m -> {
            ZxfxParamGroupDTO build = ZxfxParamGroupDTO.builder().vid(m.getString("actionId")).build();
            String name = m.getString("jobName");
            int index = name.lastIndexOf("-");
            build.setName(index > 0 ? name.substring(0, index) : name);
            List paramList = m.getJSONArray("paramList").toJavaList(JSONObject.class);
            List<JSONObject> proto = paramList.stream().map(p -> p.getJSONObject("proto")).collect(Collectors.toList());
            build.setParamTypes(proto);
            return build;
        }).collect(Collectors.toList());
    }

    private JSONObject getModelInfo(String serviceId) {
        HttpRequest http = this.getHttp(Method.GET, AtlasConstant.Api.GET_SERVICE);
        http.form("id", (Object)serviceId);
        return (JSONObject)this.getResult(http);
    }

    public List<ZxfxModelGroupVO> getModelCatalog() {
        HttpRequest http = this.getHttp(Method.GET, AtlasConstant.Api.GET_SERVICE_CATEGORIES);
        JSONObject result = (JSONObject)this.getResult(http);
        return result.getJSONArray("items") == null ? new ArrayList<ZxfxModelGroupVO>() : result.getJSONArray("items").toJavaList(ZxfxModelGroupVO.class);
    }

    @Override
    public TaskStatusInfoDTO getAnalysisInfo(String analysisId) {
        Boolean finished;
        HttpRequest http = this.getHttp(Method.GET, AtlasConstant.Api.GET_TASK);
        http.form("id", (Object)analysisId);
        JSONObject result = null;
        try {
            result = (JSONObject)this.getResult(http);
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message.contains("\u672a\u627e\u5230\u4efb\u52a1")) {
                return null;
            }
            throw new RuntimeException(e.getMessage());
        }
        TaskStatusInfoDTO statusInfo = TaskStatusInfoDTO.builder().progress(result.getInteger("progress")).analysisId(analysisId).build();
        String startTime = result.getString("startTime");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{startTime})) {
            statusInfo.setStartTime(LocalDateTime.parse(startTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
        }
        if ((finished = result.getBoolean("finished")).booleanValue()) {
            String endTime = result.getString("endTime");
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{endTime})) {
                statusInfo.setEndTime(LocalDateTime.parse(endTime, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss")));
            }
            statusInfo.setStatus(result.getBoolean("succeed") != false ? TaskStatusEnum.SUCCESS.value : TaskStatusEnum.ERROR.value);
        } else {
            statusInfo.setStatus("Running".equals(result.getString("state")) ? TaskStatusEnum.RUNNING.value : TaskStatusEnum.QUEUE.value);
        }
        return statusInfo;
    }

    @Override
    public PageDataResponse<ZxfxTaskLogVO> queryLogInfo(PageParam pageParam, final String analysisId) {
        PageDataResponse response = new PageDataResponse();
        String path = AtlasConstant.Api.POST_LOG_PAGE + "?applicationName=AtlasServer&currentPage=" + pageParam.getCurrent() + "&pageSize=" + pageParam.getSize();
        HttpRequest http = this.getHttp(Method.POST, path);
        http.form("applicationName", (Object)"AtlasServer");
        http.form("currentPage", (Object)pageParam.getCurrent());
        http.form("pageSize", (Object)pageParam.getSize());
        http.body(JSON.toJSONString((Object)new HashMap<String, String>(){
            {
                this.put("taskId", analysisId);
            }
        }));
        JSONObject result = (JSONObject)this.getResult(http);
        com.alibaba.fastjson.JSONArray content = result.getJSONArray("content");
        if (content != null && content.size() > 0) {
            List list = content.toJavaList(JSONObject.class);
            List logs = list.stream().map(m -> {
                ZxfxTaskLogVO build = ZxfxTaskLogVO.builder().id(m.getString("id")).taskId(m.getString("taskId")).message(m.getString("message")).build();
                String timeStamp = m.getString("timeStamp");
                LocalDateTime parse = LocalDateTime.parse(timeStamp, DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"));
                build.setTime(parse);
                return build;
            }).collect(Collectors.toList());
            response.setResult(logs);
        }
        response.setCurrent(Long.valueOf(pageParam.getCurrent().longValue()));
        response.setSize(Long.valueOf(pageParam.getSize().longValue()));
        response.setTotal(Long.valueOf(result.getLongValue("recordTotal")));
        return response;
    }

    private HttpRequest getHttp(Method method, String path) {
        SysParamDTO detail = this.sysParamsService.getDetail(SysParamGroupEnum.API.value, AtlasConstant.SYS_PARAM_ATLAS_API);
        String api = detail.getValue();
        return HttpUtil.createRequest((Method)method, (String)(api + path));
    }

    private Object getResult(HttpRequest http) {
        HttpResponse execute = http.execute();
        String error = "atlas\u63a5\u53e3\u8c03\u7528\u5931\u8d25\u3010%s\u3011\uff1a";
        if (execute.getStatus() != 200) {
            throw new RuntimeException(String.format(error, http.getUrl()) + execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        int code = object.getIntValue("code");
        if (code != 200) {
            throw new RuntimeException(String.format(error, http.getUrl()) + object.getString("msg"));
        }
        return object.get((Object)"data");
    }

    private List<TbZxfxModelParam> convertToModelParams(List<JSONObject> list, List<ZxfxParamGroupDTO> group) {
        return list.stream().map(m -> {
            ZxfxParamGroupDTO groupDTO = group.stream().filter(f -> f.getVid().equals(m.getString("categoryId"))).findFirst().orElse(null);
            TbZxfxModelParam param = new TbZxfxModelParam();
            param.setName(m.getString("name"));
            JSONObject paramPrototype = m.getJSONObject("paramPrototype");
            JSONObject paramType = null;
            if (paramPrototype == null) {
                List<JSONObject> params = groupDTO.getParamTypes();
                for (JSONObject json : params) {
                    if (!json.getString("name").equals(param.getName())) continue;
                    paramType = json;
                }
            } else {
                paramType = paramPrototype;
            }
            if (paramType != null) {
                if ("Output".equals(paramType.getString("direction"))) {
                    param.setType(ModelParamTypeEnum.Output_LayerTable.type);
                } else if ("layer".equals(paramType.getString("label")) && EnumValueType.String.type.equals(paramType.getString("paramType"))) {
                    param.setType(ModelParamTypeEnum.Node.type);
                } else {
                    param.setType(EnumValueType.getRelation(paramType.getString("paramType")));
                }
                param.setOriginType(paramType.getString("paramType"));
                param.setDesc(paramType.getString("desc"));
            }
            param.setAlias(m.getString("alias"));
            param.setGroup(groupDTO.getName());
            param.setRequired(m.getBoolean("must") != false ? 1 : 0);
            param.setDefaultValue(m.getString("valueString"));
            param.setParam(String.valueOf(m));
            param.setOriginAlias(m.getString("alias"));
            return param;
        }).collect(Collectors.toList());
    }

    private List<Map<String, Object>> getAnalysisParam(List<ZxfxParamDTO> analysisParam, List<TbZxfxModelParam> params) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (final ZxfxParamDTO dto : analysisParam) {
            TbZxfxModelParam param = params.stream().filter(f -> f.getId().equals(dto.getId())).findFirst().orElse(null);
            if (param == null) continue;
            ModelParamTypeEnum paramType = ModelParamTypeEnum.getEnumByType(param.getType());
            switch (paramType) {
                case Output_LayerTable: {
                    String value = dto.getValue();
                    String[] split = value.split(",");
                    String dbkey = split[0];
                    String tableName = split[1];
                    DataSourceDTO sourceDetail = this.dataSourceService.getDataSourceDetail(dbkey);
                    String source = DataBaseType.getValue(sourceDetail.getDataSourceType());
                    String jdbcUrl = "jdbc:" + source + "://" + sourceDetail.getUserName() + "/" + sourceDetail.getPassword() + "@" + sourceDetail.getUrl() + "/public." + tableName;
                    dto.setValue(jdbcUrl);
                    break;
                }
                case SDatebase: {
                    break;
                }
                case Node: {
                    ResCatalogDataNodeDTO resCatalogDataNodeDTO = this.getResCataDataByNodeId(dto.getValue());
                    dto.setValue("adf:" + resCatalogDataNodeDTO.getDataset().getId());
                    break;
                }
                case ComboYearNode: {
                    String[] nodeIdList;
                    String values = "";
                    String nodeIds = dto.getValue();
                    for (String nodeId : nodeIdList = nodeIds.split(";")) {
                        ResCatalogDataNodeDTO resCataData = this.getResCataDataByNodeId(dto.getValue());
                        String str = "adf:" + resCataData.getDataset().getId() + ";";
                        values = values + str;
                    }
                    dto.setValue(values);
                    break;
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)param.getParam())) continue;
            final AtlasParamTypeDTO atlasParamType = (AtlasParamTypeDTO)JSON.parseObject((String)param.getParam(), AtlasParamTypeDTO.class);
            result.add((Map<String, Object>)new HashMap<String, Object>(){
                {
                    this.put("vid", atlasParamType.getCategoryId());
                    this.put("pname", dto.getName());
                    this.put("pvalue", dto.getValue());
                }
            });
        }
        return result;
    }

    private ResCatalogDataNodeDTO getResCataDataByNodeId(String nodeId) {
        ResCatalogNodeDTO resCatalogNodeDTO = this.resCatalogService.getNodeDetail(nodeId);
        return (ResCatalogDataNodeDTO)resCatalogNodeDTO;
    }
}

