/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.analy.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.geoway.ns.analy.entity.TbZxfxCatalog;
import com.geoway.ns.analy.entity.TbZxfxModel;
import com.geoway.ns.analy.entity.TbZxfxModelParam;
import com.geoway.ns.analy.mapper.TbZxfxCatalogMapper;
import com.geoway.ns.analy.mapper.TbZxfxModelMapper;
import com.geoway.ns.analy.service.AnalysisNewService;
import com.geoway.ns.analy.service.TbZxfxModelParamService;
import com.geoway.ns.analy.service.TbZxfxModelService;
import com.geoway.ns.analy.service.ZxfxCommonService;
import com.geoway.ns.analy.utils.BizCommonUtil;
import com.geoway.ns.analy.vo.ZxfxModelGroupVO;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TbZxfxModelServiceImpl
extends ServiceImpl<TbZxfxModelMapper, TbZxfxModel>
implements TbZxfxModelService {
    @Autowired
    private TbZxfxModelParamService tbZxfxModelParamService;
    @Autowired
    private TbZxfxModelMapper tbZxfxModelMapper;
    @Autowired
    private TbZxfxCatalogMapper zxfxCatalogMapper;
    @Autowired
    private ZxfxCommonService zxfxCommonService;

    @Override
    public List<TbZxfxModel> queryList(String groupId) {
        return this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxModel.class).eq(TbZxfxModel::getGroupId, (Object)groupId)).orderByDesc(TbZxfxModel::getOrder));
    }

    @Override
    public TbZxfxModel queryDetail(String id) {
        TbZxfxModel model = (TbZxfxModel)this.getById((Serializable)((Object)id));
        BizCommonUtil.objectVerify(model, "\u672a\u67e5\u8be2\u5230\u6a21\u578b\uff01");
        List<TbZxfxModelParam> params = this.tbZxfxModelParamService.queryByModelId(id);
        model.setParams(params);
        return model;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void registerModel(Integer type, String groupId, String serviceId) {
        TbZxfxModel zxfxModel = (TbZxfxModel)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxModel.class).eq(TbZxfxModel::getGroupId, (Object)groupId)).eq(TbZxfxModel::getServiceId, (Object)serviceId));
        BizCommonUtil.objectNullVerify(zxfxModel, "\u8be5\u5206\u7ec4\u5df2\u6ce8\u518c\u8fc7\u76f8\u540c\u6a21\u578b\uff01");
        AnalysisNewService analysisNewService = this.zxfxCommonService.findAnalysisService(type);
        TbZxfxModel model = analysisNewService.convertToModel(serviceId);
        model.setGroupId(groupId);
        model.setRegisterTime(new Date());
        this.saveOrUpdateInfo(model);
        int order = 1;
        for (TbZxfxModelParam param : model.getParams()) {
            param.setModelId(model.getId());
            param.setId(UUID.randomUUID().toString());
            param.setOrder(order++);
        }
        this.tbZxfxModelParamService.saveBatch(model.getParams());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void syncModel(String id) {
        TbZxfxModel existModel = this.queryDetail(id);
        List<TbZxfxModelParam> existParams = existModel.getParams();
        AnalysisNewService analysisNewService = this.zxfxCommonService.findAnalysisService(existModel.getType());
        TbZxfxModel newModel = analysisNewService.convertToModel(existModel.getServiceId());
        List<TbZxfxModelParam> newParams = newModel.getParams();
        List delParamIds = existParams.stream().filter(exist -> newParams.stream().noneMatch(newP -> Objects.equals(exist.getName(), newP.getName()))).map(TbZxfxModelParam::getId).collect(Collectors.toList());
        List addParams = newParams.stream().filter(newP -> existParams.stream().noneMatch(exist -> Objects.equals(exist.getName(), newP.getName()) && Objects.equals(exist.getParam(), newP.getParam()))).collect(Collectors.toList());
        Integer maxOrder = 1;
        for (TbZxfxModelParam exist2 : existParams) {
            if (exist2.getOrder() < maxOrder) continue;
            maxOrder = maxOrder + 1;
        }
        for (TbZxfxModelParam param : addParams) {
            param.setModelId(id);
            param.setId(UUID.randomUUID().toString());
            Integer n = maxOrder;
            Integer n2 = maxOrder = Integer.valueOf(maxOrder + 1);
            param.setOrder(n);
        }
        this.tbZxfxModelParamService.saveBatch(addParams);
        this.tbZxfxModelParamService.removeByIds(delParamIds);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean saveOrUpdateInfo(TbZxfxModel zxfxModel) {
        if (StringUtils.isBlank((CharSequence)zxfxModel.getName())) {
            throw new RuntimeException("\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((CharSequence)zxfxModel.getGroupId())) {
            throw new RuntimeException("\u5206\u7ec4\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!Objects.equals(zxfxModel.getType(), 1) && !Objects.equals(zxfxModel.getType(), 2)) {
            throw new RuntimeException("\u7c7b\u578b\u9519\u8bef\uff0c\u5fc5\u987b\u4e3a1\uff08atlas\uff09,\u6216\u80052\uff08geoserver3\uff09");
        }
        if (StringUtils.isBlank((CharSequence)zxfxModel.getServiceId())) {
            throw new RuntimeException("serviceId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)zxfxModel.getId())) {
            zxfxModel.setId(UUID.randomUUID().toString());
            Integer order = this.tbZxfxModelMapper.selectMaxOrder(zxfxModel.getGroupId());
            order = order == null ? 1 : order + 1;
            zxfxModel.setOrder(order);
            return this.save(zxfxModel);
        }
        this.tbZxfxModelParamService.updateBatchById(zxfxModel.getParams());
        return this.updateById(zxfxModel);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteById(String id) {
        TbZxfxCatalog catalog = (TbZxfxCatalog)this.zxfxCatalogMapper.selectOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxCatalog.class).eq(TbZxfxCatalog::getModelId, (Object)id)).last("limit 1"));
        if (ObjectUtil.isNotEmpty((Object)catalog)) {
            throw new RuntimeException("\u5220\u9664\u5931\u8d25\uff0c\u5df2\u6302\u63a5\u76ee\u5f55\u8282\u70b9\u3010" + catalog.getName() + "\u3011");
        }
        this.tbZxfxModelParamService.deleteByModel(id);
        return this.removeById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteMulti(String ids) {
        String[] idsArray;
        if (StringUtils.isEmpty((CharSequence)ids)) {
            return false;
        }
        for (String id : idsArray = ids.split(",")) {
            this.deleteById(id);
        }
        return true;
    }

    @Override
    public boolean deleteByGroupId(String groupId) {
        List<TbZxfxModel> models = this.queryList(groupId);
        for (TbZxfxModel model : models) {
            this.deleteById(model.getId());
        }
        return true;
    }

    @Override
    public boolean moveToFirst(String id) {
        return this.sort(id, 1);
    }

    @Override
    public boolean moveToLast(String id) {
        TbZxfxModel curModel = (TbZxfxModel)this.getById((Serializable)((Object)id));
        if (curModel == null) {
            return false;
        }
        TbZxfxModel maxModel = (TbZxfxModel)this.list((Wrapper)Wrappers.lambdaQuery(TbZxfxModel.class).orderByDesc(TbZxfxModel::getOrder)).get(0);
        return this.sort(id, maxModel.getOrder());
    }

    @Override
    public boolean moveToPre(String id) {
        TbZxfxModel maxModel = (TbZxfxModel)this.getById((Serializable)((Object)id));
        if (maxModel == null) {
            return false;
        }
        if (maxModel.getOrder().equals(1)) {
            return true;
        }
        return this.sort(id, maxModel.getOrder() - 1);
    }

    @Override
    public boolean moveToNext(String id) {
        TbZxfxModel curModel = (TbZxfxModel)this.getById((Serializable)((Object)id));
        if (curModel == null) {
            return false;
        }
        int maxOrder = this.tbZxfxModelMapper.selectMaxOrder(curModel.getGroupId());
        if (curModel.getOrder().equals(maxOrder)) {
            return true;
        }
        return this.sort(id, curModel.getOrder() + 1);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean sort(String id, int order) {
        TbZxfxModel curModel = (TbZxfxModel)this.getById((Serializable)((Object)id));
        if (curModel == null) {
            return true;
        }
        if (curModel.getOrder().equals(order)) {
            return true;
        }
        List needUpdateList = null;
        if (curModel.getOrder() > order) {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxModel.class).ge(TbZxfxModel::getOrder, (Object)order)).lt(TbZxfxModel::getOrder, (Object)curModel.getOrder())).orderByAsc(TbZxfxModel::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbZxfxModel)needUpdateList.get(i)).setOrder(order + i + 1);
            }
        } else {
            needUpdateList = this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(TbZxfxModel.class).gt(TbZxfxModel::getOrder, (Object)curModel.getOrder())).le(TbZxfxModel::getOrder, (Object)order)).orderByAsc(TbZxfxModel::getOrder));
            for (int i = 0; i < needUpdateList.size(); ++i) {
                ((TbZxfxModel)needUpdateList.get(i)).setOrder(curModel.getOrder() + i);
            }
        }
        curModel.setOrder(order);
        needUpdateList.add(curModel);
        return this.updateBatchById(needUpdateList);
    }

    @Override
    public List<ZxfxModelGroupVO> sourceList(Integer type, String name) {
        AnalysisNewService analysisService = this.zxfxCommonService.findAnalysisService(type);
        return analysisService.getModelList(name);
    }
}

