/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.base.config;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Set;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.Query;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ServerConfig
implements ApplicationListener<WebServerInitializedEvent> {
    private static final Logger log = LoggerFactory.getLogger(ServerConfig.class);
    @Value(value="${server.servlet.context-path}")
    private String contextPath;
    @Value(value="${server.port}")
    private String serverPort;

    public String getUrl() {
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
            if (ObjectUtil.isNotNull((Object)address)) {
                return "http://" + address.getHostAddress() + ":" + this.serverPort + this.contextPath;
            }
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String getRemoteHost(HttpServletRequest request) {
        String ip = request.getHeader("x-forwarded-for");
        if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (StrUtil.isBlank((CharSequence)ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        return ip.equals("0:0:0:0:0:0:0:1") ? "127.0.0.1" : ip;
    }

    public void onApplicationEvent(WebServerInitializedEvent event) {
        String serverPort = String.valueOf(event.getWebServer().getPort());
        if (StrUtil.isBlank((CharSequence)serverPort)) {
            serverPort = this.getTomcatPort();
        }
        this.serverPort = serverPort;
    }

    private String getTomcatPort() {
        String port = "";
        Set<ObjectName> objectNames = null;
        try {
            MBeanServer beanServer = ManagementFactory.getPlatformMBeanServer();
            objectNames = beanServer.queryNames(new ObjectName("*:type=Connector,*"), Query.match(Query.attr("protocol"), Query.value("HTTP/1.1")));
            port = objectNames.iterator().next().getKeyProperty("port");
            log.info("\u5f53\u524dtomcat\u7684\u8fd0\u884c\u7aef\u53e3\u5df2\u83b7\u53d6\u6210\u529f\uff01\u5bf9\u5e94\u7684\u7aef\u53e3\u4e3a:{}", (Object)port);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
            log.error(e.getMessage());
        }
        return port;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ServerConfig)) {
            return false;
        }
        ServerConfig other = (ServerConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$contextPath = this.getContextPath();
        String other$contextPath = other.getContextPath();
        if (this$contextPath == null ? other$contextPath != null : !this$contextPath.equals(other$contextPath)) {
            return false;
        }
        String this$serverPort = this.getServerPort();
        String other$serverPort = other.getServerPort();
        return !(this$serverPort == null ? other$serverPort != null : !this$serverPort.equals(other$serverPort));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ServerConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $contextPath = this.getContextPath();
        result = result * 59 + ($contextPath == null ? 43 : $contextPath.hashCode());
        String $serverPort = this.getServerPort();
        result = result * 59 + ($serverPort == null ? 43 : $serverPort.hashCode());
        return result;
    }

    public String toString() {
        return "ServerConfig(contextPath=" + this.getContextPath() + ", serverPort=" + this.getServerPort() + ")";
    }
}

