/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.dto.ServiceMetadataDAO;
import com.geoway.ns.geoserver3.dto.TbAnalysisBaseInfo;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.ITbAnalysisBaseInfoService;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TbAnalysisBaseInfoServiceImpl
implements ITbAnalysisBaseInfoService {
    private String RequestMapping = "/rest/manage/servicebase";
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;

    @Override
    public List<TbAnalysisBaseInfo> findByType(String type) {
        String url = this.geoserver3ConfigService.getUrl();
        String findUrl = url + this.RequestMapping + "/findByType?type=" + type;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return JSON.parseArray((String)resultStr, TbAnalysisBaseInfo.class);
        }
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisBaseInfo findById(String id) {
        String url = this.geoserver3ConfigService.getUrl();
        String findUrl = url + this.RequestMapping + "/findDetail?id=" + id;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisBaseInfo)JSON.parseObject((String)resultStr, TbAnalysisBaseInfo.class);
        }
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public ServiceMetadataDAO metadata(String type, String serviceName) {
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + "/rest/" + type + "/" + serviceName + "/metadata";
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (ServiceMetadataDAO)JSON.parseObject((String)resultStr, ServiceMetadataDAO.class);
        }
        throw new RuntimeException(responseObj.getString("Message"));
    }
}

