/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.dto.GLFXResult;
import com.geoway.ns.geoserver3.dto.TbAnalysisGLFXDetail;
import com.geoway.ns.geoserver3.service.IGLFXService;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3GrantService;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GLFXServiceImpl
implements IGLFXService {
    private static final Logger log = LoggerFactory.getLogger(GLFXServiceImpl.class);
    private String RequestMapping = "/rest/manage/glfx";
    private String analysisMapping = "/rest/glfx";
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;
    @Autowired
    private IGeoserver3GrantService geoserver3GrantService;

    @Override
    public boolean checkIsExist(String serviceName) {
        String url = this.geoserver3ConfigService.getUrl();
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String findUrl = url + this.RequestMapping + "/checkIsExist?serviceName=" + serviceName;
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return false;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            return responseObj.getBoolean("Results");
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisGLFXDetail findById(String serviceId) {
        String url = this.geoserver3ConfigService.getUrl();
        String findUrl = url + this.RequestMapping + "/findDetail?id=" + serviceId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisGLFXDetail)JSON.parseObject((String)resultStr, TbAnalysisGLFXDetail.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisGLFXDetail findByName(String name) {
        String url = this.geoserver3ConfigService.getUrl();
        String findUrl = url + this.RequestMapping + "/findByName?name=" + name;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisGLFXDetail)JSON.parseObject((String)resultStr, TbAnalysisGLFXDetail.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisGLFXDetail findByServerUrl(String serverUrl, String accessKey) {
        String findUrl = serverUrl.split("/glfx/")[0] + "/manage/glfx/findByName?name=" + serverUrl.split("/glfx/")[1];
        String responseStr = ((HttpRequest)HttpRequest.get((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisGLFXDetail)JSON.parseObject((String)resultStr, TbAnalysisGLFXDetail.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisGLFXDetail save(TbAnalysisGLFXDetail glfxDetail) {
        String url = this.geoserver3ConfigService.getUrl();
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String saveUrl = url + this.RequestMapping + "/save";
        String paramMapStr = JSON.toJSONString((Object)glfxDetail);
        String responseStr = ((HttpRequest)HttpRequest.post((String)saveUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            TbAnalysisGLFXDetail detail = (TbAnalysisGLFXDetail)JSON.parseObject((String)resultStr, TbAnalysisGLFXDetail.class);
            this.geoserver3GrantService.grantedById(this.geoserver3ConfigService.getApplicationGuid(), detail.getId());
            return detail;
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public boolean delete(String serviceId) {
        String url = this.geoserver3ConfigService.getUrl();
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String findUrl = url + this.RequestMapping + "/delete?id=" + serviceId;
        String responseStr = ((HttpRequest)HttpRequest.post((String)findUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return false;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            return true;
        }
        log.error(responseObj.getString("Message"));
        return false;
    }

    @Override
    public List<GLFXResult> analysis(Map<String, Object> param, String serviceName) {
        this.geoserver3ConfigService.check();
        param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        param.put("saverecord", this.geoserver3ConfigService.saveRecord());
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/" + serviceName;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String paramMapStr = JSON.toJSONString(param);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            List results = JSONArray.parseArray((String)resultStr, GLFXResult.class);
            return results;
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public List<GLFXResult> analysis(String serverUrl, Map<String, Object> param, String ApplicationGUID, String accessKey) {
        param.put("ApplicationGUID", ApplicationGUID);
        param.put("saverecord", this.geoserver3ConfigService.saveRecord());
        String url = this.geoserver3ConfigService.getUrl();
        String paramMapStr = JSON.toJSONString(param);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            List results = JSONArray.parseArray((String)resultStr, GLFXResult.class);
            return results;
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }
}

