/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.HttpUtil;
import cn.hutool.http.Method;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.dto.TbAnalysisTask;
import com.geoway.ns.geoserver3.dto.TbAnalysisTaskFilter;
import com.geoway.ns.geoserver3.dto.TbAnalysisTaskLog;
import com.geoway.ns.geoserver3.dto.TbAnalysisTaskPageResult;
import com.geoway.ns.geoserver3.dto.TbAnalysisTaskParam;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import com.geoway.ns.geoserver3.service.IGeoserver3TaskService;
import com.geoway.ns.sys.utils.UpAndDownloadUtil;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Geoserver3TaskServiceImpl
implements IGeoserver3TaskService {
    private static final Logger log = LoggerFactory.getLogger(Geoserver3TaskServiceImpl.class);
    private String RequestMapping = "/rest/task";
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;

    @Override
    public TbAnalysisTask findTaskById(String taskId) {
        this.checkVersion();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.RequestMapping + "/findTaskById?taskId=" + taskId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisTask)JSON.parseObject((String)resultStr, TbAnalysisTask.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public List<TbAnalysisTask> findTaskByIds(List<String> taskIds) {
        this.checkVersion();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.RequestMapping + "/findTaskByIds?taskIds=" + String.join((CharSequence)",", taskIds);
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return JSON.parseArray((String)resultStr, TbAnalysisTask.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public List<TbAnalysisTask> findSubTasks(String taskId) {
        this.checkVersion();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.RequestMapping + "/findSubTasks?taskId=" + taskId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return JSON.parseArray((String)resultStr, TbAnalysisTask.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public TbAnalysisTaskParam findTaskParam(String taskId) {
        this.checkVersion();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.RequestMapping + "/findTaskParam?taskId=" + taskId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return (TbAnalysisTaskParam)JSON.parseObject((String)resultStr, TbAnalysisTaskParam.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public List<TbAnalysisTaskLog> findTaskLog(String taskId) {
        this.checkVersion();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.RequestMapping + "/findTaskLog?taskId=" + taskId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            return JSON.parseArray((String)resultStr, TbAnalysisTaskLog.class);
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public JSONObject findResult(String taskId) {
        this.checkVersion();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.RequestMapping + "/findResult?taskId=" + taskId;
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String responseStr = ((HttpRequest)HttpRequest.get((String)serverUrl).header("access-token", accessKey)).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public TbAnalysisTaskPageResult findTaskByFilter(TbAnalysisTaskFilter filter) {
        this.checkVersion();
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.RequestMapping + "/findTaskByFilter";
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String filterStr = JSON.toJSONString((Object)filter);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(filterStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            return null;
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        if (responseObj.getInteger("StatusCode").equals(200)) {
            String resultStr = responseObj.getString("Results");
            if (StringUtils.isEmpty((CharSequence)resultStr)) {
                return null;
            }
            List list = JSON.parseArray((String)resultStr, TbAnalysisTask.class);
            int total = responseObj.getInteger("total");
            int totalPage = responseObj.getInteger("totalPage");
            TbAnalysisTaskPageResult pageResult = new TbAnalysisTaskPageResult();
            pageResult.setTotal(total);
            pageResult.setTotalPage(totalPage);
            pageResult.setList(list);
            return pageResult;
        }
        log.error(responseObj.getString("Message"));
        throw new RuntimeException(responseObj.getString("Message"));
    }

    @Override
    public void exportReport(HttpServletResponse response, String taskId) {
        HttpRequest http = this.createHttp(Method.POST, "/rest/report/exportByTaskId");
        http.form("taskId", (Object)taskId);
        HttpResponse execute = http.execute();
        String type = execute.header("Content-Type");
        if (type.equals("application/json")) {
            this.getRes(execute);
        } else {
            UpAndDownloadUtil.downloadFile((HttpServletResponse)response, (InputStream)execute.bodyStream(), (Map)execute.headers());
        }
    }

    private HttpRequest createHttp(Method method, String path) {
        String url = this.geoserver3ConfigService.getUrl() + path;
        HttpRequest request = HttpUtil.createRequest((Method)method, (String)url);
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        request.header("access-token", accessKey);
        return request;
    }

    private JSONObject getRes(HttpResponse execute) {
        if (execute.getStatus() != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u8c03\u7528\u5931\u8d25\uff1a" + execute.body());
        }
        JSONObject object = JSON.parseObject((String)execute.body());
        if (object.getIntValue("StatusCode") != 200) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff1a" + object.getString("Message"));
        }
        return object;
    }

    private void checkVersion() {
        String version = this.geoserver3ConfigService.getVersion();
        Double dVersion = Double.parseDouble(version);
        if (dVersion < 3.1) {
            throw new RuntimeException("\u8bf7\u5e94\u7528\u652f\u6491\u670d\u52a1\u5f15\u64ce\u7248\u672c\u81f33.1\u6216\u4ee5\u4e0a\u7248\u672c");
        }
    }
}

