/*
 * Decompiled with CFR 0.152.
 */
package com.geoway.ns.geoserver3.service.impl;

import cn.hutool.http.HttpRequest;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.geoway.ns.geoserver3.service.IDroneService;
import com.geoway.ns.geoserver3.service.IGeoserver3ConfigService;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DroneServiceImpl
implements IDroneService {
    private static final Logger log = LoggerFactory.getLogger(DroneServiceImpl.class);
    private String RequestMapping = "/rest/manage/yzfx";
    private String analysisMapping = "/rest/drone";
    @Autowired
    private IGeoserver3ConfigService geoserver3ConfigService;

    @Override
    public boolean checkIsExist(String serviceName) {
        return false;
    }

    @Override
    public JSONObject queryList(Map<String, Object> param, String serviceName) {
        this.geoserver3ConfigService.check();
        param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        if (!param.containsKey("saverecord")) {
            param.put("saverecord", this.geoserver3ConfigService.saveRecord());
        }
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/" + serviceName + "/queryList";
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String paramMapStr = JSON.toJSONString(param);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject getLiveUrl(Map<String, Object> param, String serviceName) {
        this.geoserver3ConfigService.check();
        param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        if (!param.containsKey("saverecord")) {
            param.put("saverecord", this.geoserver3ConfigService.saveRecord());
        }
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/" + serviceName + "/getLiveUrl";
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String paramMapStr = JSON.toJSONString(param);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }

    @Override
    public JSONObject getDroneOnOff(Map<String, Object> param, String serviceName) {
        this.geoserver3ConfigService.check();
        param.put("ApplicationGUID", this.geoserver3ConfigService.getApplicationGuid());
        if (!param.containsKey("saverecord")) {
            param.put("saverecord", this.geoserver3ConfigService.saveRecord());
        }
        String url = this.geoserver3ConfigService.getUrl();
        String serverUrl = url + this.analysisMapping + "/" + serviceName + "/getDroneOnOff";
        String accessKey = this.geoserver3ConfigService.getAccessKey();
        String paramMapStr = JSON.toJSONString(param);
        String responseStr = ((HttpRequest)HttpRequest.post((String)serverUrl).header("access-token", accessKey)).body(paramMapStr).execute().body();
        if (StringUtils.isEmpty((CharSequence)responseStr)) {
            throw new RuntimeException("\u5206\u6790\u670d\u52a1\u5f15\u64ce\uff1a\u7f51\u7edc\u8bf7\u6c42\u5931\u8d25");
        }
        JSONObject responseObj = JSON.parseObject((String)responseStr);
        return responseObj;
    }
}

